/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.logging;

import io.embrace.android.embracesdk.capture.metadata.MetadataService;
import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.config.remote.NetworkCaptureRuleRemoteConfig;
import io.embrace.android.embracesdk.internal.network.http.NetworkCaptureData;
import io.embrace.android.embracesdk.internal.serialization.EmbraceSerializer;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.network.logging.NetworkCaptureDataSource;
import io.embrace.android.embracesdk.network.logging.NetworkCaptureEncryptionManager;
import io.embrace.android.embracesdk.network.logging.NetworkCaptureService;
import io.embrace.android.embracesdk.payload.NetworkCapturedCall;
import io.embrace.android.embracesdk.prefs.PreferencesService;
import io.embrace.android.embracesdk.session.id.SessionIdTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0000\u0018\u0000 32\u00020\u0001:\u00013BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u0017H\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0002JD\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u0010*\u001a\u0004\u0018\u00010\u0017H\u0016J\u001c\u0010+\u001a\u0004\u0018\u00010\u00172\b\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020&H\u0002J \u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020&2\u0006\u0010#\u001a\u00020$H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lio/embrace/android/embracesdk/network/logging/EmbraceNetworkCaptureService;", "Lio/embrace/android/embracesdk/network/logging/NetworkCaptureService;", "metadataService", "Lio/embrace/android/embracesdk/capture/metadata/MetadataService;", "sessionIdTracker", "Lio/embrace/android/embracesdk/session/id/SessionIdTracker;", "preferencesService", "Lio/embrace/android/embracesdk/prefs/PreferencesService;", "networkCaptureDataSource", "Lkotlin/Function0;", "Lio/embrace/android/embracesdk/network/logging/NetworkCaptureDataSource;", "Lio/embrace/android/embracesdk/internal/utils/Provider;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "serializer", "Lio/embrace/android/embracesdk/internal/serialization/EmbraceSerializer;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "(Lio/embrace/android/embracesdk/capture/metadata/MetadataService;Lio/embrace/android/embracesdk/session/id/SessionIdTracker;Lio/embrace/android/embracesdk/prefs/PreferencesService;Lkotlin/jvm/functions/Function0;Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/internal/serialization/EmbraceSerializer;Lio/embrace/android/embracesdk/logging/EmbLogger;)V", "networkCaptureEncryptionManager", "Lkotlin/Lazy;", "Lio/embrace/android/embracesdk/network/logging/NetworkCaptureEncryptionManager;", "encryptNetworkCall", "", "capturedNetworkCall", "Lio/embrace/android/embracesdk/payload/NetworkCapturedCall;", "getNetworkCaptureRules", "", "Lio/embrace/android/embracesdk/config/remote/NetworkCaptureRuleRemoteConfig;", "url", "method", "getNetworkPayload", "logNetworkCapturedData", "", "httpMethod", "statusCode", "", "startTime", "", "endTime", "networkCaptureData", "Lio/embrace/android/embracesdk/internal/network/http/NetworkCaptureData;", "errorMessage", "parseBody", "body", "", "maxSize", "shouldApplyRule", "", "rule", "duration", "Companion", "embrace-android-sdk_release"})
public final class EmbraceNetworkCaptureService
implements NetworkCaptureService {
    private final Lazy<NetworkCaptureEncryptionManager> networkCaptureEncryptionManager;
    private final MetadataService metadataService;
    private final SessionIdTracker sessionIdTracker;
    private final PreferencesService preferencesService;
    private final Function0<NetworkCaptureDataSource> networkCaptureDataSource;
    private final ConfigService configService;
    private final EmbraceSerializer serializer;
    private final EmbLogger logger;
    public static final int NETWORK_ERROR_CODE = -1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Set<NetworkCaptureRuleRemoteConfig> getNetworkCaptureRules(@NotNull String url, @NotNull String method) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Set networkCaptureRules = CollectionsKt.toMutableSet((Iterable)this.configService.getNetworkBehavior().getNetworkCaptureRules());
        if (networkCaptureRules.isEmpty()) {
            EmbLogger.DefaultImpls.logDebug$default(this.logger, "No network capture rules", null, 2, null);
            return SetsKt.emptySet();
        }
        String string2 = url;
        CharSequence charSequence = this.configService.getSdkEndpointBehavior().getData(this.metadataService.getAppId());
        if (string2.contentEquals(charSequence)) {
            EmbLogger.DefaultImpls.logDebug$default(this.logger, "Cannot intercept Embrace endpoints", null, 2, null);
            return SetsKt.emptySet();
        }
        Iterable $this$filter$iv = networkCaptureRules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String string3;
            NetworkCaptureRuleRemoteConfig rule = (NetworkCaptureRuleRemoteConfig)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.contains$default((CharSequence)rule.getMethod(), (CharSequence)method, (boolean)false, (int)2, null) && new Regex(string3 = rule.getUrlRegex()).containsMatchIn((CharSequence)url) && rule.getExpiresIn() > 0L)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set applicableRules = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Set rulesToRemove = new LinkedHashSet();
        Iterable $this$forEach$iv = applicableRules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NetworkCaptureRuleRemoteConfig rule = (NetworkCaptureRuleRemoteConfig)element$iv;
            boolean bl = false;
            if (!this.preferencesService.isNetworkCaptureRuleOver(rule.getId())) continue;
            rulesToRemove.add(rule);
        }
        networkCaptureRules.removeAll(rulesToRemove);
        applicableRules.removeAll(rulesToRemove);
        EmbLogger.DefaultImpls.logDebug$default(this.logger, "Capture rule is: " + applicableRules, null, 2, null);
        return applicableRules;
    }

    @Override
    public void logNetworkCapturedData(@NotNull String url, @NotNull String httpMethod, int statusCode, long startTime, long endTime, @Nullable NetworkCaptureData networkCaptureData, @Nullable String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)httpMethod, (String)"httpMethod");
        long l = endTime - startTime;
        long l2 = 0L;
        long duration = Math.max(l, l2);
        Iterable $this$forEach$iv = this.getNetworkCaptureRules(url, httpMethod);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            NetworkCaptureRuleRemoteConfig rule = (NetworkCaptureRuleRemoteConfig)element$iv;
            boolean bl = false;
            if (this.shouldApplyRule(rule, duration, statusCode)) {
                NetworkCaptureData networkCaptureData2 = networkCaptureData;
                String requestBody = this.parseBody((byte[])(networkCaptureData2 != null ? networkCaptureData2.getCapturedRequestBody() : null), rule.getMaxSize());
                Object object = networkCaptureData;
                if (object == null || (object = ((NetworkCaptureData)object).getDataCaptureErrorMessage()) == null) {
                    NetworkCaptureData networkCaptureData3 = networkCaptureData;
                    object = this.parseBody((byte[])(networkCaptureData3 != null ? networkCaptureData3.getCapturedResponseBody() : null), rule.getMaxSize());
                }
                Object responseBody = object;
                this.preferencesService.decreaseNetworkCaptureRuleRemainingCount(rule.getId(), rule.getMaxCount());
                NetworkCaptureData networkCaptureData4 = networkCaptureData;
                NetworkCaptureData networkCaptureData5 = networkCaptureData;
                NetworkCaptureData networkCaptureData6 = networkCaptureData;
                NetworkCaptureData networkCaptureData7 = networkCaptureData;
                NetworkCaptureData networkCaptureData8 = networkCaptureData;
                NetworkCaptureData networkCaptureData9 = networkCaptureData;
                NetworkCaptureData networkCaptureData10 = networkCaptureData;
                NetworkCapturedCall capturedNetworkCall = new NetworkCapturedCall(duration, endTime, httpMethod, rule.getUrlRegex(), null, requestBody, networkCaptureData4 != null ? Integer.valueOf(networkCaptureData4.getRequestBodySize()) : null, networkCaptureData5 != null ? networkCaptureData5.getRequestQueryParams() : null, networkCaptureData6 != null ? networkCaptureData6.getRequestHeaders() : null, networkCaptureData7 != null ? Integer.valueOf(networkCaptureData7.getRequestBodySize()) : null, (String)responseBody, networkCaptureData8 != null ? Integer.valueOf(networkCaptureData8.getResponseBodySize()) : null, networkCaptureData9 != null ? networkCaptureData9.getResponseHeaders() : null, networkCaptureData10 != null ? Integer.valueOf(networkCaptureData10.getResponseBodySize()) : null, statusCode, this.sessionIdTracker.getActiveSessionId(), startTime, url, errorMessage, null, 524304, null);
                NetworkCapturedCall networkLog = this.getNetworkPayload(capturedNetworkCall);
                ((NetworkCaptureDataSource)this.networkCaptureDataSource.invoke()).logNetworkCapturedCall(networkLog);
                return;
            }
            EmbLogger.DefaultImpls.logDebug$default(this.logger, "The captured data doesn't match the rule criteria", null, 2, null);
        }
    }

    private final NetworkCapturedCall getNetworkPayload(NetworkCapturedCall capturedNetworkCall) {
        NetworkCapturedCall networkCapturedCall;
        if (this.configService.getNetworkBehavior().isCaptureBodyEncryptionEnabled()) {
            String encryptedPayload = this.encryptNetworkCall(capturedNetworkCall);
            networkCapturedCall = new NetworkCapturedCall(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, encryptedPayload, 524287, null);
        } else {
            networkCapturedCall = capturedNetworkCall;
        }
        return networkCapturedCall;
    }

    private final String encryptNetworkCall(NetworkCapturedCall capturedNetworkCall) {
        String string2 = this.configService.getNetworkBehavior().getCapturePublicKey();
        if (string2 == null) {
            return null;
        }
        String capturePublicKey = string2;
        return ((NetworkCaptureEncryptionManager)this.networkCaptureEncryptionManager.getValue()).encrypt(this.serializer.toJson(capturedNetworkCall), capturePublicKey);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldApplyRule(NetworkCaptureRuleRemoteConfig rule, long duration, int statusCode) {
        if (!rule.getStatusCodes().contains(statusCode)) return false;
        if (rule.getDuration() == null) return true;
        Long l = rule.getDuration();
        if (l != null && l == 0L) {
            return true;
        }
        if (duration < rule.getDuration()) return false;
        return true;
    }

    private final String parseBody(byte[] body, long maxSize) {
        if (body != null) {
            byte[] byArray;
            byte[] it = byArray = body;
            boolean bl = false;
            Number endIndex = (long)it.length > maxSize ? (Number)maxSize : (Number)it.length;
            return StringsKt.decodeToString((byte[])it, (int)0, (int)((Number)endIndex).intValue(), (boolean)false);
        }
        return null;
    }

    public EmbraceNetworkCaptureService(@NotNull MetadataService metadataService2, @NotNull SessionIdTracker sessionIdTracker2, @NotNull PreferencesService preferencesService2, @NotNull Function0<? extends NetworkCaptureDataSource> networkCaptureDataSource2, @NotNull ConfigService configService2, @NotNull EmbraceSerializer serializer, @NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)metadataService2, (String)"metadataService");
        Intrinsics.checkNotNullParameter((Object)sessionIdTracker2, (String)"sessionIdTracker");
        Intrinsics.checkNotNullParameter((Object)preferencesService2, (String)"preferencesService");
        Intrinsics.checkNotNullParameter(networkCaptureDataSource2, (String)"networkCaptureDataSource");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.metadataService = metadataService2;
        this.sessionIdTracker = sessionIdTracker2;
        this.preferencesService = preferencesService2;
        this.networkCaptureDataSource = networkCaptureDataSource2;
        this.configService = configService2;
        this.serializer = serializer;
        this.logger = logger2;
        this.networkCaptureEncryptionManager = LazyKt.lazy((Function0)((Function0)new Function0<NetworkCaptureEncryptionManager>(this){
            final /* synthetic */ EmbraceNetworkCaptureService this$0;

            @NotNull
            public final NetworkCaptureEncryptionManager invoke() {
                return new NetworkCaptureEncryptionManager(EmbraceNetworkCaptureService.access$getLogger$p(this.this$0));
            }
            {
                this.this$0 = embraceNetworkCaptureService;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ EmbLogger access$getLogger$p(EmbraceNetworkCaptureService $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/network/logging/EmbraceNetworkCaptureService$Companion;", "", "()V", "NETWORK_ERROR_CODE", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

