/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.logging;

import io.embrace.android.embracesdk.arch.schema.EmbType;
import io.embrace.android.embracesdk.arch.schema.SchemaType;
import io.embrace.android.embracesdk.arch.schema.TelemetryType;
import io.embrace.android.embracesdk.internal.spans.SpanService;
import io.embrace.android.embracesdk.network.EmbraceNetworkRequest;
import io.embrace.android.embracesdk.network.logging.DomainCountLimiter;
import io.embrace.android.embracesdk.network.logging.NetworkCaptureService;
import io.embrace.android.embracesdk.network.logging.NetworkLoggingService;
import io.embrace.android.embracesdk.spans.ErrorCode;
import io.embrace.android.embracesdk.utils.NetworkUtils;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lio/embrace/android/embracesdk/network/logging/EmbraceNetworkLoggingService;", "Lio/embrace/android/embracesdk/network/logging/NetworkLoggingService;", "embraceDomainCountLimiter", "Lio/embrace/android/embracesdk/network/logging/DomainCountLimiter;", "networkCaptureService", "Lio/embrace/android/embracesdk/network/logging/NetworkCaptureService;", "spanService", "Lio/embrace/android/embracesdk/internal/spans/SpanService;", "(Lio/embrace/android/embracesdk/network/logging/DomainCountLimiter;Lio/embrace/android/embracesdk/network/logging/NetworkCaptureService;Lio/embrace/android/embracesdk/internal/spans/SpanService;)V", "logNetworkCaptureData", "", "networkRequest", "Lio/embrace/android/embracesdk/network/EmbraceNetworkRequest;", "logNetworkRequest", "recordNetworkRequest", "embrace-android-sdk_release"})
public final class EmbraceNetworkLoggingService
implements NetworkLoggingService {
    private final DomainCountLimiter embraceDomainCountLimiter;
    private final NetworkCaptureService networkCaptureService;
    private final SpanService spanService;

    @Override
    public void logNetworkRequest(@NotNull EmbraceNetworkRequest networkRequest) {
        Intrinsics.checkNotNullParameter((Object)networkRequest, (String)"networkRequest");
        this.logNetworkCaptureData(networkRequest);
        this.recordNetworkRequest(networkRequest);
    }

    private final void logNetworkCaptureData(EmbraceNetworkRequest networkRequest) {
        if (networkRequest.getNetworkCaptureData() != null) {
            String string2 = networkRequest.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"networkRequest.url");
            String string3 = networkRequest.getHttpMethod();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"networkRequest.httpMethod");
            Integer n = networkRequest.getResponseCode();
            if (n == null) {
                n = -1;
            }
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"networkRequest.responseCode ?: NETWORK_ERROR_CODE");
            int n2 = n;
            Long l = networkRequest.getStartTime();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"networkRequest.startTime");
            long l2 = l;
            Long l3 = networkRequest.getEndTime();
            Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"networkRequest.endTime");
            this.networkCaptureService.logNetworkCapturedData(string2, string3, n2, l2, l3, networkRequest.getNetworkCaptureData(), networkRequest.getErrorMessage());
        }
    }

    private final void recordNetworkRequest(EmbraceNetworkRequest networkRequest) {
        String string2 = networkRequest.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"networkRequest.url");
        String string3 = NetworkUtils.getDomain(NetworkUtils.stripUrl(string2));
        if (string3 == null) {
            return;
        }
        String domain = string3;
        if (this.embraceDomainCountLimiter.canLogNetworkRequest(domain)) {
            String string4 = networkRequest.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"networkRequest.url");
            String strippedUrl = NetworkUtils.stripUrl(string4);
            SchemaType.NetworkRequest networkRequestSchemaType = new SchemaType.NetworkRequest(networkRequest);
            Integer statusCode = networkRequest.getResponseCode();
            ErrorCode errorCode = statusCode == null || statusCode <= 0 || statusCode >= 400 ? ErrorCode.FAILURE : null;
            String string5 = networkRequest.getHttpMethod() + ' ' + NetworkUtils.getUrlPath(strippedUrl);
            Long l = networkRequest.getStartTime();
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"networkRequest.startTime");
            long l2 = l;
            Long l3 = networkRequest.getEndTime();
            Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"networkRequest.endTime");
            TelemetryType telemetryType = EmbType.Performance.Network.INSTANCE;
            List list = null;
            Map<String, String> map = networkRequestSchemaType.attributes();
            boolean bl = false;
            boolean bl2 = false;
            ErrorCode errorCode2 = errorCode;
            SpanService.DefaultImpls.recordCompletedSpan$default(this.spanService, string5, l2, l3, null, telemetryType, bl2, bl, map, list, errorCode2, 360, null);
        }
    }

    public EmbraceNetworkLoggingService(@NotNull DomainCountLimiter embraceDomainCountLimiter2, @NotNull NetworkCaptureService networkCaptureService2, @NotNull SpanService spanService2) {
        Intrinsics.checkNotNullParameter((Object)embraceDomainCountLimiter2, (String)"embraceDomainCountLimiter");
        Intrinsics.checkNotNullParameter((Object)networkCaptureService2, (String)"networkCaptureService");
        Intrinsics.checkNotNullParameter((Object)spanService2, (String)"spanService");
        this.embraceDomainCountLimiter = embraceDomainCountLimiter2;
        this.networkCaptureService = networkCaptureService2;
        this.spanService = spanService2;
    }
}

