/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.network.logging;

import android.util.Base64;
import androidx.annotation.NonNull;
import io.embrace.android.embracesdk.logging.EmbLogger;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jetbrains.annotations.Nullable;

class NetworkCaptureEncryptionManager {
    private static final String UTF_8 = "UTF-8";
    private final String transformation = "RSA/ECB/PKCS1Padding";
    private static final int mEncryptionBlockSize = 245;
    private static final int mDecryptionBlockSize = 256;
    @NonNull
    private final EmbLogger logger;

    NetworkCaptureEncryptionManager(@NonNull EmbLogger logger2) {
        this.logger = logger2;
    }

    @Nullable
    public String encrypt(@NonNull String data, @NonNull String keyText) {
        try {
            Key publicKey = this.getKeyFromText(keyText);
            if (publicKey != null) {
                return this.encrypt(data, publicKey);
            }
            this.logger.logError("wrong public key", null);
            return null;
        }
        catch (Exception e) {
            this.logger.logError("data cannot be encrypted", e);
            return null;
        }
    }

    @Nullable
    private String encrypt(@NonNull String data, @NonNull Key key) {
        String result = "";
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, key);
            byte[] plainData = data.getBytes(UTF_8);
            byte[] decodedData = this.decodeWithBuffer(cipher, plainData, 245);
            String encodedString = Base64.encodeToString((byte[])decodedData, (int)0);
            result = result + encodedString;
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            this.logger.logError("data cannot be encrypted", e);
        }
        return result;
    }

    @Nullable
    public String decrypt(@NonNull String data, @NonNull Key key) {
        String result = null;
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, key);
            byte[] encryptedData = Base64.decode((String)data, (int)0);
            byte[] decodedData = this.decodeWithBuffer(cipher, encryptedData, 256);
            result = new String(decodedData, UTF_8);
        }
        catch (IOException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            this.logger.logError("data cannot be encrypted", e);
        }
        return result;
    }

    private byte[] decodeWithBuffer(@NonNull Cipher cipher, @NonNull byte[] plainData, int bufferLength) throws IllegalBlockSizeException, BadPaddingException {
        byte[] scrambled;
        byte[] toReturn = new byte[]{};
        byte[] buffer = new byte[plainData.length > bufferLength ? bufferLength : plainData.length];
        for (int i = 0; i < plainData.length; ++i) {
            if (i > 0 && i % bufferLength == 0) {
                scrambled = cipher.doFinal(buffer);
                toReturn = this.append(toReturn, scrambled);
                int newLength = bufferLength;
                if (i + bufferLength > plainData.length) {
                    newLength = plainData.length - i;
                }
                buffer = new byte[newLength];
            }
            buffer[i % bufferLength] = plainData[i];
        }
        scrambled = cipher.doFinal(buffer);
        toReturn = this.append(toReturn, scrambled);
        return toReturn;
    }

    private byte[] append(byte[] prefix, byte[] suffix) {
        int i;
        byte[] toReturn = new byte[prefix.length + suffix.length];
        for (i = 0; i < prefix.length; ++i) {
            toReturn[i] = prefix[i];
        }
        for (i = 0; i < suffix.length; ++i) {
            toReturn[i + prefix.length] = suffix[i];
        }
        return toReturn;
    }

    private Key getKeyFromText(String keyText) {
        try {
            X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(Base64.decode((String)keyText, (int)0));
            return KeyFactory.getInstance("RSA").generatePublic(encodedKeySpec);
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return null;
    }
}

