/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.samples;

import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.logging.EmbLoggerImpl;
import io.embrace.android.embracesdk.samples.EmbraceCrashSamplesNdkDelegateImpl;
import io.embrace.android.embracesdk.samples.EmbraceSampleCodeException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\fJ\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\u0010\u001a\u00020\fJ\u0006\u0010\u0011\u001a\u00020\fJ\u0006\u0010\u0012\u001a\u00020\fJ\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0014\u001a\u00020\fJ\u0006\u0010\u0015\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/embrace/android/embracesdk/samples/EmbraceCrashSamples;", "", "()V", "LONG_ANR_LENGTH", "", "SHORT_ANR_4_SEC", "", "logger", "Lio/embrace/android/embracesdk/logging/EmbLoggerImpl;", "ndkCrashSamplesNdkDelegate", "Lio/embrace/android/embracesdk/samples/EmbraceCrashSamplesNdkDelegateImpl;", "blockMainThreadForShortInterval", "", "checkAnrDetectionEnabled", "checkNdkDetectionEnabled", "isSdkStarted", "throwJvmException", "triggerLongAnr", "triggerNdkSigAbort", "triggerNdkSigIllegalInstruction", "triggerNdkSigfpe", "triggerNdkSigsegv", "triggerNdkThrowCppException", "embrace-android-sdk_release"})
public final class EmbraceCrashSamples {
    private static final EmbLoggerImpl logger;
    private static final EmbraceCrashSamplesNdkDelegateImpl ndkCrashSamplesNdkDelegate;
    private static final int LONG_ANR_LENGTH = 30000;
    private static final long SHORT_ANR_4_SEC = 4000L;
    @NotNull
    public static final EmbraceCrashSamples INSTANCE;

    public final void isSdkStarted() {
        if (!Embrace.getInstance().isStarted()) {
            EmbraceSampleCodeException e = new EmbraceSampleCodeException("Embrace SDK not initialized. Please ensure you have included Embrace.getInstance().start(this) in Application#onCreate()\nand then trigger these crash samples via a button press once the app has loaded.");
            logger.logError("Embrace SDK is not initialized", e);
            throw (Throwable)e;
        }
    }

    public final void checkAnrDetectionEnabled() {
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        if (!embrace.getInternalInterface().isAnrCaptureEnabled()) {
            EmbraceSampleCodeException e = new EmbraceSampleCodeException("ANR capture disabled - you need to enable it to test Embrace's ANR functionality:\n - add [\"anr\":{\"pct_enabled\": 100 }] inside the configuration file to enable ANR detection");
            logger.logError("ANR detection disabled", e);
            throw (Throwable)e;
        }
    }

    public final void throwJvmException() {
        this.isSdkStarted();
        throw (Throwable)new EmbraceSampleCodeException("Custom JVM Exception");
    }

    public final void blockMainThreadForShortInterval() {
        this.isSdkStarted();
        this.checkAnrDetectionEnabled();
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException e) {
            logger.logError("Short ANR failed", e);
        }
    }

    public final void triggerLongAnr() {
        this.isSdkStarted();
        this.checkAnrDetectionEnabled();
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        Embrace embrace2 = embrace;
        long start2 = embrace2.getInternalInterface().getSdkCurrentTime();
        while (embrace2.getInternalInterface().getSdkCurrentTime() - start2 < (long)30000) {
        }
    }

    public final void checkNdkDetectionEnabled() {
        this.isSdkStarted();
        Embrace embrace = Embrace.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)embrace, (String)"Embrace.getInstance()");
        if (!embrace.getInternalInterface().isNdkEnabled()) {
            EmbraceSampleCodeException e = new EmbraceSampleCodeException("NDK crash capture is disabled - you need to enable it to test Embrace's NDK functionality - To enable it, add [\"ndk_enabled\": true] inside the configuration file");
            logger.logError("NDK detection disabled", e);
            throw (Throwable)e;
        }
    }

    public final void triggerNdkSigIllegalInstruction() {
        this.checkNdkDetectionEnabled();
        ndkCrashSamplesNdkDelegate.sigIllegalInstruction();
    }

    public final void triggerNdkThrowCppException() {
        this.checkNdkDetectionEnabled();
        ndkCrashSamplesNdkDelegate.throwException();
    }

    public final void triggerNdkSigAbort() {
        this.checkNdkDetectionEnabled();
        ndkCrashSamplesNdkDelegate.sigAbort();
    }

    public final void triggerNdkSigfpe() {
        this.checkNdkDetectionEnabled();
        ndkCrashSamplesNdkDelegate.sigfpe();
    }

    public final void triggerNdkSigsegv() {
        this.checkNdkDetectionEnabled();
        ndkCrashSamplesNdkDelegate.sigsegv();
    }

    private EmbraceCrashSamples() {
    }

    static {
        EmbraceCrashSamples embraceCrashSamples;
        INSTANCE = embraceCrashSamples = new EmbraceCrashSamples();
        logger = new EmbLoggerImpl();
        ndkCrashSamplesNdkDelegate = new EmbraceCrashSamplesNdkDelegateImpl();
    }
}

