/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.samples;

import android.os.Handler;
import android.os.Looper;
import io.embrace.android.embracesdk.Embrace;
import io.embrace.android.embracesdk.Severity;
import io.embrace.android.embracesdk.samples.AutomaticVerificationChecker;
import io.embrace.android.embracesdk.samples.ComparableVersion;
import io.embrace.android.embracesdk.samples.VerificationActions;
import io.embrace.android.embracesdk.samples.VerifyIntegrationException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0013\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\fH\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\b\u0010\u0017\u001a\u00020\u000bH\u0002J\u0006\u0010\u0018\u001a\u00020\u000bJ\b\u0010\u0019\u001a\u00020\u000bH\u0002J\b\u0010\u001a\u001a\u00020\u000bH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\fH\u0002J\u0006\u0010\u001e\u001a\u00020\u000bJ\b\u0010\u001f\u001a\u00020\u000bH\u0002J\b\u0010 \u001a\u00020\u000bH\u0002J\b\u0010!\u001a\u00020\u000bH\u0002J\u001e\u0010\"\u001a\u00020\u000b2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u001c\u001a\u00020\fH\u0002R&\u0010\u0007\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0004\u0012\u00020\f0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/embrace/android/embracesdk/samples/VerificationActions;", "", "embraceInstance", "Lio/embrace/android/embracesdk/Embrace;", "automaticVerificationChecker", "Lio/embrace/android/embracesdk/samples/AutomaticVerificationChecker;", "(Lio/embrace/android/embracesdk/Embrace;Lio/embrace/android/embracesdk/samples/AutomaticVerificationChecker;)V", "actionsToVerify", "", "Lkotlin/Pair;", "Lkotlin/Function0;", "", "", "currentStep", "", "handler", "Landroid/os/Handler;", "sampleProperties", "", "totalSteps", "checkEmbraceSDKVersion", "latestEmbraceVersion", "executeLogsActions", "executeMoment", "executeNetworkHttpGETRequest", "executeNetworkHttpPOSTRequest", "executeNetworkHttpWrongRequest", "logError", "message", "logInfo", "runActions", "setUserData", "throwAnException", "triggerAnr", "verifyAction", "action", "Companion", "embrace-android-sdk_release"})
public final class VerificationActions {
    private final Handler handler;
    private final List<Pair<Function0<Unit>, String>> actionsToVerify;
    private int currentStep;
    private final int totalSteps;
    private final Map<String, Object> sampleProperties;
    private final Embrace embraceInstance;
    private final AutomaticVerificationChecker automaticVerificationChecker;
    private static final long THROW_EXCEPTION_DELAY_MILLIS = 100L;
    private static final long ANR_DURATION_MILLIS = 2000L;
    private static final long MOMENT_DURATION_MILLIS = 3000L;
    private static final String networkingGetUrl = "https://dash-api.embrace.io/external/sdk/android/version";
    private static final String networkingPostUrl = "https://httpbin.org/post";
    private static final String networkingWrongUrl = "https://httpbin.org/deaasd/ASdasdkjl";
    private static final String networkingPostBody = "{\"key_one\":\"value_one\"}";
    private static final String embraceChangelogLink = "https://embrace.io/docs/android/changelog/";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void runActions() {
        this.logInfo("[EmbraceVerification] Starting Verification...");
        this.embraceInstance.addBreadcrumb("This is a breadcrumb");
        Iterable $this$forEach$iv = this.actionsToVerify;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            this.verifyAction((Function0<Unit>)((Function0)it.getFirst()), (String)it.getSecond());
        }
    }

    private final void verifyAction(Function0<Unit> action2, String message) {
        int n = this.currentStep;
        this.currentStep = n + 1;
        try {
            this.logInfo(" \u2713 Step " + this.currentStep + '/' + this.totalSteps + ": " + message);
            action2.invoke();
        }
        catch (Throwable e) {
            this.logError("[EmbraceVerification] -- " + message + " ERROR " + e.getLocalizedMessage());
            this.automaticVerificationChecker.addException(e);
        }
    }

    private final void setUserData() {
        String identifier = "1234567890";
        String username = "Mr. Automated User";
        String email = "automated@embrace.io";
        this.embraceInstance.setUserIdentifier(identifier);
        this.embraceInstance.setUsername(username);
        this.embraceInstance.setUserEmail(email);
        this.embraceInstance.setUserAsPayer();
        this.embraceInstance.addUserPersona("userPersona");
    }

    private final void executeLogsActions() {
        this.embraceInstance.logMessage("test info", Severity.INFO, this.sampleProperties);
        this.embraceInstance.logMessage("test warn", Severity.WARNING, this.sampleProperties);
        this.embraceInstance.logException(new Throwable("Sample throwable"), Severity.ERROR, this.sampleProperties, "test error");
    }

    private final void executeMoment() {
        String momentName = "Verify Integration Moment";
        String momentIdentifier = "Verify Integration identifier";
        this.embraceInstance.startMoment(momentName, momentIdentifier, this.sampleProperties);
        this.handler.postDelayed(new Runnable(this, momentName, momentIdentifier){
            final /* synthetic */ VerificationActions this$0;
            final /* synthetic */ String $momentName;
            final /* synthetic */ String $momentIdentifier;

            public final void run() {
                VerificationActions.access$getEmbraceInstance$p(this.this$0).endMoment(this.$momentName, this.$momentIdentifier);
            }
            {
                this.this$0 = verificationActions;
                this.$momentName = string2;
                this.$momentIdentifier = string3;
            }
        }, 3000L);
    }

    public final void executeNetworkHttpGETRequest() {
        URLConnection uRLConnection = new URL(networkingGetUrl).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        connection.setRequestProperty(this.embraceInstance.getTraceIdHeader(), "traceId : " + this.embraceInstance.getTraceIdHeader());
        InputStream inputStream = connection.getInputStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"connection.inputStream");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Closeable closeable = inputStream2;
        int n = 0;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        boolean bl = false;
        String data = TextStreamsKt.readText((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)));
        if (connection.getResponseCode() != 200) {
            throw (Throwable)new VerifyIntegrationException("RESPONSE CODE IS " + connection.getResponseCode());
        }
        String string2 = new JSONObject(data).getString("value");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JSONObject(data).getString(\"value\")");
        this.checkEmbraceSDKVersion(string2);
    }

    private final void checkEmbraceSDKVersion(String latestEmbraceVersion) {
        String currentVersion = "null";
        if (new ComparableVersion(currentVersion).compareTo(new ComparableVersion(latestEmbraceVersion)) < 0) {
            this.logInfo("[EmbraceVerification] Note that there is a newer version of Embrace available \ud83d\ude4c! " + "You can read the changelog for " + latestEmbraceVersion + " here: https://embrace.io/docs/android/changelog/");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void executeNetworkHttpPOSTRequest() {
        URLConnection uRLConnection = new URL(networkingPostUrl).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        connection.setDoOutput(true);
        Closeable closeable = new DataOutputStream(connection.getOutputStream());
        Throwable throwable = null;
        try {
            DataOutputStream it = (DataOutputStream)closeable;
            boolean bl = false;
            it.writeBytes(networkingPostBody);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        int result = connection.getResponseCode();
        if (result != 200) {
            throw (Throwable)new VerifyIntegrationException("RESPONSE CODE IS " + result);
        }
    }

    private final void executeNetworkHttpWrongRequest() {
        URLConnection uRLConnection = new URL(networkingWrongUrl).openConnection();
        if (uRLConnection == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
        }
        HttpURLConnection connection = (HttpURLConnection)uRLConnection;
        int result = connection.getResponseCode();
        if (result != 404) {
            throw (Throwable)new VerifyIntegrationException("RESPONSE CODE IS " + result);
        }
    }

    private final void triggerAnr() {
        this.handler.post((Runnable)triggerAnr.1.INSTANCE);
        this.logInfo("[EmbraceVerification] ANR Finished");
    }

    private final void throwAnException() {
        this.handler.postDelayed((Runnable)throwAnException.1.INSTANCE, 100L);
    }

    private final void logInfo(String message) {
        this.embraceInstance.getInternalInterface().logInfo("[EmbraceVerification] " + message, null);
    }

    private final void logError(String message) {
        this.embraceInstance.getInternalInterface().logError("[EmbraceVerification] " + message, null, null, false);
    }

    public VerificationActions(@NotNull Embrace embraceInstance, @NotNull AutomaticVerificationChecker automaticVerificationChecker) {
        Intrinsics.checkNotNullParameter((Object)embraceInstance, (String)"embraceInstance");
        Intrinsics.checkNotNullParameter((Object)automaticVerificationChecker, (String)"automaticVerificationChecker");
        this.embraceInstance = embraceInstance;
        this.automaticVerificationChecker = automaticVerificationChecker;
        this.handler = new Handler(Looper.getMainLooper());
        this.actionsToVerify = CollectionsKt.listOf((Object[])new Pair[]{new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$setUserData(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Set user data"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$executeLogsActions(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Log messages"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$executeMoment(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Trigger moment"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                this.this$0.executeNetworkHttpGETRequest();
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Executing network request: GET"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$executeNetworkHttpPOSTRequest(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Executing network request: POST"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$executeNetworkHttpWrongRequest(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Executing network request: testing a wrong url"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$triggerAnr(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Causing an ANR, the application will be tilt"), new Pair((Object)new Function0<Unit>(this){
            final /* synthetic */ VerificationActions this$0;

            public final void invoke() {
                VerificationActions.access$throwAnException(this.this$0);
            }
            {
                this.this$0 = verificationActions;
                super(0);
            }
        }, (Object)"Throwing an Exception! \ud83d\udca3")});
        this.totalSteps = this.actionsToVerify.size();
        this.sampleProperties = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"String", (Object)"Test String"), TuplesKt.to((Object)"LongString", (Object)"This value will be trimmed Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum. In culpa qui officia deserunt mollit anim id est laborum."), TuplesKt.to((Object)"Float", (Object)Float.valueOf(1.0f)), TuplesKt.to((Object)"Nested Properties", (Object)MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"a", (Object)"b"), TuplesKt.to((Object)"c", (Object)"d")}))});
    }

    public static final /* synthetic */ Embrace access$getEmbraceInstance$p(VerificationActions $this) {
        return $this.embraceInstance;
    }

    public static final /* synthetic */ void access$setUserData(VerificationActions $this) {
        $this.setUserData();
    }

    public static final /* synthetic */ void access$executeLogsActions(VerificationActions $this) {
        $this.executeLogsActions();
    }

    public static final /* synthetic */ void access$executeMoment(VerificationActions $this) {
        $this.executeMoment();
    }

    public static final /* synthetic */ void access$executeNetworkHttpPOSTRequest(VerificationActions $this) {
        $this.executeNetworkHttpPOSTRequest();
    }

    public static final /* synthetic */ void access$executeNetworkHttpWrongRequest(VerificationActions $this) {
        $this.executeNetworkHttpWrongRequest();
    }

    public static final /* synthetic */ void access$triggerAnr(VerificationActions $this) {
        $this.triggerAnr();
    }

    public static final /* synthetic */ void access$throwAnException(VerificationActions $this) {
        $this.throwAnException();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/embrace/android/embracesdk/samples/VerificationActions$Companion;", "", "()V", "ANR_DURATION_MILLIS", "", "MOMENT_DURATION_MILLIS", "THROW_EXCEPTION_DELAY_MILLIS", "embraceChangelogLink", "", "networkingGetUrl", "networkingPostBody", "networkingPostUrl", "networkingWrongUrl", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

