/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.session.lifecycle;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import io.embrace.android.embracesdk.annotation.StartupActivity;
import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorType;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.session.lifecycle.ActivityLifecycleListener;
import io.embrace.android.embracesdk.session.lifecycle.ActivityTracker;
import io.embrace.android.embracesdk.session.lifecycle.StartupListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\u001a\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010 \u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0018\u0010!\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010#\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\tH\u0016J\u0010\u0010$\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011\u00a8\u0006&"}, d2={"Lio/embrace/android/embracesdk/session/lifecycle/ActivityLifecycleTracker;", "Lio/embrace/android/embracesdk/session/lifecycle/ActivityTracker;", "application", "Landroid/app/Application;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "(Landroid/app/Application;Lio/embrace/android/embracesdk/logging/EmbLogger;)V", "currentActivity", "Ljava/lang/ref/WeakReference;", "Landroid/app/Activity;", "foregroundActivity", "getForegroundActivity", "()Landroid/app/Activity;", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lio/embrace/android/embracesdk/session/lifecycle/ActivityLifecycleListener;", "getListeners", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "startupListeners", "Lio/embrace/android/embracesdk/session/lifecycle/StartupListener;", "getStartupListeners", "addListener", "", "listener", "addStartupListener", "close", "onActivityCreated", "activity", "bundle", "Landroid/os/Bundle;", "onActivityDestroyed", "onActivityPaused", "onActivityResumed", "onActivitySaveInstanceState", "onActivityStarted", "onActivityStopped", "updateStateWithActivity", "Companion", "embrace-android-sdk_release"})
public final class ActivityLifecycleTracker
implements ActivityTracker {
    @NotNull
    private final CopyOnWriteArrayList<ActivityLifecycleListener> listeners;
    @NotNull
    private final CopyOnWriteArrayList<StartupListener> startupListeners;
    private volatile WeakReference<Activity> currentActivity;
    private final Application application;
    private final EmbLogger logger;
    private static final String ERROR_FAILED_TO_NOTIFY = "Failed to notify ActivityLifecycleTracker listener";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CopyOnWriteArrayList<ActivityLifecycleListener> getListeners() {
        return this.listeners;
    }

    @NotNull
    public final CopyOnWriteArrayList<StartupListener> getStartupListeners() {
        return this.startupListeners;
    }

    public final synchronized void updateStateWithActivity(@Nullable Activity activity) {
        this.currentActivity = new WeakReference<Activity>(activity);
    }

    @Override
    @Nullable
    public Activity getForegroundActivity() {
        Activity foregroundActivity = (Activity)this.currentActivity.get();
        if (foregroundActivity == null || foregroundActivity.isFinishing()) {
            return null;
        }
        return foregroundActivity;
    }

    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.updateStateWithActivity(activity);
        Collection collection$iv = this.listeners;
        boolean $i$f$stream = false;
        Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ActivityLifecycleListener listener = (ActivityLifecycleListener)element$iv$iv;
            boolean bl = false;
            try {
                listener.onActivityCreated(activity, bundle);
            }
            catch (Exception ex) {
                EmbLogger.DefaultImpls.logWarning$default(this.logger, ERROR_FAILED_TO_NOTIFY, null, 2, null);
                this.logger.trackInternalError(InternalErrorType.ACTIVITY_LISTENER_FAIL, ex);
            }
        }
    }

    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        this.updateStateWithActivity(activity);
        Collection collection$iv = this.listeners;
        boolean $i$f$stream = false;
        Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ActivityLifecycleListener listener = (ActivityLifecycleListener)element$iv$iv;
            boolean bl = false;
            try {
                listener.onView(activity);
            }
            catch (Exception ex) {
                EmbLogger.DefaultImpls.logWarning$default(this.logger, ERROR_FAILED_TO_NOTIFY, null, 2, null);
                this.logger.trackInternalError(InternalErrorType.ACTIVITY_LISTENER_FAIL, ex);
            }
        }
    }

    public void onActivityResumed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (!activity.getClass().isAnnotationPresent(StartupActivity.class)) {
            Collection collection$iv = this.startupListeners;
            boolean $i$f$stream = false;
            Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                StartupListener listener = (StartupListener)element$iv$iv;
                boolean bl = false;
                try {
                    listener.applicationStartupComplete();
                }
                catch (Exception ex) {
                    EmbLogger.DefaultImpls.logWarning$default(this.logger, ERROR_FAILED_TO_NOTIFY, null, 2, null);
                    this.logger.trackInternalError(InternalErrorType.ACTIVITY_LISTENER_FAIL, ex);
                }
            }
        }
    }

    public void onActivityPaused(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Collection collection$iv = this.listeners;
        boolean $i$f$stream = false;
        Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ActivityLifecycleListener listener = (ActivityLifecycleListener)element$iv$iv;
            boolean bl = false;
            try {
                listener.onViewClose(activity);
            }
            catch (Exception ex) {
                EmbLogger.DefaultImpls.logWarning$default(this.logger, ERROR_FAILED_TO_NOTIFY, null, 2, null);
                this.logger.trackInternalError(InternalErrorType.ACTIVITY_LISTENER_FAIL, ex);
            }
        }
    }

    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle bundle) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
    }

    public void onActivityDestroyed(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
    }

    @Override
    public void addListener(@NotNull ActivityLifecycleListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!this.listeners.contains(listener)) {
            this.listeners.addIfAbsent(listener);
        }
    }

    @Override
    public void addStartupListener(@NotNull StartupListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!this.startupListeners.contains(listener)) {
            this.startupListeners.addIfAbsent(listener);
        }
    }

    @Override
    public void close() {
        try {
            EmbLogger.DefaultImpls.logDebug$default(this.logger, "Shutting down ActivityLifecycleTracker", null, 2, null);
            this.application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.listeners.clear();
            this.startupListeners.clear();
        }
        catch (Exception ex) {
            this.logger.logWarning("Error when closing ActivityLifecycleTracker", ex);
        }
    }

    public ActivityLifecycleTracker(@NotNull Application application2, @NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)application2, (String)"application");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.application = application2;
        this.logger = logger2;
        this.application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        this.listeners = new CopyOnWriteArrayList();
        this.startupListeners = new CopyOnWriteArrayList();
        this.currentActivity = new WeakReference<Object>(null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/session/lifecycle/ActivityLifecycleTracker$Companion;", "", "()V", "ERROR_FAILED_TO_NOTIFY", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

