/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.session.lifecycle;

import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ProcessLifecycleOwner;
import io.embrace.android.embracesdk.capture.internal.errors.InternalErrorType;
import io.embrace.android.embracesdk.internal.clock.Clock;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.session.lifecycle.EmbraceProcessStateService$WhenMappings;
import io.embrace.android.embracesdk.session.lifecycle.ProcessStateListener;
import io.embrace.android.embracesdk.session.lifecycle.ProcessStateService;
import io.embrace.android.embracesdk.session.orchestrator.SessionOrchestrator;
import io.embrace.android.embracesdk.utils.ThreadUtils;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0001#B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\u0017\u0010\u001a\u001a\u00020\u00172\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00170\u001cH\u0082\bJ\b\u0010\u001d\u001a\u00020\u0017H\u0016J\b\u0010\u001e\u001a\u00020\u0017H\u0016J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/embrace/android/embracesdk/session/lifecycle/EmbraceProcessStateService;", "Lio/embrace/android/embracesdk/session/lifecycle/ProcessStateService;", "Landroidx/lifecycle/LifecycleEventObserver;", "clock", "Lio/embrace/android/embracesdk/internal/clock/Clock;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "(Lio/embrace/android/embracesdk/internal/clock/Clock;Lio/embrace/android/embracesdk/logging/EmbLogger;Landroidx/lifecycle/LifecycleOwner;)V", "coldStart", "", "<set-?>", "isInBackground", "()Z", "listeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lio/embrace/android/embracesdk/session/lifecycle/ProcessStateListener;", "getListeners", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "sessionOrchestrator", "Lio/embrace/android/embracesdk/session/orchestrator/SessionOrchestrator;", "addListener", "", "listener", "close", "invokeCallbackSafely", "action", "Lkotlin/Function0;", "onBackground", "onForeground", "onStateChanged", "source", "event", "Landroidx/lifecycle/Lifecycle$Event;", "Companion", "embrace-android-sdk_release"})
public final class EmbraceProcessStateService
implements ProcessStateService,
LifecycleEventObserver {
    @NotNull
    private final CopyOnWriteArrayList<ProcessStateListener> listeners;
    private SessionOrchestrator sessionOrchestrator;
    private volatile boolean coldStart;
    private volatile boolean isInBackground;
    private final Clock clock;
    private final EmbLogger logger;
    private final LifecycleOwner lifecycleOwner;
    private static final String ERROR_FAILED_TO_NOTIFY = "Failed to notify EmbraceProcessStateService listener";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CopyOnWriteArrayList<ProcessStateListener> getListeners() {
        return this.listeners;
    }

    @Override
    public boolean isInBackground() {
        return this.isInBackground;
    }

    public void onStateChanged(@NotNull LifecycleOwner source, @NotNull Lifecycle.Event event) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        switch (EmbraceProcessStateService$WhenMappings.$EnumSwitchMapping$0[event.ordinal()]) {
            case 1: {
                this.onForeground();
                break;
            }
            case 2: {
                this.onBackground();
                break;
            }
        }
    }

    @Override
    public void onForeground() {
        EmbLogger.DefaultImpls.logDebug$default(this.logger, "AppState: App entered foreground.", null, 2, null);
        this.isInBackground = false;
        long timestamp = this.clock.now();
        EmbraceProcessStateService this_$iv = this;
        boolean $i$f$invokeCallbackSafely = false;
        try {
            boolean bl = false;
            SessionOrchestrator sessionOrchestrator2 = this.sessionOrchestrator;
            if (sessionOrchestrator2 != null) {
                sessionOrchestrator2.onForeground(this.coldStart, timestamp);
            }
        }
        catch (Exception ex$iv) {
            EmbLogger.DefaultImpls.logWarning$default(this_$iv.logger, ERROR_FAILED_TO_NOTIFY, null, 2, null);
            this_$iv.logger.trackInternalError(InternalErrorType.PROCESS_STATE_CALLBACK_FAIL, ex$iv);
        }
        Collection collection$iv = this.listeners;
        boolean $i$f$stream = false;
        Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ProcessStateListener listener = (ProcessStateListener)element$iv$iv;
            boolean bl = false;
            EmbraceProcessStateService this_$iv2 = this;
            boolean $i$f$invokeCallbackSafely2 = false;
            try {
                boolean bl2 = false;
                listener.onForeground(this.coldStart, timestamp);
            }
            catch (Exception ex$iv) {
                EmbLogger.DefaultImpls.logWarning$default(this_$iv2.logger, ERROR_FAILED_TO_NOTIFY, null, 2, null);
                this_$iv2.logger.trackInternalError(InternalErrorType.PROCESS_STATE_CALLBACK_FAIL, ex$iv);
            }
        }
        this.coldStart = false;
    }

    @Override
    public void onBackground() {
        EmbLogger.DefaultImpls.logDebug$default(this.logger, "AppState: App entered background", null, 2, null);
        this.isInBackground = true;
        long timestamp = this.clock.now();
        EmbraceProcessStateService this_$iv = this;
        boolean $i$f$invokeCallbackSafely = false;
        try {
            boolean bl = false;
            SessionOrchestrator sessionOrchestrator2 = this.sessionOrchestrator;
            if (sessionOrchestrator2 != null) {
                sessionOrchestrator2.onBackground(timestamp);
            }
        }
        catch (Exception ex$iv) {
            EmbLogger.DefaultImpls.logWarning$default(this_$iv.logger, ERROR_FAILED_TO_NOTIFY, null, 2, null);
            this_$iv.logger.trackInternalError(InternalErrorType.PROCESS_STATE_CALLBACK_FAIL, ex$iv);
        }
        Collection collection$iv = this.listeners;
        boolean $i$f$stream = false;
        Iterable $this$forEach$iv$iv = CollectionsKt.toList((Iterable)collection$iv);
        boolean $i$f$forEach = false;
        for (Object element$iv$iv : $this$forEach$iv$iv) {
            ProcessStateListener listener = (ProcessStateListener)element$iv$iv;
            boolean bl = false;
            EmbraceProcessStateService this_$iv2 = this;
            boolean $i$f$invokeCallbackSafely2 = false;
            try {
                boolean bl2 = false;
                listener.onBackground(timestamp);
            }
            catch (Exception ex$iv) {
                EmbLogger.DefaultImpls.logWarning$default(this_$iv2.logger, ERROR_FAILED_TO_NOTIFY, null, 2, null);
                this_$iv2.logger.trackInternalError(InternalErrorType.PROCESS_STATE_CALLBACK_FAIL, ex$iv);
            }
        }
    }

    private final void invokeCallbackSafely(Function0<Unit> action2) {
        int $i$f$invokeCallbackSafely = 0;
        try {
            action2.invoke();
        }
        catch (Exception ex) {
            EmbLogger.DefaultImpls.logWarning$default(this.logger, ERROR_FAILED_TO_NOTIFY, null, 2, null);
            this.logger.trackInternalError(InternalErrorType.PROCESS_STATE_CALLBACK_FAIL, ex);
        }
    }

    @Override
    public void addListener(@NotNull ProcessStateListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        ProcessStateListener processStateListener = listener;
        if (processStateListener instanceof SessionOrchestrator) {
            this.sessionOrchestrator = (SessionOrchestrator)listener;
        } else {
            this.listeners.addIfAbsent(listener);
        }
    }

    @Override
    public void close() {
        try {
            EmbLogger.DefaultImpls.logDebug$default(this.logger, "Shutting down EmbraceProcessStateService", null, 2, null);
            this.listeners.clear();
            this.sessionOrchestrator = null;
        }
        catch (Exception ex) {
            this.logger.logWarning("Error when closing EmbraceProcessStateService", ex);
        }
    }

    public EmbraceProcessStateService(@NotNull Clock clock, @NotNull EmbLogger logger2, @NotNull LifecycleOwner lifecycleOwner) {
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        this.clock = clock;
        this.logger = logger2;
        this.lifecycleOwner = lifecycleOwner;
        this.listeners = new CopyOnWriteArrayList();
        this.coldStart = true;
        Lifecycle lifecycle = this.lifecycleOwner.getLifecycle();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"lifecycleOwner.lifecycle");
        this.isInBackground = !lifecycle.getCurrentState().isAtLeast(Lifecycle.State.STARTED);
        ThreadUtils.INSTANCE.runOnMainThread(this.logger, new Runnable(){

            @Override
            public final void run() {
                lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)this);
            }
        });
    }

    public /* synthetic */ EmbraceProcessStateService(Clock clock, EmbLogger embLogger, LifecycleOwner lifecycleOwner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            LifecycleOwner lifecycleOwner2 = ProcessLifecycleOwner.get();
            Intrinsics.checkNotNullExpressionValue((Object)lifecycleOwner2, (String)"ProcessLifecycleOwner.get()");
            lifecycleOwner = lifecycleOwner2;
        }
        this(clock, embLogger, lifecycleOwner);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/embrace/android/embracesdk/session/lifecycle/EmbraceProcessStateService$Companion;", "", "()V", "ERROR_FAILED_TO_NOTIFY", "", "embrace-android-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

