/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.session.message;

import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.payload.Envelope;
import io.embrace.android.embracesdk.internal.payload.SessionPayload;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.payload.ApplicationState;
import io.embrace.android.embracesdk.payload.LifeEventType;
import io.embrace.android.embracesdk.payload.SessionZygote;
import io.embrace.android.embracesdk.session.lifecycle.ProcessState;
import io.embrace.android.embracesdk.session.message.FinalEnvelopeParams;
import io.embrace.android.embracesdk.session.message.InitialEnvelopeParams;
import io.embrace.android.embracesdk.session.message.PayloadFactory;
import io.embrace.android.embracesdk.session.message.PayloadFactoryImpl$WhenMappings;
import io.embrace.android.embracesdk.session.message.PayloadMessageCollator;
import io.embrace.android.embracesdk.session.orchestrator.SessionSnapshotType;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u001bH\u0002J\"\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u001bH\u0016J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u001bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/embrace/android/embracesdk/session/message/PayloadFactoryImpl;", "Lio/embrace/android/embracesdk/session/message/PayloadFactory;", "payloadMessageCollator", "Lio/embrace/android/embracesdk/session/message/PayloadMessageCollator;", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "(Lio/embrace/android/embracesdk/session/message/PayloadMessageCollator;Lio/embrace/android/embracesdk/config/ConfigService;Lio/embrace/android/embracesdk/logging/EmbLogger;)V", "endBackgroundActivityWithCrash", "Lio/embrace/android/embracesdk/internal/payload/Envelope;", "Lio/embrace/android/embracesdk/internal/payload/SessionPayload;", "initial", "Lio/embrace/android/embracesdk/payload/SessionZygote;", "crashId", "", "endBackgroundActivityWithState", "endPayloadWithCrash", "state", "Lio/embrace/android/embracesdk/session/lifecycle/ProcessState;", "timestamp", "", "endPayloadWithState", "endSessionWithCrash", "endSessionWithManual", "endSessionWithState", "isBackgroundActivityEnabled", "", "snapshotBackgroundActivity", "snapshotPayload", "snapshotSession", "startBackgroundActivityWithState", "coldStart", "startPayloadWithState", "startSessionWithManual", "startSessionWithState", "embrace-android-sdk_release"})
public final class PayloadFactoryImpl
implements PayloadFactory {
    private final PayloadMessageCollator payloadMessageCollator;
    private final ConfigService configService;
    private final EmbLogger logger;

    @Override
    @Nullable
    public SessionZygote startPayloadWithState(@NotNull ProcessState state2, long timestamp, boolean coldStart) {
        SessionZygote sessionZygote;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        switch (PayloadFactoryImpl$WhenMappings.$EnumSwitchMapping$0[state2.ordinal()]) {
            case 1: {
                sessionZygote = this.startSessionWithState(timestamp, coldStart);
                break;
            }
            case 2: {
                sessionZygote = this.startBackgroundActivityWithState(timestamp, coldStart);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return sessionZygote;
    }

    @Override
    @Nullable
    public Envelope<SessionPayload> endPayloadWithState(@NotNull ProcessState state2, long timestamp, @NotNull SessionZygote initial) {
        Envelope<SessionPayload> envelope;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        switch (PayloadFactoryImpl$WhenMappings.$EnumSwitchMapping$1[state2.ordinal()]) {
            case 1: {
                envelope = this.endSessionWithState(initial);
                break;
            }
            case 2: {
                envelope = this.endBackgroundActivityWithState(initial);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return envelope;
    }

    @Override
    @Nullable
    public Envelope<SessionPayload> endPayloadWithCrash(@NotNull ProcessState state2, long timestamp, @NotNull SessionZygote initial, @NotNull String crashId) {
        Envelope<SessionPayload> envelope;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        Intrinsics.checkNotNullParameter((Object)crashId, (String)"crashId");
        switch (PayloadFactoryImpl$WhenMappings.$EnumSwitchMapping$2[state2.ordinal()]) {
            case 1: {
                envelope = this.endSessionWithCrash(initial, crashId);
                break;
            }
            case 2: {
                envelope = this.endBackgroundActivityWithCrash(initial, crashId);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return envelope;
    }

    @Override
    @Nullable
    public Envelope<SessionPayload> snapshotPayload(@NotNull ProcessState state2, long timestamp, @NotNull SessionZygote initial) {
        Envelope<SessionPayload> envelope;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        switch (PayloadFactoryImpl$WhenMappings.$EnumSwitchMapping$3[state2.ordinal()]) {
            case 1: {
                envelope = this.snapshotSession(initial);
                break;
            }
            case 2: {
                envelope = this.snapshotBackgroundActivity(initial);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return envelope;
    }

    @Override
    @NotNull
    public SessionZygote startSessionWithManual(long timestamp) {
        return this.payloadMessageCollator.buildInitialSession(new InitialEnvelopeParams(false, LifeEventType.MANUAL, timestamp, ApplicationState.FOREGROUND));
    }

    @Override
    @NotNull
    public Envelope<SessionPayload> endSessionWithManual(long timestamp, @NotNull SessionZygote initial) {
        Intrinsics.checkNotNullParameter((Object)initial, (String)"initial");
        return this.payloadMessageCollator.buildFinalEnvelope(new FinalEnvelopeParams(initial, SessionSnapshotType.NORMAL_END, this.logger, this.isBackgroundActivityEnabled(), null, 16, null));
    }

    private final SessionZygote startSessionWithState(long timestamp, boolean coldStart) {
        return this.payloadMessageCollator.buildInitialSession(new InitialEnvelopeParams(coldStart, LifeEventType.STATE, timestamp, ApplicationState.FOREGROUND));
    }

    private final SessionZygote startBackgroundActivityWithState(long timestamp, boolean coldStart) {
        if (!this.isBackgroundActivityEnabled()) {
            return null;
        }
        long time = coldStart ? timestamp : timestamp + 1L;
        return this.payloadMessageCollator.buildInitialSession(new InitialEnvelopeParams(coldStart, LifeEventType.BKGND_STATE, time, ApplicationState.BACKGROUND));
    }

    private final Envelope<SessionPayload> endSessionWithState(SessionZygote initial) {
        return this.payloadMessageCollator.buildFinalEnvelope(new FinalEnvelopeParams(initial, SessionSnapshotType.NORMAL_END, this.logger, this.isBackgroundActivityEnabled(), null, 16, null));
    }

    private final Envelope<SessionPayload> endBackgroundActivityWithState(SessionZygote initial) {
        if (!this.isBackgroundActivityEnabled()) {
            return null;
        }
        return this.payloadMessageCollator.buildFinalEnvelope(new FinalEnvelopeParams(initial, SessionSnapshotType.NORMAL_END, this.logger, true, null, 16, null));
    }

    private final Envelope<SessionPayload> endSessionWithCrash(SessionZygote initial, String crashId) {
        return this.payloadMessageCollator.buildFinalEnvelope(new FinalEnvelopeParams(initial, SessionSnapshotType.JVM_CRASH, this.logger, this.isBackgroundActivityEnabled(), crashId));
    }

    private final Envelope<SessionPayload> endBackgroundActivityWithCrash(SessionZygote initial, String crashId) {
        if (!this.isBackgroundActivityEnabled()) {
            return null;
        }
        return this.payloadMessageCollator.buildFinalEnvelope(new FinalEnvelopeParams(initial, SessionSnapshotType.JVM_CRASH, this.logger, true, crashId));
    }

    private final Envelope<SessionPayload> snapshotSession(SessionZygote initial) {
        return this.payloadMessageCollator.buildFinalEnvelope(new FinalEnvelopeParams(initial, SessionSnapshotType.PERIODIC_CACHE, this.logger, this.isBackgroundActivityEnabled(), null, 16, null));
    }

    private final Envelope<SessionPayload> snapshotBackgroundActivity(SessionZygote initial) {
        if (!this.isBackgroundActivityEnabled()) {
            return null;
        }
        return this.payloadMessageCollator.buildFinalEnvelope(new FinalEnvelopeParams(initial, SessionSnapshotType.PERIODIC_CACHE, this.logger, true, null, 16, null));
    }

    private final boolean isBackgroundActivityEnabled() {
        return this.configService.isBackgroundActivityCaptureEnabled();
    }

    public PayloadFactoryImpl(@NotNull PayloadMessageCollator payloadMessageCollator, @NotNull ConfigService configService2, @NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)payloadMessageCollator, (String)"payloadMessageCollator");
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        this.payloadMessageCollator = payloadMessageCollator;
        this.configService = configService2;
        this.logger = logger2;
    }
}

