/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.session.orchestrator;

import io.embrace.android.embracesdk.config.ConfigService;
import io.embrace.android.embracesdk.internal.clock.Clock;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.payload.SessionZygote;
import io.embrace.android.embracesdk.session.lifecycle.ProcessState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a2\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0018\u0010\u000e\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\u0018\u0010\u000f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"MIN_SESSION_MS", "", "shouldEndManualSession", "", "configService", "Lio/embrace/android/embracesdk/config/ConfigService;", "clock", "Lio/embrace/android/embracesdk/internal/clock/Clock;", "activeSession", "Lio/embrace/android/embracesdk/payload/SessionZygote;", "state", "Lio/embrace/android/embracesdk/session/lifecycle/ProcessState;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "shouldRunOnBackground", "shouldRunOnForeground", "embrace-android-sdk_release"})
public final class OrchestratorTerminationConditionsKt {
    private static final long MIN_SESSION_MS = 5000L;

    public static final boolean shouldEndManualSession(@NotNull ConfigService configService2, @NotNull Clock clock, @Nullable SessionZygote activeSession, @NotNull ProcessState state2, @NotNull EmbLogger logger2) {
        Intrinsics.checkNotNullParameter((Object)configService2, (String)"configService");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        if (state2 == ProcessState.BACKGROUND) {
            EmbLogger.DefaultImpls.logWarning$default(logger2, "Cannot manually end session while in background.", null, 2, null);
            return true;
        }
        if (configService2.getSessionBehavior().isSessionControlEnabled()) {
            EmbLogger.DefaultImpls.logWarning$default(logger2, "Cannot manually end session while session control is enabled.", null, 2, null);
            return true;
        }
        SessionZygote sessionZygote = activeSession;
        if (sessionZygote == null) {
            return true;
        }
        SessionZygote initial = sessionZygote;
        long startTime = initial.getStartTime();
        long delta = clock.now() - startTime;
        if (delta < 5000L) {
            EmbLogger.DefaultImpls.logWarning$default(logger2, "Cannot manually end session while session is <5s long.This protects against instrumentation unintentionally creating toomany sessions", null, 2, null);
            return true;
        }
        return false;
    }

    public static final boolean shouldRunOnBackground(@NotNull ProcessState state2, @NotNull EmbLogger logger2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        if (state2 == ProcessState.BACKGROUND) {
            EmbLogger.DefaultImpls.logWarning$default(logger2, "Detected unbalanced call to onBackground. Ignoring..", null, 2, null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean shouldRunOnForeground(@NotNull ProcessState state2, @NotNull EmbLogger logger2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)((Object)state2), (String)"state");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        if (state2 == ProcessState.FOREGROUND) {
            EmbLogger.DefaultImpls.logWarning$default(logger2, "Detected unbalanced call to onForeground. Ignoring..", null, 2, null);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }
}

