/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.storage;

import android.content.Context;
import io.embrace.android.embracesdk.storage.EmbraceStorageService;
import io.embrace.android.embracesdk.storage.StorageAvailabilityChecker;
import io.embrace.android.embracesdk.storage.StorageService;
import io.embrace.android.embracesdk.telemetry.TelemetryService;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\nH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0017\u001a\u00020\nH\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\nH\u0002J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000e\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lio/embrace/android/embracesdk/storage/EmbraceStorageService;", "Lio/embrace/android/embracesdk/storage/StorageService;", "context", "Landroid/content/Context;", "telemetryService", "Lio/embrace/android/embracesdk/telemetry/TelemetryService;", "storageAvailabilityChecker", "Lio/embrace/android/embracesdk/storage/StorageAvailabilityChecker;", "(Landroid/content/Context;Lio/embrace/android/embracesdk/telemetry/TelemetryService;Lio/embrace/android/embracesdk/storage/StorageAvailabilityChecker;)V", "cacheDirectory", "Ljava/io/File;", "getCacheDirectory", "()Ljava/io/File;", "cacheDirectory$delegate", "Lkotlin/Lazy;", "filesDirectory", "getFilesDirectory", "filesDirectory$delegate", "getConfigCacheDir", "getFileForRead", "name", "", "getFileForWrite", "getNativeCrashDir", "getOrCreateEmbraceFilesDir", "listFiles", "", "filter", "Ljava/io/FilenameFilter;", "logStorageTelemetry", "", "embrace-android-sdk_release"})
public final class EmbraceStorageService
implements StorageService {
    private final Lazy cacheDirectory$delegate;
    private final Lazy filesDirectory$delegate;
    private final Context context;
    private final TelemetryService telemetryService;
    private final StorageAvailabilityChecker storageAvailabilityChecker;

    private final File getCacheDirectory() {
        Lazy lazy = this.cacheDirectory$delegate;
        EmbraceStorageService embraceStorageService = this;
        Object var3_3 = null;
        return (File)lazy.getValue();
    }

    private final File getFilesDirectory() {
        Lazy lazy = this.filesDirectory$delegate;
        EmbraceStorageService embraceStorageService = this;
        Object var3_3 = null;
        return (File)lazy.getValue();
    }

    @Override
    @NotNull
    public File getFileForRead(@NotNull String name) {
        File fileInCacheDir;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        File fileInFilesDir = new File(this.getFilesDirectory(), name);
        if (!fileInFilesDir.exists() && (fileInCacheDir = new File(this.getCacheDirectory(), name)).exists()) {
            return fileInCacheDir;
        }
        return fileInFilesDir;
    }

    @Override
    @NotNull
    public File getFileForWrite(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return new File(this.getFilesDirectory(), name);
    }

    @Override
    @NotNull
    public File getConfigCacheDir() {
        return new File(this.getCacheDirectory(), "emb_config_cache");
    }

    @Override
    @NotNull
    public File getNativeCrashDir() {
        return new File(this.getFilesDirectory(), "ndk");
    }

    @Override
    @NotNull
    public List<File> listFiles(@NotNull FilenameFilter filter) {
        Object[] objectArray;
        Object[] filesDir;
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Object[] objectArray2 = this.getFilesDirectory().listFiles(filter);
        if (objectArray2 == null) {
            objectArray2 = filesDir = new File[]{};
        }
        if ((objectArray = this.getCacheDirectory().listFiles(filter)) == null) {
            objectArray = new File[]{};
        }
        Object[] cacheDir = objectArray;
        return CollectionsKt.plus((Collection)ArraysKt.toList((Object[])filesDir), (Iterable)ArraysKt.toList((Object[])cacheDir));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void logStorageTelemetry() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        long availableStorage = this.storageAvailabilityChecker.getAvailableBytes();
        Iterable iterable = this.listFiles(logStorageTelemetry.storageUsed.1.INSTANCE);
        boolean $i$f$filter = false;
        void var7_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            if (!it.isFile()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        long l = 0L;
        for (Object t : $this$filter$iv) {
            void it;
            File file = (File)t;
            long l2 = l;
            boolean bl = false;
            long l3 = it.length();
            l = l2 + l3;
        }
        long storageUsed2 = l;
        Map storageTelemetryMap = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"emb.storage.used", (Object)String.valueOf(storageUsed2)), TuplesKt.to((Object)"emb.storage.available", (Object)String.valueOf(availableStorage))});
        this.telemetryService.logStorageTelemetry(storageTelemetryMap);
    }

    private final File getOrCreateEmbraceFilesDir() {
        File file;
        File filesDir = new File(this.context.getFilesDir(), "embrace");
        try {
            filesDir.mkdirs();
            File it = file = filesDir;
            boolean bl = false;
            file = it.exists() ? file : null;
        }
        catch (SecurityException e) {
            file = null;
        }
        return file;
    }

    public EmbraceStorageService(@NotNull Context context2, @NotNull TelemetryService telemetryService2, @NotNull StorageAvailabilityChecker storageAvailabilityChecker) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)telemetryService2, (String)"telemetryService");
        Intrinsics.checkNotNullParameter((Object)storageAvailabilityChecker, (String)"storageAvailabilityChecker");
        this.context = context2;
        this.telemetryService = telemetryService2;
        this.storageAvailabilityChecker = storageAvailabilityChecker;
        this.cacheDirectory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ EmbraceStorageService this$0;

            public final File invoke() {
                return EmbraceStorageService.access$getContext$p(this.this$0).getCacheDir();
            }
            {
                this.this$0 = embraceStorageService;
                super(0);
            }
        }));
        this.filesDirectory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ EmbraceStorageService this$0;

            @NotNull
            public final File invoke() {
                File file = EmbraceStorageService.access$getOrCreateEmbraceFilesDir(this.this$0);
                if (file == null) {
                    file = EmbraceStorageService.access$getCacheDirectory$p(this.this$0);
                }
                return file;
            }
            {
                this.this$0 = embraceStorageService;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Context access$getContext$p(EmbraceStorageService $this) {
        return $this.context;
    }

    public static final /* synthetic */ File access$getOrCreateEmbraceFilesDir(EmbraceStorageService $this) {
        return $this.getOrCreateEmbraceFilesDir();
    }

    public static final /* synthetic */ File access$getCacheDirectory$p(EmbraceStorageService $this) {
        return $this.getCacheDirectory();
    }
}

