/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.utils;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0007J\u0014\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0007J\u0014\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/embrace/android/embracesdk/utils/NetworkUtils;", "", "()V", "DNS_PATTERN", "", "DomainPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "IPV4_PATTERN", "IPV6_PATTERN", "IpAddrPattern", "TRACE_ID_MAXIMUM_ALLOWED_LENGTH", "", "getDomain", "originalUrl", "getUrlPath", "url", "getValidTraceId", "traceId", "isIpAddress", "", "domain", "stripUrl", "embrace-android-sdk_release"})
public final class NetworkUtils {
    private static final int TRACE_ID_MAXIMUM_ALLOWED_LENGTH = 64;
    private static final String DNS_PATTERN = "([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,63}[a-zA-Z0-9])?)(\\.[a-zA-Z]{1,63})(\\.[a-zA-Z]{1,2})?$";
    private static final String IPV4_PATTERN = "^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$";
    private static final String IPV6_PATTERN = "(([a-fA-F0-9]{1,4}|):){1,7}([a-fA-F0-9]{1,4}|:)";
    private static final Pattern IpAddrPattern;
    private static final Pattern DomainPattern;
    @NotNull
    public static final NetworkUtils INSTANCE;

    @JvmStatic
    @Nullable
    public static final String getValidTraceId(@Nullable String traceId) {
        String string2;
        if (traceId == null) {
            return null;
        }
        if (!Charset.forName("US-ASCII").newEncoder().canEncode(traceId)) {
            return null;
        }
        if (traceId.length() > 64) {
            String string3 = traceId;
            int n = 0;
            int n2 = 64;
            String string4 = string3.substring(n, n2);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string2 = traceId;
        }
        return string2;
    }

    @JvmStatic
    @Nullable
    public static final String getDomain(@NotNull String originalUrl) {
        Matcher matcher;
        Intrinsics.checkNotNullParameter((Object)originalUrl, (String)"originalUrl");
        String url = !StringsKt.startsWith$default((String)originalUrl, (String)"http", (boolean)false, (int)2, null) ? "http://" + originalUrl : originalUrl;
        try {
            matcher = DomainPattern.matcher(new URL(url).getHost());
        }
        catch (MalformedURLException ignored) {
            matcher = DomainPattern.matcher(url);
        }
        Matcher matcher2 = matcher;
        return matcher2.find() ? matcher2.group(0) : null;
    }

    @JvmStatic
    public static final boolean isIpAddress(@Nullable String domain) {
        return domain == null ? false : IpAddrPattern.matcher(domain).find();
    }

    @JvmStatic
    @NotNull
    public static final String stripUrl(@NotNull String url) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int pathPos = StringsKt.lastIndexOf$default((CharSequence)url, (char)'/', (int)0, (boolean)false, (int)6, null);
        if (pathPos < 0) {
            string2 = url;
        } else {
            String string3 = url;
            String string4 = string3.substring(pathPos);
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        }
        String suffix = string2;
        int queryPos = StringsKt.indexOf$default((CharSequence)suffix, (char)'?', (int)0, (boolean)false, (int)6, null);
        int fragmentPos = StringsKt.indexOf$default((CharSequence)suffix, (char)'#', (int)0, (boolean)false, (int)6, null);
        int queryPosResult = queryPos < 0 ? Integer.MAX_VALUE : queryPos;
        int fragmentPosResult = fragmentPos < 0 ? Integer.MAX_VALUE : fragmentPos;
        int terminalPos = RangesKt.coerceAtMost((int)queryPosResult, (int)fragmentPosResult);
        String string5 = url;
        int n = 0;
        int n2 = (pathPos < 0 ? 0 : pathPos) + RangesKt.coerceAtMost((int)suffix.length(), (int)terminalPos);
        String string6 = string5.substring(n, n2);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string6;
    }

    @JvmStatic
    @Nullable
    public static final String getUrlPath(@Nullable String url) {
        String string2;
        try {
            string2 = new URL(url).getPath();
        }
        catch (Exception exception) {
            string2 = "";
        }
        return string2;
    }

    private NetworkUtils() {
    }

    static {
        NetworkUtils networkUtils;
        INSTANCE = networkUtils = new NetworkUtils();
        IpAddrPattern = Pattern.compile("^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$|(([a-fA-F0-9]{1,4}|):){1,7}([a-fA-F0-9]{1,4}|:)");
        DomainPattern = Pattern.compile("([a-zA-Z0-9]([a-zA-Z0-9\\-]{0,63}[a-zA-Z0-9])?)(\\.[a-zA-Z]{1,63})(\\.[a-zA-Z]{1,2})?$|^((25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$|(([a-fA-F0-9]{1,4}|):){1,7}([a-fA-F0-9]{1,4}|:)");
    }
}

