/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.embracesdk.worker;

import io.embrace.android.embracesdk.injection.InitModule;
import io.embrace.android.embracesdk.internal.clock.Clock;
import io.embrace.android.embracesdk.logging.EmbLogger;
import io.embrace.android.embracesdk.worker.BackgroundWorker;
import io.embrace.android.embracesdk.worker.PriorityThreadPoolExecutor;
import io.embrace.android.embracesdk.worker.ScheduledWorker;
import io.embrace.android.embracesdk.worker.WorkerName;
import io.embrace.android.embracesdk.worker.WorkerThreadModule;
import io.embrace.android.embracesdk.worker.WorkerThreadModuleImpl$WhenMappings;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\rH\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\rH\u0002J\u0018\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\rH\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00120\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00160\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/embrace/android/embracesdk/worker/WorkerThreadModuleImpl;", "Lio/embrace/android/embracesdk/worker/WorkerThreadModule;", "Ljava/util/concurrent/RejectedExecutionHandler;", "initModule", "Lio/embrace/android/embracesdk/injection/InitModule;", "(Lio/embrace/android/embracesdk/injection/InitModule;)V", "anrMonitorThread", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/lang/Thread;", "getAnrMonitorThread", "()Ljava/util/concurrent/atomic/AtomicReference;", "backgroundWorkers", "", "Lio/embrace/android/embracesdk/worker/WorkerName;", "Lio/embrace/android/embracesdk/worker/BackgroundWorker;", "clock", "Lio/embrace/android/embracesdk/internal/clock/Clock;", "executors", "Ljava/util/concurrent/ExecutorService;", "logger", "Lio/embrace/android/embracesdk/logging/EmbLogger;", "scheduledWorkers", "Lio/embrace/android/embracesdk/worker/ScheduledWorker;", "backgroundWorker", "workerName", "close", "", "createThreadFactory", "Ljava/util/concurrent/ThreadFactory;", "name", "fetchExecutor", "rejectedExecution", "runnable", "Ljava/lang/Runnable;", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "scheduledWorker", "embrace-android-sdk_release"})
public final class WorkerThreadModuleImpl
implements WorkerThreadModule,
RejectedExecutionHandler {
    private final Clock clock;
    private final EmbLogger logger;
    private final Map<WorkerName, ExecutorService> executors;
    private final Map<WorkerName, BackgroundWorker> backgroundWorkers;
    private final Map<WorkerName, ScheduledWorker> scheduledWorkers;
    @NotNull
    private final AtomicReference<Thread> anrMonitorThread;

    @Override
    @NotNull
    public AtomicReference<Thread> getAnrMonitorThread() {
        return this.anrMonitorThread;
    }

    @Override
    @NotNull
    public BackgroundWorker backgroundWorker(@NotNull WorkerName workerName) {
        BackgroundWorker backgroundWorker;
        Intrinsics.checkNotNullParameter((Object)((Object)workerName), (String)"workerName");
        Map<WorkerName, BackgroundWorker> $this$getOrPut$iv = this.backgroundWorkers;
        boolean $i$f$getOrPut = false;
        BackgroundWorker value$iv = $this$getOrPut$iv.get((Object)workerName);
        if (value$iv == null) {
            boolean bl = false;
            BackgroundWorker answer$iv = new BackgroundWorker(this.fetchExecutor(workerName));
            $this$getOrPut$iv.put(workerName, answer$iv);
            backgroundWorker = answer$iv;
        } else {
            backgroundWorker = value$iv;
        }
        return backgroundWorker;
    }

    @Override
    @NotNull
    public ScheduledWorker scheduledWorker(@NotNull WorkerName workerName) {
        ScheduledWorker scheduledWorker;
        Intrinsics.checkNotNullParameter((Object)((Object)workerName), (String)"workerName");
        if (workerName == WorkerName.NETWORK_REQUEST) {
            String string2 = "Network request executor is not a scheduled executor";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        Map<WorkerName, ScheduledWorker> $this$getOrPut$iv = this.scheduledWorkers;
        boolean $i$f$getOrPut = false;
        ScheduledWorker value$iv = $this$getOrPut$iv.get((Object)workerName);
        if (value$iv == null) {
            boolean bl = false;
            ExecutorService executorService = this.fetchExecutor(workerName);
            if (executorService == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.util.concurrent.ScheduledExecutorService");
            }
            ScheduledWorker answer$iv = new ScheduledWorker((ScheduledExecutorService)executorService);
            $this$getOrPut$iv.put(workerName, answer$iv);
            scheduledWorker = answer$iv;
        } else {
            scheduledWorker = value$iv;
        }
        return scheduledWorker;
    }

    @Override
    public void close() {
        Iterable $this$forEach$iv = this.executors.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutorService p1 = (ExecutorService)element$iv;
            boolean bl = false;
            p1.shutdown();
        }
    }

    private final ExecutorService fetchExecutor(WorkerName workerName) {
        ExecutorService executorService;
        Map<WorkerName, ExecutorService> $this$getOrPut$iv = this.executors;
        boolean $i$f$getOrPut = false;
        ExecutorService value$iv = $this$getOrPut$iv.get((Object)workerName);
        if (value$iv == null) {
            ThreadPoolExecutor threadPoolExecutor;
            boolean bl = false;
            ThreadFactory threadFactory = this.createThreadFactory(workerName);
            switch (WorkerThreadModuleImpl$WhenMappings.$EnumSwitchMapping$0[workerName.ordinal()]) {
                case 1: {
                    threadPoolExecutor = new PriorityThreadPoolExecutor(this.clock, threadFactory, this, 1, 1);
                    break;
                }
                default: {
                    threadPoolExecutor = new ScheduledThreadPoolExecutor(1, threadFactory, this);
                }
            }
            ExecutorService answer$iv = threadPoolExecutor;
            $this$getOrPut$iv.put(workerName, answer$iv);
            executorService = answer$iv;
        } else {
            executorService = value$iv;
        }
        return executorService;
    }

    @Override
    public void rejectedExecution(@NotNull Runnable runnable2, @NotNull ThreadPoolExecutor executor) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        EmbLogger.DefaultImpls.logWarning$default(this.logger, "Rejected execution of " + runnable2 + " on " + executor + ". Ignoring - the process is likely terminating.", null, 2, null);
    }

    private final ThreadFactory createThreadFactory(WorkerName name) {
        return new ThreadFactory(this, name){
            final /* synthetic */ WorkerThreadModuleImpl this$0;
            final /* synthetic */ WorkerName $name;

            public final Thread newThread(@NotNull Runnable runnable2) {
                Thread thread;
                Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
                Thread $this$apply = thread = Executors.defaultThreadFactory().newThread(runnable2);
                boolean bl = false;
                if (this.$name == WorkerName.ANR_MONITOR) {
                    this.this$0.getAnrMonitorThread().set($this$apply);
                }
                Thread thread2 = $this$apply;
                Intrinsics.checkNotNullExpressionValue((Object)thread2, (String)"this");
                thread2.setName("emb-" + this.$name.getThreadName$embrace_android_sdk_release());
                return thread;
            }
            {
                this.this$0 = workerThreadModuleImpl;
                this.$name = workerName;
            }
        };
    }

    public WorkerThreadModuleImpl(@NotNull InitModule initModule) {
        Intrinsics.checkNotNullParameter((Object)initModule, (String)"initModule");
        this.clock = initModule.getClock();
        this.logger = initModule.getLogger();
        this.executors = new ConcurrentHashMap();
        this.backgroundWorkers = new ConcurrentHashMap();
        this.scheduledWorkers = new ConcurrentHashMap();
        this.anrMonitorThread = new AtomicReference();
    }
}

