/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logging;
import org.jetbrains.annotations.Nullable;

public final class Logger<T> {
    final org.gradle.api.logging.Logger logger;
    final String logFormat;
    private static EmbraceLogLevel logLevel = EmbraceLogLevel.DEFAULT;

    public static void setEmbraceLogLevel(@Nullable String logLevel) {
        EmbraceLogLevel embraceLogLevel = EmbraceLogLevel.forName(logLevel);
        Logger<Logger> logger = Logger.newLogger(Logger.class);
        if (embraceLogLevel != null) {
            Logger.logLevel = embraceLogLevel;
            logger.info("Embrace LogLevel set to " + Logger.logLevel.name());
        } else if (logLevel != null) {
            logger.error(String.format("Unable to set Embrace Loglevel for value: \"%s\", using default instead", logLevel));
            logger.error(String.format("valid options: %s", EmbraceLogLevel.valuesString()));
            Logger.logLevel = EmbraceLogLevel.DEFAULT;
        } else {
            logger.info(String.format("To configure an elevated log level, use the \"-P%s\" option", "embrace.logLevel"));
        }
    }

    Logger(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class instance is null.");
        }
        this.logger = Logging.getLogger(clazz);
        this.logFormat = "[SwazzlerPlugin] [" + clazz.getSimpleName() + "] %s";
    }

    public void debug(String msg) {
        this.debug(msg, null);
    }

    public void debug(String msg, Throwable throwable) {
        if (logLevel.getLogLevel() <= EmbraceLogLevel.DEBUG.getLogLevel()) {
            this.error("debug: " + msg, throwable);
        } else {
            this.log(LogLevel.DEBUG, msg, throwable);
        }
    }

    public void info(String msg) {
        this.info(msg, null);
    }

    public void info(String msg, Throwable throwable) {
        if (logLevel.getLogLevel() <= EmbraceLogLevel.INFO.getLogLevel()) {
            this.error("info: " + msg, throwable);
        } else {
            this.log(LogLevel.INFO, msg, throwable);
        }
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(String msg, Throwable throwable) {
        if (logLevel.getLogLevel() <= EmbraceLogLevel.WARN.getLogLevel()) {
            this.error("warn: " + msg, throwable);
        } else {
            this.log(LogLevel.WARN, msg, throwable);
        }
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Throwable throwable) {
        this.log(LogLevel.ERROR, msg, throwable);
    }

    void log(LogLevel logLevel, String msg, Throwable throwable) {
        if (logLevel == null) {
            throw new IllegalArgumentException("Log level is null.");
        }
        this.logger.log(logLevel, String.format(this.logFormat, msg), throwable);
    }

    public static <T> Logger<T> newLogger(Class<T> clazz) {
        return new Logger<T>(clazz);
    }

    public static enum EmbraceLogLevel {
        DEBUG(0),
        INFO(1),
        WARN(2),
        ERROR(3),
        DEFAULT(4);

        private int logLevel;

        private EmbraceLogLevel(int logLevel) {
            this.logLevel = logLevel;
        }

        public static EmbraceLogLevel forName(String logLevelString) {
            Optional<EmbraceLogLevel> logLevel = Arrays.stream(EmbraceLogLevel.values()).filter(embraceLogLevel -> embraceLogLevel.name().equalsIgnoreCase(logLevelString)).findAny();
            if (logLevel.isPresent()) {
                return logLevel.get();
            }
            return null;
        }

        public static String valuesString() {
            ArrayList<String> logLevels = new ArrayList<String>();
            for (EmbraceLogLevel logLevel : EmbraceLogLevel.values()) {
                logLevels.add(logLevel.name().toLowerCase());
            }
            return String.join((CharSequence)", ", logLevels);
        }

        int getLogLevel() {
            return this.logLevel;
        }
    }
}

