/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.compile.manifest;

import io.embrace.android.gradle.swazzler.compile.manifest.ConstructorDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.FieldDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.InitDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.MethodDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.SwazzleManifest;
import io.embrace.android.gradle.swazzler.compile.manifest.SwazzleManifestException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

@Deprecated
public abstract class ObjectTypeDirective {
    public static final String KEY_CLASS_NAME = "class";
    public static final String KEY_INTERFACE_NAME = "interface";
    public static final String KEY_CONSTRUCTOR_LIST = "constructors";
    public static final String KEY_FIELD_LIST = "fields";
    public static final String KEY_INIT_MAP = "init";
    public static final String KEY_METHOD_LIST = "methods";
    private static final String FORMAT_TO_STRING = "{name=%s, fields=%s, constructors=%s, methods=%s}";
    protected final String name;
    protected final SwazzleManifest manifest;
    protected final Map<String, ConstructorDirective> constructors;
    protected final Map<String, FieldDirective> fields;
    protected final Map<String, MethodDirective> methods;
    protected final InitDirective init;

    ObjectTypeDirective(SwazzleManifest manifest, Map<String, Object> directive) throws SwazzleManifestException {
        if (manifest == null) {
            throw new IllegalArgumentException("Swazzle manifest is null.");
        }
        if (directive == null) {
            throw new IllegalArgumentException("Directive map is null.");
        }
        switch (this.getDirectiveType()) {
            case CLASS: {
                this.name = (String)directive.get(KEY_CLASS_NAME);
                break;
            }
            case INTERFACE: {
                this.name = (String)directive.get(KEY_INTERFACE_NAME);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown directive type: " + (Object)((Object)this.getDirectiveType()));
            }
        }
        if (StringUtils.isBlank((CharSequence)this.name)) {
            throw new IllegalArgumentException("Name is null or blank.");
        }
        this.manifest = manifest;
        this.constructors = this.parseConstructorsFromDirective((List)directive.get(KEY_CONSTRUCTOR_LIST));
        this.fields = this.parseFieldsFromDirective((List)directive.get(KEY_FIELD_LIST));
        this.methods = this.parseMethodsFromDirective((List)directive.get(KEY_METHOD_LIST));
        this.init = this.parseInitFromDirective((Map)directive.get(KEY_INIT_MAP));
    }

    public abstract DirectiveType getDirectiveType();

    public String getName() {
        return this.name;
    }

    public SwazzleManifest getManifest() {
        return this.manifest;
    }

    public Map<String, ConstructorDirective> getConstructors() {
        return this.constructors;
    }

    public Map<String, FieldDirective> getFields() {
        return this.fields;
    }

    public Map<String, MethodDirective> getMethods() {
        return this.methods;
    }

    public InitDirective getInit() {
        return this.init;
    }

    public String toString() {
        return String.format(FORMAT_TO_STRING, this.name, this.fields, this.constructors, this.methods);
    }

    Map<String, ConstructorDirective> parseConstructorsFromDirective(List<Map<String, Object>> directives) throws SwazzleManifestException {
        if (directives == null) {
            return Collections.emptyMap();
        }
        return directives.stream().map(directive -> new ConstructorDirective(this, (Map<String, Object>)directive)).collect(Collectors.toMap(constructor -> constructor.getSignature(), constructor -> constructor));
    }

    Map<String, FieldDirective> parseFieldsFromDirective(List<Map<String, Object>> directives) {
        if (directives == null) {
            return Collections.emptyMap();
        }
        return directives.stream().map(directive -> new FieldDirective(this, (Map<String, Object>)directive)).collect(Collectors.toMap(field -> field.getName(), field -> field));
    }

    Map<String, MethodDirective> parseMethodsFromDirective(List<Map<String, Object>> directives) throws SwazzleManifestException {
        if (directives == null) {
            return Collections.emptyMap();
        }
        return directives.stream().map(directive -> new MethodDirective(this, (Map<String, Object>)directive)).collect(Collectors.toMap(method -> method.getName() + method.getSignature(), method -> method));
    }

    InitDirective parseInitFromDirective(Map<String, Object> directive) throws SwazzleManifestException {
        return directive != null ? new InitDirective(this, directive) : null;
    }

    public static enum DirectiveType {
        CLASS,
        INTERFACE;

    }
}

