/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.compile.swazzler;

import io.embrace.android.gradle.swazzler.compile.manifest.ClassDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.InterfaceDirective;
import io.embrace.android.gradle.swazzler.compile.swazzler.Swazzler;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import io.embrace.android.gradle.swazzler.plugin.rules.SmartSwazzlingManager;
import io.embrace.android.gradle.swazzler.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;

@Deprecated
public class SwazzleExecutor {
    final ClassPool classPool;
    final Swazzler swazzler;
    final boolean encodeExtractedFileNames;
    final SmartSwazzlingManager smartSwazzlingManager;

    public SwazzleExecutor(ClassPool classPool, Swazzler swazzler, boolean encodeExtractedFileNames, SmartSwazzlingManager smartSwazzlingManager) {
        if (classPool == null) {
            throw new IllegalArgumentException("Class pool instance is null.");
        }
        if (swazzler == null) {
            throw new IllegalArgumentException("Swazzler instance is null.");
        }
        this.smartSwazzlingManager = smartSwazzlingManager;
        this.classPool = classPool;
        this.swazzler = swazzler;
        this.encodeExtractedFileNames = encodeExtractedFileNames;
    }

    public boolean swazzleFile(File file, File destDir) throws SwazzlerException {
        return this.swazzleFile(file, destDir, null);
    }

    public boolean swazzleFile(File file, File destDir, String artifact) throws SwazzlerException {
        boolean modifiedFile;
        block24: {
            if (destDir == null) {
                throw new IllegalArgumentException("Destination directory is null.");
            }
            if (file == null) {
                throw new IllegalArgumentException("Class file is null.");
            }
            if (!destDir.exists()) {
                throw new IllegalArgumentException("Destination directory does not exist: " + destDir.getPath());
            }
            if (!file.exists()) {
                throw new SwazzlerException("Input file does not exist: " + file);
            }
            if (!FileUtils.isClassFile(file.getName())) {
                throw new SwazzlerException("Input file is not a Java class file: " + file);
            }
            modifiedFile = false;
            try {
                CtClass clazz;
                try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));){
                    clazz = this.classPool.makeClass((InputStream)in);
                }
                if (clazz == null) {
                    throw new SwazzlerException("Class could not be loaded from file: " + file.getPath());
                }
                List<ClassDirective> classDirectives = this.swazzler.getClassDirectives(clazz);
                List<InterfaceDirective> interfaceDirectives = this.swazzler.getInterfaceDirectives(clazz);
                if (!classDirectives.isEmpty() || !interfaceDirectives.isEmpty()) {
                    clazz.defrost();
                    modifiedFile = true;
                    this.swazzler.onPreSwazzleClass(clazz);
                    for (ClassDirective classDirective : classDirectives) {
                        this.swazzler.swazzleClass(clazz, classDirective);
                    }
                    for (InterfaceDirective interfaceDirective : interfaceDirectives) {
                        this.swazzler.swazzleClass(clazz, interfaceDirective);
                    }
                    this.smartSwazzlingManager.addSwazzledClass(artifact, clazz.getName());
                    boolean encodeClassName = this.encodeExtractedFileNames && FileUtils.isEncodedClassFile(file.getName());
                    try (DataOutputStream os = this.makeFileOutput(clazz.getName(), destDir.getPath(), encodeClassName);){
                        ((OutputStream)os).write(clazz.toBytecode());
                    }
                    clazz.defrost();
                    break block24;
                }
                this.smartSwazzlingManager.addUnswazzledClass(artifact, clazz.getName());
            }
            catch (Exception e) {
                throw new SwazzlerException("An exception was thrown while swazzling the class.", e);
            }
        }
        return modifiedFile;
    }

    private DataOutputStream makeFileOutput(String className, String directoryName, boolean encodeClassName) throws FileNotFoundException {
        String dir;
        int pos;
        String fileName = directoryName + File.separatorChar + className.replace('.', File.separatorChar) + ".class";
        if (encodeClassName) {
            fileName = FileUtils.encodeFileName(fileName);
        }
        if ((pos = fileName.lastIndexOf(File.separatorChar)) > 0 && !(dir = fileName.substring(0, pos)).equals(".")) {
            new File(dir).mkdirs();
        }
        return new DataOutputStream(new BufferedOutputStream(new FileOutputStream(fileName)));
    }
}

