/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.compile.swazzler;

import io.embrace.android.gradle.swazzler.compile.manifest.ClassDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.ConstructorDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.FieldDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.InitDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.InterfaceDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.MethodDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.ObjectTypeDirective;
import io.embrace.android.gradle.swazzler.compile.manifest.SwazzleManifest;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import io.embrace.android.gradle.swazzler.util.HashUtils;
import io.embrace.android.gradle.swazzler.util.JavassistUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.CtPrimitiveType;
import javassist.Modifier;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

@Deprecated
public final class Swazzler {
    final SwazzleManifest manifest;
    final ClassPool classPool;
    final Map<String, ClassDirective> classDirectives;
    final Map<String, InterfaceDirective> interfaceDirectives;
    final String methodSuffix;
    static final Pattern SWAZZLE_METHOD_BODY_PATTERN = Pattern.compile("\\$\\.(?<macro>[A-Z]*)");
    static final String PATTERN_GROUP_MACRO = "macro";
    static final String METHOD_DEF_GET_CLASS_ID = "public long $_getClassId(){ return %s.$_classId; }";
    static final String RETURN_SWAZZLE_INJECT_CHECK = "{ if ($_getClassId() != $_classId) { return %s($$); } }";
    static final String NO_RETURN_SWAZZLE_INJECT_CHECK = "{ if ($_getClassId() != $_classId) { %s($$); return; } }";

    public Swazzler(ClassPool classPool, SwazzleManifest swazzleManifest) {
        Validate.notNull((Object)classPool, (String)"Class pool is null.", (Object[])new Object[0]);
        Validate.notNull((Object)classPool, (String)"Swazzle manifest is null.", (Object[])new Object[0]);
        this.classPool = classPool;
        this.manifest = swazzleManifest;
        this.classDirectives = this.manifest.getClasses();
        this.interfaceDirectives = this.manifest.getInterfaces();
        this.methodSuffix = this.manifest.getMethodSuffix();
    }

    public List<ClassDirective> getClassDirectives(CtClass clazz) throws Exception {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null.");
        }
        Stack<ClassDirective> directives = new Stack<ClassDirective>();
        do {
            ClassDirective directive;
            if ((directive = this.classDirectives.get(clazz.getName())) == null) continue;
            directives.push(directive);
        } while ((clazz = clazz.getSuperclass()) != null);
        return directives;
    }

    public List<InterfaceDirective> getInterfaceDirectives(CtClass clazz) throws Exception {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null.");
        }
        ArrayList<InterfaceDirective> directives = new ArrayList<InterfaceDirective>();
        for (CtClass iface : clazz.getInterfaces()) {
            InterfaceDirective directive = this.interfaceDirectives.get(iface.getName());
            if (directive == null) continue;
            directives.add(directive);
        }
        return directives;
    }

    public void swazzleClass(CtClass clazz, ObjectTypeDirective directive) throws Exception {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null.");
        }
        if (directive == null) {
            throw new IllegalArgumentException("Directive is null.");
        }
        InitDirective initDirective = directive.getInit();
        for (FieldDirective fieldDirective : directive.getFields().values()) {
            this.swazzleField(clazz, fieldDirective);
        }
        if (initDirective != null) {
            this.swazzleInit(clazz, initDirective);
        }
        for (ConstructorDirective constructorDirective : directive.getConstructors().values()) {
            this.swazzleConstructor(clazz, constructorDirective);
        }
        for (MethodDirective methodDirective : directive.getMethods().values()) {
            this.swazzleMethod(clazz, methodDirective);
        }
    }

    void swazzleField(CtClass clazz, FieldDirective directive) throws Exception {
        clazz.addField(new CtField(this.classPool.get(directive.getType()), directive.getName(), clazz));
    }

    void swazzleInit(CtClass clazz, InitDirective directive) throws Exception {
        String preSuper = directive.getPreSuper();
        String postSuper = directive.getPostSuper();
        String postBody = directive.getPostBody();
        for (CtConstructor constructor : clazz.getConstructors()) {
            if (!StringUtils.isBlank((CharSequence)preSuper)) {
                constructor.insertBefore(preSuper);
            }
            if (!StringUtils.isBlank((CharSequence)postSuper)) {
                constructor.insertBeforeBody(postSuper);
            }
            if (StringUtils.isBlank((CharSequence)postBody)) continue;
            constructor.insertAfter(postBody);
        }
    }

    void swazzleConstructor(CtClass clazz, ConstructorDirective directive) throws Exception {
        String body;
        CtConstructor constructor = clazz.getConstructor(directive.getSignature());
        String preSuper = directive.getPreSuper();
        String postSuper = directive.getPostSuper();
        String postBody = directive.getPostBody();
        if (!StringUtils.isBlank((CharSequence)preSuper)) {
            constructor.insertBefore(preSuper);
        }
        if (!StringUtils.isBlank((CharSequence)postSuper)) {
            constructor.insertBeforeBody(postSuper);
        }
        if (!StringUtils.isBlank((CharSequence)postBody)) {
            constructor.insertAfter(postBody);
        }
        if (!StringUtils.isBlank((CharSequence)(body = directive.getBody()))) {
            constructor.setBody(CtNewConstructor.make((String)body, (CtClass)clazz), null);
        }
    }

    void swazzleMethod(CtClass clazz, MethodDirective directive) throws Exception {
        String methodName;
        CtMethod method = JavassistUtils.findDeclaredMethod(clazz, directive.getName(), directive.getSignature());
        if (method != null) {
            methodName = this.getNextSwazzledMethodName(clazz, method.getName());
            method.setName(methodName);
            method.setModifiers(Modifier.setPrivate((int)method.getModifiers()));
        } else {
            methodName = "super." + directive.getName();
        }
        StringBuffer buffer = new StringBuffer();
        Matcher matcher = SWAZZLE_METHOD_BODY_PATTERN.matcher(directive.getBody());
        block6: while (matcher.find()) {
            String macro = matcher.group(PATTERN_GROUP_MACRO);
            if (macro == null) {
                throw new SwazzlerException(String.format("Null macro is method swazzle directive definition {class=%s, method=%s}.", clazz.getName(), directive.getName()));
            }
            switch (macro) {
                case "METHOD": {
                    matcher.appendReplacement(buffer, Matcher.quoteReplacement(methodName));
                    continue block6;
                }
            }
            throw new SwazzlerException(String.format("Unknown macro in method swazzle directive definition {macro=%s, class=%s, method=%s}.", macro, clazz.getName(), directive.getName()));
        }
        matcher.appendTail(buffer);
        CtMethod swazzledMethod = CtNewMethod.make((String)buffer.toString(), (CtClass)clazz);
        swazzledMethod.insertBefore(this.getSwazzleInjectCheck(swazzledMethod.getReturnType(), methodName));
        clazz.addMethod(swazzledMethod);
    }

    void onPreSwazzleClass(CtClass clazz) throws Exception {
        CtField classIdField = new CtField(this.classPool.get("long"), "$_classId", clazz);
        classIdField.setModifiers(8);
        clazz.addField(classIdField, CtField.Initializer.constant((long)HashUtils.generateCrc32Hash(clazz.getName())));
        clazz.addMethod(CtNewMethod.make((String)String.format(METHOD_DEF_GET_CLASS_ID, clazz.getName()), (CtClass)clazz));
    }

    private String getSwazzleInjectCheck(CtClass returnType, String methodName) {
        return String.format(returnType.equals(CtPrimitiveType.voidType) ? NO_RETURN_SWAZZLE_INJECT_CHECK : RETURN_SWAZZLE_INJECT_CHECK, methodName);
    }

    private String getNextSwazzledMethodName(CtClass clazz, String methodName) {
        if (clazz == null) {
            throw new IllegalArgumentException("Input class is null.");
        }
        if (StringUtils.isBlank((CharSequence)methodName)) {
            throw new IllegalArgumentException("Input method Name is null or empty.");
        }
        long methodIndex = Arrays.stream(clazz.getDeclaredMethods()).filter(declaredMethod -> declaredMethod.getName().startsWith(String.format("%s%s", methodName, this.methodSuffix))).count();
        return String.format("%s%s%d", methodName, this.methodSuffix, methodIndex);
    }
}

