/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.config.variant;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.VariantConfiguration;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\t\u001a\u00020\nH$J\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nR2\u0010\u0003\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/embrace/android/gradle/swazzler/config/variant/VariantConfigurationBuilder;", "", "()V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "buildProvider", "Lorg/gradle/api/provider/Provider;", "Lio/embrace/android/gradle/swazzler/config/VariantConfiguration;", "variant", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "buildVariantConfiguration", "embrace-swazzler"})
public abstract class VariantConfigurationBuilder {
    private final Logger<VariantConfigurationBuilder> logger = Logger.newLogger(VariantConfigurationBuilder.class);

    @NotNull
    public final Provider<VariantConfiguration> buildVariantConfiguration(@NotNull AndroidCompactedVariantData variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.logger.debug("About to build VariantConfiguration");
        Provider<VariantConfiguration> variantConfiguration = this.buildProvider(variant);
        if (!variantConfiguration.isPresent()) {
            String msg = Intrinsics.stringPlus((String)"Unable to build VariantConfiguration for variant=", (Object)variant.getName());
            this.logger.error(msg);
            throw new SwazzlerException(msg);
        }
        this.logger.debug(Intrinsics.stringPlus((String)"VariantConfiguration successfully built for variant=", (Object)variant.getName()));
        return variantConfiguration;
    }

    @NotNull
    protected abstract Provider<VariantConfiguration> buildProvider(@NotNull AndroidCompactedVariantData var1);
}

