/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.config.variant;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonReader;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.VariantConfiguration;
import io.embrace.android.gradle.swazzler.config.VariantConfigurationDeserializer;
import io.embrace.android.gradle.swazzler.config.variant.DefaultConfigurationFileFinder;
import io.embrace.android.gradle.swazzler.config.variant.VariantBuildTypeConfigurationFileFinder;
import io.embrace.android.gradle.swazzler.config.variant.VariantConfigurationFileFinder;
import io.embrace.android.gradle.swazzler.config.variant.VariantConfigurationValidator;
import io.embrace.android.gradle.swazzler.config.variant.VariantFlavorConfigurationFileFinder;
import io.embrace.android.gradle.swazzler.config.variant.VariantNameConfigurationFileFinder;
import io.embrace.android.gradle.swazzler.config.variant.VariantProductFlavorsConfigurationFileFinder;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.Directory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ \u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\rH\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/embrace/android/gradle/swazzler/config/variant/VariantConfigurationFileBuildStrategy;", "", "()V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "build", "Lio/embrace/android/gradle/swazzler/config/VariantConfiguration;", "variantInfo", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "projectDirectory", "Lorg/gradle/api/file/Directory;", "uploadMappingFileDisabled", "", "configFileFinders", "", "Lio/embrace/android/gradle/swazzler/config/variant/VariantConfigurationFileFinder;", "buildVariantConfiguration", "configFile", "Ljava/io/File;", "embrace-swazzler"})
public final class VariantConfigurationFileBuildStrategy {
    @NotNull
    public static final VariantConfigurationFileBuildStrategy INSTANCE = new VariantConfigurationFileBuildStrategy();
    private static final Logger<VariantConfigurationFileBuildStrategy> logger = Logger.newLogger(VariantConfigurationFileBuildStrategy.class);

    private VariantConfigurationFileBuildStrategy() {
    }

    @Nullable
    public final VariantConfiguration build(@NotNull AndroidCompactedVariantData variantInfo, @NotNull Directory projectDirectory, boolean uploadMappingFileDisabled, @NotNull List<? extends VariantConfigurationFileFinder> configFileFinders) {
        Intrinsics.checkNotNullParameter((Object)variantInfo, (String)"variantInfo");
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter(configFileFinders, (String)"configFileFinders");
        logger.info("Attempting to look for configuration for variant=" + variantInfo.getName() + " from file");
        Iterable $this$forEach$iv = configFileFinders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VariantConfigurationFileFinder fileFinder = (VariantConfigurationFileFinder)element$iv;
            boolean bl = false;
            File file = fileFinder.fetchFile();
            if (file == null) continue;
            return INSTANCE.buildVariantConfiguration(variantInfo, file, uploadMappingFileDisabled);
        }
        throw new SwazzlerException("embrace-config.json file was not found for variant=" + variantInfo.getName() + "\nAdd embrace-config.json file to either to app/src/main or to the specific variant folder.");
    }

    public static /* synthetic */ VariantConfiguration build$default(VariantConfigurationFileBuildStrategy variantConfigurationFileBuildStrategy, AndroidCompactedVariantData androidCompactedVariantData, Directory directory, boolean bl, List list, int n, Object object) {
        if ((n & 8) != 0) {
            Object[] objectArray = new VariantConfigurationFileFinder[]{new VariantNameConfigurationFileFinder(androidCompactedVariantData, directory), new VariantFlavorConfigurationFileFinder(androidCompactedVariantData, directory), new VariantProductFlavorsConfigurationFileFinder(androidCompactedVariantData, directory), new VariantBuildTypeConfigurationFileFinder(androidCompactedVariantData, directory), new DefaultConfigurationFileFinder(directory)};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        return variantConfigurationFileBuildStrategy.build(androidCompactedVariantData, directory, bl, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final VariantConfiguration buildVariantConfiguration(AndroidCompactedVariantData variantInfo, File configFile, boolean uploadMappingFileDisabled) {
        Closeable closeable = (Closeable)new JsonReader((Reader)new FileReader(configFile));
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            VariantConfiguration variantConfiguration;
            JsonReader reader = (JsonReader)closeable;
            boolean bl3 = false;
            try {
                GsonBuilder gsonBuilder = new GsonBuilder();
                Type type = (Type)((Object)VariantConfiguration.class);
                Logger<VariantConfigurationFileBuildStrategy> logger = VariantConfigurationFileBuildStrategy.logger;
                Intrinsics.checkNotNullExpressionValue(logger, (String)"logger");
                VariantConfiguration configuration = (VariantConfiguration)gsonBuilder.registerTypeAdapter(type, (Object)new VariantConfigurationDeserializer(logger, variantInfo.getName(), variantInfo.getVersionName())).create().fromJson(reader, (Type)((Object)VariantConfiguration.class));
                if (configuration == null) {
                    throw new IllegalArgumentException("Embrace config file at path=" + configFile.getPath() + " exists but is empty.");
                }
                variantConfiguration = !uploadMappingFileDisabled ? VariantConfigurationValidator.validate$embrace_swazzler$default(VariantConfigurationValidator.INSTANCE, configuration, VariantConfigurationValidator.VariantConfigurationSourceType.CONFIG_FILE, null, 4, null) : configuration;
            }
            catch (JsonParseException ex) {
                Throwable throwable2 = ex.getCause();
                String string = throwable2 == null ? null : throwable2.getLocalizedMessage();
                String error = string == null ? ex.getLocalizedMessage() : string;
                throw new IllegalArgumentException("Embrace config file " + configFile.getAbsoluteFile() + " contains invalid JSON.\nError=" + error);
            }
            catch (SwazzlerException ex) {
                throw new IllegalArgumentException("Problem parsing field in Embrace config file " + configFile.getAbsoluteFile() + ".\nError=" + ex.getLocalizedMessage());
            }
            VariantConfiguration variantConfiguration2 = variantConfiguration;
            return variantConfiguration2;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

