/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.instrumentation;

import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.variant.Variant;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.compile.swazzler.SwazzleFilter;
import io.embrace.android.gradle.swazzler.instrumentation.AsmCompatibilityHelper;
import io.embrace.android.gradle.swazzler.instrumentation.AsmTasks;
import io.embrace.android.gradle.swazzler.instrumentation.SwazzleParams;
import io.embrace.android.gradle.swazzler.instrumentation.TransformClassesWithReflectionException;
import io.embrace.android.gradle.swazzler.plugin.ProjectPropertiesKt;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.knownissues.KnownIssuesBuildService;
import io.embrace.android.gradle.swazzler.plugin.knownissues.KnownIssuesBuildServiceKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"registerAsmTasks", "", "project", "Lorg/gradle/api/Project;", "swazzlerExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;", "embrace-swazzler"})
@JvmName(name="AsmTasks")
public final class AsmTasks {
    public static final void registerAsmTasks(@NotNull Project project, @NotNull SwazzlerExtension swazzlerExtension) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)swazzlerExtension, (String)"swazzlerExtension");
        InstrumentationScope instrumentationScope = ProjectPropertiesKt.getInstrumentationScope(project);
        InstrumentationScope scope = instrumentationScope == null ? InstrumentationScope.ALL : instrumentationScope;
        project.getLogger().debug(Intrinsics.stringPlus((String)"ASM scope=", (Object)scope.name()));
        AsmCompatibilityHelper.INSTANCE.registerAsmFactory(project, (Action<Variant>)((Action)arg_0 -> AsmTasks.registerAsmTasks$lambda-0(project, scope, swazzlerExtension, arg_0)));
    }

    private static final void registerAsmTasks$lambda-0(Project $project, InstrumentationScope $scope, SwazzlerExtension $swazzlerExtension, Variant variant) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$scope, (String)"$scope");
        Intrinsics.checkNotNullParameter((Object)$swazzlerExtension, (String)"$swazzlerExtension");
        $project.getLogger().info("Registered ASM task for " + variant.getName() + " with scope=" + $scope.name());
        Intrinsics.checkNotNullExpressionValue((Object)variant, (String)"variant");
        AsmCompatibilityHelper.INSTANCE.setAsmFramesComputationMode(variant, FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_METHODS);
        $project.getLogger().debug(Intrinsics.stringPlus((String)"Asm frames computation mode successfully set to=", (Object)FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_METHODS));
        try {
            AsmCompatibilityHelper.INSTANCE.transformClassesWith(variant, $scope, (Function1<? super SwazzleParams, Unit>)((Function1)new Function1<SwazzleParams, Unit>($project, $swazzlerExtension, variant){
                final /* synthetic */ Project $project;
                final /* synthetic */ SwazzlerExtension $swazzlerExtension;
                final /* synthetic */ Variant $variant;
                {
                    this.$project = $project;
                    this.$swazzlerExtension = $swazzlerExtension;
                    this.$variant = $variant;
                    super(1);
                }

                public final void invoke(@NotNull SwazzleParams params) {
                    Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                    this.$project.getLogger().debug("Configuring ASM instrumentation");
                    params.getLogLevel().set(this.$project.provider(() -> registerAsmTasks.1.1.invoke$lambda-1(this.$project)));
                    params.getDisabled().set(this.$project.provider(() -> registerAsmTasks.1.1.invoke$lambda-2(this.$swazzlerExtension, this.$variant, this.$project)));
                    params.getSwazzleFilter().set(this.$swazzlerExtension.getClassSkipList().map(arg_0 -> registerAsmTasks.1.1.invoke$lambda-4(this.$project, arg_0)));
                    params.getInvalidate().set(this.$swazzlerExtension.getForceIncrementalOverwrite().map(arg_0 -> registerAsmTasks.1.1.invoke$lambda-5(this.$project, arg_0)));
                    params.getShouldInstrumentFirebaseMessaging().set((Provider)this.$swazzlerExtension.getInstrumentFirebaseMessaging());
                    params.getShouldInstrumentWebview().set((Provider)this.$swazzlerExtension.getInstrumentWebview());
                    params.getShouldInstrumentOkHttp().set((Provider)this.$swazzlerExtension.getInstrumentOkHttp());
                    params.getShouldInstrumentOnLongClick().set((Provider)this.$swazzlerExtension.getInstrumentOnLongClick());
                    params.getShouldInstrumentOnClick().set((Provider)this.$swazzlerExtension.getInstrumentOnClick());
                }

                private static final Logger.EmbraceLogLevel invoke$lambda-1(Project $project) {
                    Logger.EmbraceLogLevel embraceLogLevel;
                    Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                    String str = ProjectPropertiesKt.getLogLevel($project);
                    Logger.EmbraceLogLevel embraceLogLevel2 = Logger.EmbraceLogLevel.forName(str);
                    if (embraceLogLevel2 == null) {
                        Logger.EmbraceLogLevel embraceLogLevel3 = Logger.EmbraceLogLevel.DEFAULT;
                        boolean bl = false;
                        boolean bl2 = false;
                        Logger.EmbraceLogLevel $this$invoke_u24lambda_u2d1_u24lambda_u2d0 = embraceLogLevel3;
                        boolean bl3 = false;
                        $project.getLogger().debug(Intrinsics.stringPlus((String)"ASM config logLevel: ", (Object)$this$invoke_u24lambda_u2d1_u24lambda_u2d0.name()));
                        embraceLogLevel = embraceLogLevel3;
                    } else {
                        embraceLogLevel = embraceLogLevel2;
                    }
                    return embraceLogLevel;
                }

                private static final Boolean invoke$lambda-2(SwazzlerExtension $swazzlerExtension, Variant $variant, Project $project) {
                    Intrinsics.checkNotNullParameter((Object)$swazzlerExtension, (String)"$swazzlerExtension");
                    Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                    boolean swazzlingDisabled = $swazzlerExtension.isSwazzlingDisabled($variant.getName());
                    $project.getLogger().debug("Swazzling %s for variant=%s", (Object)(swazzlingDisabled ? "disabled" : "enabled"), (Object)$variant.getName());
                    return swazzlingDisabled;
                }

                private static final SwazzleFilter invoke$lambda-4(Project $project, List it) {
                    Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    SwazzleFilter swazzleFilter = new SwazzleFilter(it, SwazzleFilter.Kind.CLASS);
                    boolean bl = false;
                    boolean bl2 = false;
                    SwazzleFilter swazzleFilter2 = swazzleFilter;
                    boolean bl3 = false;
                    $project.getLogger().debug(Intrinsics.stringPlus((String)"ASM config classSkipList: ", (Object)CollectionsKt.joinToString$default((Iterable)swazzleFilter2.getSkipList$embrace_swazzler(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)));
                    return swazzleFilter;
                }

                private static final Long invoke$lambda-5(Project $project, Boolean invalidate) {
                    Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                    $project.getLogger().debug(Intrinsics.stringPlus((String)"ASM config invalidate: ", (Object)invalidate));
                    Intrinsics.checkNotNullExpressionValue((Object)invalidate, (String)"invalidate");
                    return invalidate != false ? System.currentTimeMillis() : -1L;
                }
            }));
            $project.getLogger().debug("Asm transformClassesWith successfully called.");
            try {
                KnownIssuesBuildServiceKt.registerKnownIssueBuildService($project, KnownIssuesBuildService.KnownIssueType.MOSHI);
            }
            catch (Throwable t) {
                $project.getLogger().debug("An exception was thrown while registering for buildFinished for known issues", t);
            }
        }
        catch (TransformClassesWithReflectionException e) {
            $project.getLogger().warn("There was a reflection issue while performing ASM bytecode transformation.\nThis shouldn't affect build output.", (Throwable)e);
        }
    }
}

