/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionAware;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.plugin.TaskException;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporterAwareTask;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.testcheckpoints.SwazzlerTestCheckPoints;
import io.embrace.android.gradle.swazzler.testcheckpoints.TestCheckpointsAwareTask;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0007H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007H\u0007J(\u0010\u0018\u001a\u00020\u0019\"\b\b\u0000\u0010\u001a*\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00112\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u0002H\u001a\u0018\u00010\u001dJ\u0014\u0010\u001e\u001a\u00020\u00192\n\u0010\u001f\u001a\u00060 j\u0002`!H\u0004J\b\u0010\"\u001a\u00020\u0019H&J\b\u0010#\u001a\u00020\u0019H\u0007R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000b\u001a&\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00000\u0000 \r*\u0012\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/GradleTask;", "Lorg/gradle/api/DefaultTask;", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildReporterAwareTask;", "Lio/embrace/android/gradle/swazzler/di/DependencyInjectionAware;", "Lio/embrace/android/gradle/swazzler/testcheckpoints/TestCheckpointsAwareTask;", "()V", "_dependency_injection_provider", "Lorg/gradle/api/provider/Property;", "Lio/embrace/android/gradle/swazzler/di/DependencyInjectionProvider;", "buildReporterProperty", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildReporter;", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "testCheckpointsProperty", "Lio/embrace/android/gradle/swazzler/testcheckpoints/SwazzlerTestCheckPoints;", "variantDataProperty", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "getBuildReporter", "getDependencyInjectionProvider", "getObjects", "Lorg/gradle/api/model/ObjectFactory;", "getTestCheckpoints", "getVariantInfo", "init", "", "T", "variantData", "configurationAction", "Lorg/gradle/api/Action;", "onException", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onRun", "run", "embrace-swazzler"})
public abstract class GradleTask
extends DefaultTask
implements BuildReporterAwareTask,
DependencyInjectionAware,
TestCheckpointsAwareTask {
    private final Logger<GradleTask> logger = Logger.newLogger(GradleTask.class);
    @NotNull
    private final Property<DependencyInjectionProvider> _dependency_injection_provider;
    @NotNull
    private final Property<BuildReporter> buildReporterProperty;
    @NotNull
    private final Property<SwazzlerTestCheckPoints> testCheckpointsProperty;
    @NotNull
    private final Property<AndroidCompactedVariantData> variantDataProperty;

    public GradleTask() {
        Property property = this.getObjects().property(DependencyInjectionProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"getObjects().property(DependencyInjectionProvider::class.java)");
        this._dependency_injection_provider = property;
        property = this.getObjects().property(BuildReporter.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"getObjects().property(BuildReporter::class.java)");
        this.buildReporterProperty = property;
        property = this.getObjects().property(AndroidCompactedVariantData.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"getObjects().property(AndroidCompactedVariantData::class.java)");
        this.variantDataProperty = property;
        property = this.getObjects().property(SwazzlerTestCheckPoints.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"getObjects().property(SwazzlerTestCheckPoints::class.java)");
        this.testCheckpointsProperty = property;
    }

    @Override
    @NotNull
    public Property<DependencyInjectionProvider> getDependencyInjectionProvider() {
        return this._dependency_injection_provider;
    }

    @Override
    @NotNull
    public Property<BuildReporter> getBuildReporter() {
        return this.buildReporterProperty;
    }

    @Override
    @NotNull
    public Property<SwazzlerTestCheckPoints> getTestCheckpoints() {
        return this.testCheckpointsProperty;
    }

    @Inject
    @NotNull
    public ObjectFactory getObjects() {
        throw new UnsupportedOperationException();
    }

    public final <T extends GradleTask> void init(@NotNull AndroidCompactedVariantData variantData, @Nullable Action<T> configurationAction) throws TaskException {
        Intrinsics.checkNotNullParameter((Object)variantData, (String)"variantData");
        this.variantDataProperty.set((Object)variantData);
        this.logger.debug("Task=" + this.getName() + " for variant=" + variantData.getName() + " is starting to get configured.");
        try {
            Action<T> action = configurationAction;
            if (action != null) {
                action.execute((Object)this);
            }
        }
        catch (Exception e) {
            ((SwazzlerTestCheckPoints)this.getTestCheckpoints().get()).exception(e);
            this.onException(e);
            throw new TaskException(Intrinsics.stringPlus((String)"An exception was thrown while initializing task: ", (Object)this.getName()), e);
        }
    }

    @TaskAction
    public final void run() {
        try {
            String msg = "Task=" + this.getName() + " for variant=" + ((AndroidCompactedVariantData)this.variantDataProperty.get()).getName() + " is starting execution.";
            this.logger.debug(msg);
            ((BuildReporter)this.getBuildReporter().get()).onBreadcrumb(msg);
            this.onRun();
            SwazzlerTestCheckPoints swazzlerTestCheckPoints = (SwazzlerTestCheckPoints)this.getTestCheckpoints().get();
            String string = this.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
            swazzlerTestCheckPoints.executed(string);
            ((BuildReporter)this.getBuildReporter().get()).onBreadcrumb("Task=" + this.getName() + " for variant=" + ((AndroidCompactedVariantData)this.variantDataProperty.get()).getName() + " finished execution.");
        }
        catch (Exception e) {
            this.onException(e);
            ((SwazzlerTestCheckPoints)this.getTestCheckpoints().get()).exception(e);
            throw e;
        }
    }

    @Internal
    @NotNull
    public final Property<AndroidCompactedVariantData> getVariantInfo() {
        return this.variantDataProperty;
    }

    public abstract void onRun();

    protected final void onException(@NotNull Exception ex) {
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        AndroidCompactedVariantData androidCompactedVariantData = (AndroidCompactedVariantData)this.getVariantInfo().getOrNull();
        ((BuildReporter)this.getBuildReporter().get()).onException(androidCompactedVariantData == null ? null : androidCompactedVariantData.getName(), ex);
    }
}

