/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.plugin.GradleTask;
import io.embrace.android.gradle.swazzler.plugin.PluginErrorMessages;
import io.embrace.android.gradle.swazzler.plugin.TaskException;
import java.io.IOException;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;

public abstract class GradleUploadTask
extends GradleTask {
    public static final String KEY_APP_ID = "app";
    public static final String KEY_API_TOKEN = "token";
    public static final String KEY_BUILD_ID = "id";
    public static final String KEY_MAPPING_FILE = "file";
    public static final String HEADER_APP_ID = "X-EM-AID";
    private static final Logger logger = Logger.newLogger(GradleUploadTask.class);
    private Property<String> appId = this.getObjects().property(String.class);
    private Property<String> apiToken = this.getObjects().property(String.class);
    private Property<String> urlSymbolUpload = this.getObjects().property(String.class);

    protected void executeUpload(String url, RequestBody requestBody, UploadResponse callback) throws IOException, TaskException {
        logger.debug("Preparing request for task to " + url);
        Request request = new Request.Builder().url(url).addHeader(HEADER_APP_ID, (String)this.appId.get()).post(requestBody).build();
        logger.debug("Executing HTTP call");
        try (Response response = ((DependencyInjectionProvider)this.getDependencyInjectionProvider().get()).getOkHttpClient().newCall(request).execute();){
            if (!response.isSuccessful()) {
                String responseMsg;
                ResponseBody body;
                int statusCode = response.code();
                logger.debug("Response was not successful, status " + response.code());
                if (statusCode == 403) {
                    String authMsg = PluginErrorMessages.getInvalidApiTokenError((String)this.appId.get(), (String)this.apiToken.get());
                    logger.error(authMsg);
                    throw new TaskException(authMsg);
                }
                String errorMsg = String.format("Skipping upload since upload service returned status code: %d", statusCode);
                if (statusCode >= 400 && (body = response.body()) != null && (responseMsg = body.string()) != null) {
                    logger.debug("Response raw body: " + responseMsg);
                    errorMsg = String.format("%s error: %s", errorMsg, responseMsg);
                }
                callback.onError(errorMsg, statusCode);
            } else {
                logger.debug("Response was successful, status " + response.code());
                callback.onResponse(response.body());
            }
        }
    }

    @Input
    public Property<String> getAppId() {
        return this.appId;
    }

    @Input
    public Property<String> getApiToken() {
        return this.apiToken;
    }

    @Input
    @Optional
    public Property<String> getUrlSymbolUpload() {
        return this.urlSymbolUpload;
    }

    public static interface UploadResponse {
        public void onResponse(ResponseBody var1) throws IOException;

        public void onError(String var1, int var2);
    }
}

