/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin;

import org.apache.commons.lang3.Validate;

public final class PluginErrorMessages {
    static final String ERROR_NOT_SET_APP_ID = "The Embrace App ID was not set. Go to https://embrace.io/docs/android/ for instructions on how to set this value.";
    static final String ERROR_NOT_SET_API_TOKEN = "The Embrace API token was not set. Go to https://embrace.io/docs/android/ for instructions on how to set this value.";
    static final String ERROR_INVALID_APP_ID = "The Embrace App ID (%s) is invalid. Go to https://embrace.io/docs/android/ for instructions on how to set this value.";
    static final String ERROR_INVALID_API_TOKEN = "The Embrace API token (%s) is invalid for the App ID (%s). Please check https://dash.embrace.io/settings/organization/api and verify that the API token displayed matches what was provided.";
    static final String ERROR_PROJECT_CLEAN_NEEDED = "Please run 'Build > Clean project' first to solve this.";

    private PluginErrorMessages() {
    }

    public static String getNotSetAppIdError() {
        return ERROR_NOT_SET_APP_ID;
    }

    public static String getNotSetApiTokenError() {
        return ERROR_NOT_SET_API_TOKEN;
    }

    public static String getInvalidAppIdError(String appId) {
        Validate.notNull((Object)appId, (String)"App ID is null.", (Object[])new Object[0]);
        return String.format(ERROR_INVALID_APP_ID, appId);
    }

    public static String getInvalidApiTokenError(String appId, String apiToken) {
        Validate.notEmpty((CharSequence)appId, (String)"App ID is null or blank.", (Object[])new Object[0]);
        Validate.notNull((Object)apiToken, (String)"API token is null.", (Object[])new Object[0]);
        return String.format(ERROR_INVALID_API_TOKEN, apiToken, appId);
    }

    public static String getProjectCleanNeeded() {
        return ERROR_PROJECT_CLEAN_NEEDED;
    }
}

