/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.builder.model.ApiVersion;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.Config;
import io.embrace.android.gradle.swazzler.config.VariantConfiguration;
import io.embrace.android.gradle.swazzler.config.variant.VariantConfigurationBuilderForValueSource;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.di.SetupDependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.instrumentation.AsmCompatibilityHelper;
import io.embrace.android.gradle.swazzler.instrumentation.AsmTasks;
import io.embrace.android.gradle.swazzler.plugin.ProjectPropertiesKt;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import io.embrace.android.gradle.swazzler.plugin.buildid.BuildIdProvider;
import io.embrace.android.gradle.swazzler.plugin.buildid.DefaultBuildIdProviderKt;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.SetupExecutionPhaseBuildReporter;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.configphase.GradlePhaseInfo;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.configphase.SetupGradlePhaseInfo;
import io.embrace.android.gradle.swazzler.plugin.configuration.TasksConfigurator;
import io.embrace.android.gradle.swazzler.plugin.configuration.TasksConfiguratorFactory;
import io.embrace.android.gradle.swazzler.plugin.dependency.DependenciesInstallerKt;
import io.embrace.android.gradle.swazzler.plugin.extension.EmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.ProjectNotSmartConfigurationToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.ProjectSmartConfigurationToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.OldTransformTasksKt;
import io.embrace.android.gradle.swazzler.testcheckpoints.SetupTestCheckpoints;
import io.embrace.android.gradle.swazzler.testcheckpoints.SwazzlerTestCheckPoints;
import io.embrace.android.gradle.swazzler.util.AgpUtils;
import io.embrace.android.gradle.swazzler.util.DeprecationsVerificator;
import io.embrace.android.gradle.swazzler.util.SystemWrapper;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\f2\n\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0002J(\u0010\u001f\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00000\u0000 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/embrace/android/gradle/swazzler/plugin/SwazzlerPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "buildReporter", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildReporter;", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "testCheckpoints", "Lio/embrace/android/gradle/swazzler/testcheckpoints/SwazzlerTestCheckPoints;", "apply", "", "project", "buildConfig", "Lio/embrace/android/gradle/swazzler/config/Config;", "configureEmbraceExtensionInternalForProject", "swazzlerExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;", "handlePluginException", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "initializeBuildIdProvider", "Lorg/gradle/api/provider/Provider;", "Lio/embrace/android/gradle/swazzler/plugin/buildid/BuildIdProvider;", "onProjectEvaluated", "evaluatedProject", "androidExtension", "Lcom/android/build/gradle/AppExtension;", "registerDependencyManager", "registerSwazzling", "config", "verifyDesugaringForOldDevices", "embrace-swazzler"})
public final class SwazzlerPlugin
implements Plugin<Project> {
    private final Logger<SwazzlerPlugin> logger = Logger.newLogger(SwazzlerPlugin.class);
    @Nullable
    private BuildReporter buildReporter;
    private SwazzlerTestCheckPoints testCheckpoints;

    public void apply(@NotNull Project project) throws SwazzlerException {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Directory directory = project.getLayout().getProjectDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)directory, (String)"project.layout.projectDirectory");
        DeprecationsVerificator.INSTANCE.verifySwazzlerJsonConfiguration(directory);
        Provider<? extends GradlePhaseInfo> provider = SetupGradlePhaseInfo.INSTANCE.build(project);
        boolean bl = false;
        boolean bl2 = false;
        Provider<? extends GradlePhaseInfo> it = provider;
        boolean bl3 = false;
        this.logger.info("Gradle configuration phase running");
        ((GradlePhaseInfo)it.get()).onConfigurationPhaseRan();
        Provider<? extends GradlePhaseInfo> gradlePhaseInfo = provider;
        SystemWrapper systemWrapper = new SystemWrapper();
        Object[] objectArray = new Object[]{project.getObjects()};
        SwazzlerExtension swazzlerExtension = (SwazzlerExtension)project.getExtensions().create("swazzler", SwazzlerExtension.class, objectArray);
        this.logger.debug("Swazzler extension successfully created");
        ListProperty variantConfigurationsListProperty = project.getObjects().listProperty(VariantConfiguration.class).convention((Iterable)CollectionsKt.emptyList());
        Provider<BuildIdProvider> buildIdProvider = this.initializeBuildIdProvider(project);
        SetupTestCheckpoints setupTestCheckpoints = new SetupTestCheckpoints();
        Object object = project.getRootProject().getLayout().getProjectDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.rootProject.layout.projectDirectory");
        this.testCheckpoints = setupTestCheckpoints.invoke(project, (Directory)object, ProjectPropertiesKt.isTestCheckpointsEnabled(project));
        object = this.testCheckpoints;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testCheckpoints");
            throw null;
        }
        object.started();
        Logger.setEmbraceLogLevel(ProjectPropertiesKt.getLogLevel(project));
        this.logger.info("Embrace plugin entry point for project=" + project.getName() + ". Will not configure until android application plugin has been applied.");
        project.getPluginManager().withPlugin("com.android.application", arg_0 -> SwazzlerPlugin.apply$lambda-2(this, project, variantConfigurationsListProperty, systemWrapper, buildIdProvider, gradlePhaseInfo, swazzlerExtension, arg_0));
    }

    private final void onProjectEvaluated(Project evaluatedProject, AppExtension androidExtension) {
        try {
            this.logger.info("Project=" + evaluatedProject.getName() + " has been evaluated.");
            this.verifyDesugaringForOldDevices(androidExtension);
            this.registerDependencyManager(evaluatedProject);
            this.logger.info("Successfully configured Embrace.io swazzler plugin.");
        }
        catch (Exception e) {
            this.handlePluginException(e);
        }
    }

    private final void verifyDesugaringForOldDevices(AppExtension androidExtension) {
        boolean enableDesugaring = false;
        try {
            boolean shouldEnableDesugaring = false;
            DefaultConfig defaultConfig = androidExtension.getDefaultConfig();
            boolean bl = false;
            boolean bl2 = false;
            DefaultConfig $this$verifyDesugaringForOldDevices_u24lambda_u2d3 = defaultConfig;
            boolean bl3 = false;
            Integer localMinSdk = AgpUtils.INSTANCE.getMinSdk($this$verifyDesugaringForOldDevices_u24lambda_u2d3);
            ApiVersion localMinSdkVersion = AgpUtils.INSTANCE.getMinSdkVersion($this$verifyDesugaringForOldDevices_u24lambda_u2d3);
            if (localMinSdk != null) {
                shouldEnableDesugaring = AgpUtils.INSTANCE.isDesugaringRequired(localMinSdk);
                throw new SwazzlerException("");
            }
            if (localMinSdkVersion != null) {
                shouldEnableDesugaring = AgpUtils.INSTANCE.isDesugaringRequired(localMinSdkVersion);
            }
            if (shouldEnableDesugaring) {
                enableDesugaring = !AgpUtils.INSTANCE.isDesugaringEnabled(androidExtension);
            }
        }
        catch (Throwable e) {
            this.logger.info("There was an exception while checking if desugaring is required. We will consider desugaring is not required. Build will continue normally.");
        }
        if (enableDesugaring) {
            throw new SwazzlerException("Desugaring must be enabled when minSdk is < 24, otherwise devices on android sdk < 24 will fail at runtime.\nYou can enable desugaring by adding the following:\ncompileOptions\n{\n  coreLibraryDesugaringEnabled = true\n}\ndependencies {\n    // For AGP 7.4+\n    coreLibraryDesugaring 'com.android.tools:desugar_jdk_libs:2.0.3'\n    // For AGP 7.3\n    // coreLibraryDesugaring 'com.android.tools:desugar_jdk_libs:1.2.3'\n    // For AGP 4.0 to 7.2\n    // coreLibraryDesugaring 'com.android.tools:desugar_jdk_libs:1.1.9'\n}\nin your app's module build.gradle file.\nYou can find more info at: \nhttps://developer.android.com/studio/write/java8-support#library-desugaring");
        }
        this.logger.info("MinSdk is < 24 and desugaring is enabled. We are good to proceed.");
    }

    private final void configureEmbraceExtensionInternalForProject(Project project, SwazzlerExtension swazzlerExtension) {
        ExtensionContainer extensionContainer = project.getExtensions();
        boolean bl = false;
        boolean bl2 = false;
        ExtensionContainer $this$configureEmbraceExtensionInternalForProject_u24lambda_u2d4 = extensionContainer;
        boolean bl3 = false;
        $this$configureEmbraceExtensionInternalForProject_u24lambda_u2d4.configure(EmbraceExtensionInternal.class, (Action)new ProjectSmartConfigurationToEmbraceExtensionInternal(project, swazzlerExtension));
        $this$configureEmbraceExtensionInternalForProject_u24lambda_u2d4.configure(EmbraceExtensionInternal.class, (Action)new ProjectNotSmartConfigurationToEmbraceExtensionInternal(swazzlerExtension));
    }

    private final void registerSwazzling(AppExtension androidExtension, SwazzlerExtension swazzlerExtension, Project project, Config config) {
        if (AsmCompatibilityHelper.INSTANCE.shouldUseASM(project)) {
            this.logger.info("Using WebObject ASM API for Swazzling");
            AsmTasks.registerAsmTasks(project, swazzlerExtension);
            this.logger.debug("Successfully registered WebOjbect ASM API");
        } else {
            this.logger.info("Using Transform API for Swazzling");
            OldTransformTasksKt.registerOldTransformTasks(project, androidExtension, swazzlerExtension, config);
            this.logger.debug("Successfully registered Old Transform API");
        }
    }

    private final Provider<BuildIdProvider> initializeBuildIdProvider(Project project) {
        this.logger.debug("Creating build id provider that will be used for all tasks");
        Provider<BuildIdProvider> buildIdProvider = DefaultBuildIdProviderKt.buildBuildIdProvider(project);
        this.logger.debug("Successfully created build id provider");
        return buildIdProvider;
    }

    private final void handlePluginException(Exception e) {
        Object object = this.testCheckpoints;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"testCheckpoints");
            throw null;
        }
        object.exception(e);
        object = this.buildReporter;
        if (object != null) {
            object.onException(e);
        }
        throw e;
    }

    private final Config buildConfig(Project project) {
        Config config;
        this.logger.debug("Initializing config");
        String baseUrl = ProjectPropertiesKt.getBaseUrl(project);
        CharSequence charSequence = baseUrl;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.logger.debug(Intrinsics.stringPlus((String)"Replacing host with:", (Object)baseUrl));
            config = new Config(baseUrl, null, 2, null);
        } else {
            config = new Config(null, null, 3, null);
        }
        return config;
    }

    private final void registerDependencyManager(Project project) {
        this.logger.info("Will install embrace dependencies.");
        DependenciesInstallerKt.installDependencies(project, DependenciesInstallerKt.getInstallStrategies());
    }

    private static final void apply$lambda-2$lambda-1(SwazzlerPlugin this$0, AppExtension $androidExtension, Project evaluatedProject) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$androidExtension, (String)"$androidExtension");
        Intrinsics.checkNotNullExpressionValue((Object)evaluatedProject, (String)"evaluatedProject");
        this$0.onProjectEvaluated(evaluatedProject, $androidExtension);
    }

    private static final void apply$lambda-2(SwazzlerPlugin this$0, Project $project, ListProperty $variantConfigurationsListProperty, SystemWrapper $systemWrapper, Provider $buildIdProvider, Provider $gradlePhaseInfo, SwazzlerExtension $swazzlerExtension, AppliedPlugin it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$systemWrapper, (String)"$systemWrapper");
        Intrinsics.checkNotNullParameter((Object)$buildIdProvider, (String)"$buildIdProvider");
        Intrinsics.checkNotNullParameter((Object)$gradlePhaseInfo, (String)"$gradlePhaseInfo");
        this$0.logger.info("Android Application plugin has been applied for project=" + $project.getName() + ". Starting to configure embrace plugin.");
        try {
            Config config = this$0.buildConfig($project);
            Object v = $project.getProperties().get("android");
            if (v == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.build.gradle.AppExtension");
            }
            AppExtension androidExtension = (AppExtension)v;
            this$0.logger.debug("Android extension obtained.");
            Object[] objectArray = new Object[]{$project.getObjects()};
            EmbraceExtensionInternal extension = (EmbraceExtensionInternal)$project.getExtensions().create("embrace-internal", EmbraceExtensionInternal.class, objectArray);
            objectArray = $project.getObjects().domainObjectContainer(EmbraceExtensionInternal.VariantExtension.class);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"project.objects.domainObjectContainer(\n                        EmbraceExtensionInternal.VariantExtension::class.java\n                    )");
            extension.setVariants((NamedDomainObjectContainer<EmbraceExtensionInternal.VariantExtension>)objectArray);
            this$0.logger.debug("Embrace extension successfully created");
            SetupDependencyInjectionProvider setupDependencyInjectionProvider = new SetupDependencyInjectionProvider(null, 1, null);
            Provider<? extends DependencyInjectionProvider> dependencyInjectionProvider = setupDependencyInjectionProvider.invoke($project, config);
            $variantConfigurationsListProperty.finalizeValueOnRead();
            SetupExecutionPhaseBuildReporter setupExecutionPhaseBuildReporter = new SetupExecutionPhaseBuildReporter();
            Intrinsics.checkNotNullExpressionValue((Object)$variantConfigurationsListProperty, (String)"variantConfigurationsListProperty");
            this$0.buildReporter = setupExecutionPhaseBuildReporter.invoke($project, $systemWrapper, dependencyInjectionProvider, (ListProperty<VariantConfiguration>)$variantConfigurationsListProperty, (Provider<BuildIdProvider>)$buildIdProvider, (Provider<? extends GradlePhaseInfo>)$gradlePhaseInfo);
            this$0.logger.debug("About to register swazzling.");
            Intrinsics.checkNotNullExpressionValue((Object)$swazzlerExtension, (String)"swazzlerExtension");
            this$0.registerSwazzling(androidExtension, $swazzlerExtension, $project, config);
            Object object = $project.getLayout().getProjectDirectory();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.layout.projectDirectory");
            Directory directory = object;
            object = $project.getProviders();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.providers");
            VariantConfigurationBuilderForValueSource variantConfigurationBuilder = new VariantConfigurationBuilderForValueSource(directory, (ProviderFactory)object, ProjectPropertiesKt.isUploadMappingFilesDisabled($project));
            this$0.logger.info("About to configure each variant");
            this$0.configureEmbraceExtensionInternalForProject($project, $swazzlerExtension);
            try {
                this$0.logger.info("About to configure embrace tasks");
                TasksConfigurator tasksConfigurator = new TasksConfiguratorFactory($project, (Provider<BuildIdProvider>)$buildIdProvider, variantConfigurationBuilder, config, (ListProperty<VariantConfiguration>)$variantConfigurationsListProperty).buildTaskConfigurator();
                tasksConfigurator.configureTasks();
            }
            catch (Exception e) {
                this$0.handlePluginException(e);
            }
            this$0.logger.info("Registering Project's after evaluation listener.");
            $project.afterEvaluate(arg_0 -> SwazzlerPlugin.apply$lambda-2$lambda-1(this$0, androidExtension, arg_0));
            object = this$0.testCheckpoints;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"testCheckpoints");
                throw null;
            }
            object.finished();
        }
        catch (Exception e) {
            this$0.handlePluginException(e);
        }
    }
}

