/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.buildreporter;

import com.google.common.annotations.VisibleForTesting;
import com.google.gson.Gson;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildCheckpoints;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildData;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.TaskData;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.TaskMetadata;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.VariantData;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.VariantDescriptor;
import java.io.Closeable;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0003@ABB%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\b\u0010\u0013\u001a\u00020\u0003H\u0007J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u001dJ \u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u001d2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007J\u000f\u0010 \u001a\u0004\u0018\u00010!H\u0007\u00a2\u0006\u0002\u0010\"J\n\u0010#\u001a\u0004\u0018\u00010\u0016H\u0007J\u001a\u0010$\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007J\u001f\u0010%\u001a\u0004\u0018\u00010!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010&J\u001f\u0010'\u001a\u0004\u0018\u00010!2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010&J\u001f\u0010(\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010)\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010*\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0018J\u001f\u0010+\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0007\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0016J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020!J\u001c\u00101\u001a\u00020\u00032\b\u00102\u001a\u0004\u0018\u0001032\n\u00104\u001a\u000605j\u0002`6J\u0012\u00101\u001a\u00020\u00032\n\u00104\u001a\u000605j\u0002`6J\u000e\u00107\u001a\u00020/2\u0006\u00100\u001a\u00020!J\u000e\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020\u0016J\u000e\u0010:\u001a\u00020\u00032\u0006\u0010;\u001a\u00020<J\u0006\u0010=\u001a\u00020/J\b\u0010>\u001a\u00020/H\u0002J\u0006\u0010?\u001a\u00020\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\n\u001a\u00020\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints;", "", "checkpointsDisabled", "", "isTestingEnabled", "writer", "Ljava/io/FileWriter;", "(ZZLjava/io/FileWriter;)V", "checkpoints", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$Checkpoints;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "Lkotlin/Lazy;", "collectBuildDynamicData", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildData;", "buildData", "didBuildFinishedSuccessfully", "didTaskFinishedSuccessfully", "variantName", "", "taskName", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Boolean;", "findTaskCheckpoint", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$TaskCheckpoint;", "getAppId", "getBreadcrumbs", "", "getExceptions", "getExecutionReasons", "getFirstTaskStartedExecutionTime", "", "()Ljava/lang/Long;", "getMetadataRequestId", "getSkippedMessage", "getTaskEndTime", "(Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Long;", "getTaskStarTime", "isTaskConfigured", "isTaskExecuted", "isTaskFromCache", "isTaskRegistered", "onBreadcrumb", "warning", "onBuildFinished", "", "timestamp", "onException", "variantDescriptor", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/VariantDescriptor;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onFirstTaskStartedExecution", "onMetadataRequestId", "id", "onTaskEvent", "taskMetadata", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/TaskMetadata;", "onTaskFailed", "safelyWriteToDisk", "toJson", "Checkpoints", "TaskCheckpoint", "VariantCheckpoint", "embrace-swazzler"})
public final class BuildCheckpoints {
    private final boolean checkpointsDisabled;
    private final boolean isTestingEnabled;
    @Nullable
    private final FileWriter writer;
    @NotNull
    private Checkpoints checkpoints;
    @NotNull
    private final Lazy gson$delegate;

    public BuildCheckpoints(boolean checkpointsDisabled, boolean isTestingEnabled, @Nullable FileWriter writer) {
        this.checkpointsDisabled = checkpointsDisabled;
        this.isTestingEnabled = isTestingEnabled;
        this.writer = writer;
        this.checkpoints = new Checkpoints(null, null, null, false, null, null, null, 127, null);
        this.gson$delegate = LazyKt.lazy((Function0)gson.2.INSTANCE);
    }

    public /* synthetic */ BuildCheckpoints(boolean bl, boolean bl2, FileWriter fileWriter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            fileWriter = null;
        }
        this(bl, bl2, fileWriter);
    }

    private final Gson getGson() {
        Lazy lazy = this.gson$delegate;
        boolean bl = false;
        return (Gson)lazy.getValue();
    }

    public final boolean onTaskEvent(@NotNull TaskMetadata taskMetadata) {
        Intrinsics.checkNotNullParameter((Object)taskMetadata, (String)"taskMetadata");
        if (this.checkpointsDisabled) {
            return false;
        }
        this.checkpoints.addTaskEvent(taskMetadata);
        this.safelyWriteToDisk();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final BuildData collectBuildDynamicData(@NotNull BuildData buildData) {
        Intrinsics.checkNotNullParameter((Object)buildData, (String)"buildData");
        boolean bl = false;
        boolean bl2 = false;
        BuildData $this$collectBuildDynamicData_u24lambda_u2d3 = buildData;
        boolean bl3 = false;
        $this$collectBuildDynamicData_u24lambda_u2d3.setBuildFailed(this.checkpoints.getBuildFailed());
        $this$collectBuildDynamicData_u24lambda_u2d3.setBuildStartedTime(this.checkpoints.getBuildStartedTime());
        $this$collectBuildDynamicData_u24lambda_u2d3.setBuildEndTime(this.checkpoints.getBuildEndTime());
        $this$collectBuildDynamicData_u24lambda_u2d3.getGeneralExceptions().addAll((Collection<String>)this.getExceptions());
        $this$collectBuildDynamicData_u24lambda_u2d3.getGeneralBreadcrumbs().addAll((Collection<String>)this.getBreadcrumbs());
        Iterable $this$forEach$iv = this.checkpoints.getVariantsCheckpoints();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Collection<TaskData> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            VariantData variant;
            VariantData variantData;
            VariantCheckpoint variantCheckpoint = (VariantCheckpoint)element$iv;
            boolean bl4 = false;
            Iterable<VariantData> iterable = $this$collectBuildDynamicData_u24lambda_u2d3.getVariantMetadata();
            if (iterable == null) {
                variantData = null;
            } else {
                Object v1;
                block5: {
                    Iterable $this$firstOrNull$iv = iterable;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        VariantData it = (VariantData)element$iv2;
                        boolean bl5 = false;
                        if (!StringsKt.equals((String)it.getVariantName(), (String)variantCheckpoint.getVariantName(), (boolean)true)) continue;
                        v1 = element$iv2;
                        break block5;
                    }
                    v1 = null;
                }
                variantData = v1;
            }
            if ((variant = variantData) == null) continue;
            variant.getExceptions().addAll((Collection<String>)variantCheckpoint.getExceptions());
            iterable = variantCheckpoint.getEmbraceTasks();
            Set<TaskData> set = variant.getEmbraceTasks();
            boolean $i$f$map = false;
            void $i$f$firstOrNull = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void taskCheckpoint;
                TaskCheckpoint taskCheckpoint2 = (TaskCheckpoint)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl6 = false;
                TaskData taskData = new TaskData(taskCheckpoint.getTaskName(), taskCheckpoint.getStartTime(), taskCheckpoint.getEndTime(), taskCheckpoint.getRegistered(), taskCheckpoint.getConfigured(), taskCheckpoint.getExecuted(), taskCheckpoint.getFinishedSuccessfully(), taskCheckpoint.getSkippedMessage(), taskCheckpoint.getExecutionReasons(), taskCheckpoint.isFromCache());
                collection.add(taskData);
            }
            collection = (List)destination$iv$iv;
            set.addAll(collection);
        }
        return buildData;
    }

    public final boolean onException(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (this.checkpointsDisabled) {
            return false;
        }
        this.checkpoints.addException(exception);
        this.safelyWriteToDisk();
        return true;
    }

    public final boolean onException(@Nullable VariantDescriptor variantDescriptor, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        if (this.checkpointsDisabled) {
            return false;
        }
        if (variantDescriptor == null) {
            this.onException(exception);
        } else {
            this.checkpoints.addException(variantDescriptor, exception);
        }
        this.safelyWriteToDisk();
        return true;
    }

    public final void onTaskFailed() {
        this.checkpoints.setBuildFailed(true);
    }

    public final void onFirstTaskStartedExecution(long timestamp) {
        this.checkpoints.setBuildStartedTime(timestamp);
    }

    public final void onMetadataRequestId(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.checkpoints.setMetadataRequestId(id);
    }

    public final void onBuildFinished(long timestamp) {
        this.checkpoints.setBuildEndTime(timestamp);
    }

    public final boolean onBreadcrumb(@NotNull String warning) {
        Intrinsics.checkNotNullParameter((Object)warning, (String)"warning");
        if (this.checkpointsDisabled) {
            return false;
        }
        this.checkpoints.addBreadcrumb(warning);
        this.safelyWriteToDisk();
        return true;
    }

    @NotNull
    public final String toJson() {
        String string = this.getGson().toJson((Object)this.checkpoints);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(checkpoints)");
        return string;
    }

    private final TaskCheckpoint findTaskCheckpoint(String variantName, String taskName) {
        VariantCheckpoint variantCheckpoint = this.checkpoints.getVariantCheckpoint(variantName);
        return variantCheckpoint == null ? null : variantCheckpoint.getTaskCheckpoint(taskName);
    }

    @VisibleForTesting
    @Nullable
    public final String getAppId(@NotNull String variantName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        VariantCheckpoint variantCheckpoint = this.checkpoints.getVariantCheckpoint(variantName);
        return variantCheckpoint == null ? null : variantCheckpoint.getAppId();
    }

    @VisibleForTesting
    @Nullable
    public final Boolean isTaskRegistered(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint == null ? null : Boolean.valueOf(taskCheckpoint.getRegistered());
    }

    @VisibleForTesting
    @Nullable
    public final Boolean isTaskConfigured(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint == null ? null : Boolean.valueOf(taskCheckpoint.getConfigured());
    }

    @VisibleForTesting
    @Nullable
    public final Boolean isTaskExecuted(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint == null ? null : Boolean.valueOf(taskCheckpoint.getExecuted());
    }

    @VisibleForTesting
    @Nullable
    public final Long getTaskStarTime(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint == null ? null : Long.valueOf(taskCheckpoint.getStartTime());
    }

    @VisibleForTesting
    @Nullable
    public final Long getTaskEndTime(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint == null ? null : Long.valueOf(taskCheckpoint.getEndTime());
    }

    @VisibleForTesting
    @Nullable
    public final Boolean didTaskFinishedSuccessfully(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint == null ? null : Boolean.valueOf(taskCheckpoint.getFinishedSuccessfully());
    }

    @VisibleForTesting
    @Nullable
    public final String getSkippedMessage(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint == null ? null : taskCheckpoint.getSkippedMessage();
    }

    @VisibleForTesting
    @Nullable
    public final List<String> getExecutionReasons(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint == null ? null : taskCheckpoint.getExecutionReasons();
    }

    @VisibleForTesting
    @Nullable
    public final Boolean isTaskFromCache(@NotNull String variantName, @NotNull String taskName) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        TaskCheckpoint taskCheckpoint = this.findTaskCheckpoint(variantName, taskName);
        return taskCheckpoint == null ? null : taskCheckpoint.isFromCache();
    }

    @VisibleForTesting
    public final boolean didBuildFinishedSuccessfully() {
        return !this.checkpoints.getBuildFailed();
    }

    @VisibleForTesting
    @Nullable
    public final Long getFirstTaskStartedExecutionTime() {
        return this.checkpoints.getBuildStartedTime();
    }

    @VisibleForTesting
    @Nullable
    public final String getMetadataRequestId() {
        return this.checkpoints.getMetadataRequestId();
    }

    @NotNull
    public final List<String> getExceptions() {
        List<String> list = Collections.unmodifiableList(this.checkpoints.getExceptions());
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(checkpoints.exceptions)");
        return list;
    }

    @NotNull
    public final List<String> getBreadcrumbs() {
        List<String> list = Collections.unmodifiableList(this.checkpoints.getBreadcrumbs());
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(checkpoints.breadcrumbs)");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void safelyWriteToDisk() {
        block8: {
            if (!this.isTestingEnabled) {
                return;
            }
            try {
                FileWriter fileWriter = this.writer;
                if (fileWriter == null) break block8;
                Closeable closeable = fileWriter;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    FileWriter it = (FileWriter)closeable;
                    boolean bl3 = false;
                    it.write(this.toJson());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException e) {
                System.err.println("Exception for file: checkpoints.txt");
                e.printStackTrace();
            }
        }
    }

    public BuildCheckpoints() {
        this(false, false, null, 7, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001Bc\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0006J\u0016\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u000e\u0010%\u001a\u00020#2\u0006\u0010(\u001a\u00020)J\u000e\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,J\u0010\u0010-\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)H\u0002J\u000f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\u000f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\tH\u00c6\u0003J\u0010\u00102\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\u0010\u00103\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012J\u000b\u00104\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003Jl\u00105\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00032\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u0006H\u00c6\u0001\u00a2\u0006\u0002\u00106J\u0016\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u00062\u0006\u00109\u001a\u00020\u0006J\u0013\u0010:\u001a\u00020\t2\b\u0010;\u001a\u0004\u0018\u00010<H\u00d6\u0003J\u0012\u0010=\u001a\u0004\u0018\u00010\u00042\u0006\u00108\u001a\u00020\u0006H\u0007J\t\u0010>\u001a\u00020?H\u00d6\u0001J\t\u0010@\u001a\u00020\u0006H\u00d6\u0001R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u001a\u0010\u0012\"\u0004\b\u001b\u0010\u0014R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0010R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0010\u00a8\u0006A"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$Checkpoints;", "Ljava/io/Serializable;", "variantsCheckpoints", "", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$VariantCheckpoint;", "exceptions", "", "breadcrumbs", "buildFailed", "", "buildStartedTime", "", "buildEndTime", "metadataRequestId", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLjava/lang/Long;Ljava/lang/Long;Ljava/lang/String;)V", "getBreadcrumbs", "()Ljava/util/List;", "getBuildEndTime", "()Ljava/lang/Long;", "setBuildEndTime", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "getBuildFailed", "()Z", "setBuildFailed", "(Z)V", "getBuildStartedTime", "setBuildStartedTime", "getExceptions", "getMetadataRequestId", "()Ljava/lang/String;", "setMetadataRequestId", "(Ljava/lang/String;)V", "getVariantsCheckpoints", "addBreadcrumb", "", "breadcrumbMessage", "addException", "variantDescriptor", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/VariantDescriptor;", "exception", "Ljava/lang/Exception;", "addTaskEvent", "taskMetadata", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/TaskMetadata;", "buildFullStacktrace", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;ZLjava/lang/Long;Ljava/lang/Long;Ljava/lang/String;)Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$Checkpoints;", "createVariantCheckpoint", "variantName", "appId", "equals", "other", "", "getVariantCheckpoint", "hashCode", "", "toString", "embrace-swazzler"})
    private static final class Checkpoints
    implements Serializable {
        @NotNull
        private final List<VariantCheckpoint> variantsCheckpoints;
        @NotNull
        private final List<String> exceptions;
        @NotNull
        private final List<String> breadcrumbs;
        private boolean buildFailed;
        @Nullable
        private Long buildStartedTime;
        @Nullable
        private Long buildEndTime;
        @Nullable
        private String metadataRequestId;

        public Checkpoints(@NotNull List<VariantCheckpoint> variantsCheckpoints, @NotNull List<String> exceptions, @NotNull List<String> breadcrumbs, boolean buildFailed, @Nullable Long buildStartedTime, @Nullable Long buildEndTime, @Nullable String metadataRequestId) {
            Intrinsics.checkNotNullParameter(variantsCheckpoints, (String)"variantsCheckpoints");
            Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
            Intrinsics.checkNotNullParameter(breadcrumbs, (String)"breadcrumbs");
            this.variantsCheckpoints = variantsCheckpoints;
            this.exceptions = exceptions;
            this.breadcrumbs = breadcrumbs;
            this.buildFailed = buildFailed;
            this.buildStartedTime = buildStartedTime;
            this.buildEndTime = buildEndTime;
            this.metadataRequestId = metadataRequestId;
        }

        public /* synthetic */ Checkpoints(List list, List list2, List list3, boolean bl, Long l, Long l2, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            boolean bl2;
            if ((n & 1) != 0) {
                bl2 = false;
                list = new ArrayList();
            }
            if ((n & 2) != 0) {
                bl2 = false;
                list2 = new ArrayList();
            }
            if ((n & 4) != 0) {
                bl2 = false;
                list3 = new ArrayList();
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                l = null;
            }
            if ((n & 0x20) != 0) {
                l2 = null;
            }
            if ((n & 0x40) != 0) {
                string = null;
            }
            this(list, list2, list3, bl, l, l2, string);
        }

        @NotNull
        public final List<VariantCheckpoint> getVariantsCheckpoints() {
            return this.variantsCheckpoints;
        }

        @NotNull
        public final List<String> getExceptions() {
            return this.exceptions;
        }

        @NotNull
        public final List<String> getBreadcrumbs() {
            return this.breadcrumbs;
        }

        public final boolean getBuildFailed() {
            return this.buildFailed;
        }

        public final void setBuildFailed(boolean bl) {
            this.buildFailed = bl;
        }

        @Nullable
        public final Long getBuildStartedTime() {
            return this.buildStartedTime;
        }

        public final void setBuildStartedTime(@Nullable Long l) {
            this.buildStartedTime = l;
        }

        @Nullable
        public final Long getBuildEndTime() {
            return this.buildEndTime;
        }

        public final void setBuildEndTime(@Nullable Long l) {
            this.buildEndTime = l;
        }

        @Nullable
        public final String getMetadataRequestId() {
            return this.metadataRequestId;
        }

        public final void setMetadataRequestId(@Nullable String string) {
            this.metadataRequestId = string;
        }

        public final void addTaskEvent(@NotNull TaskMetadata taskMetadata) {
            Intrinsics.checkNotNullParameter((Object)taskMetadata, (String)"taskMetadata");
            VariantCheckpoint variantCheckpoint = this.getVariantCheckpoint(taskMetadata.getVariant());
            VariantCheckpoint variantCheckpoint2 = variantCheckpoint == null ? this.createVariantCheckpoint(taskMetadata.getVariant(), taskMetadata.getAppId()) : variantCheckpoint;
            TaskCheckpoint taskCheckpoint = variantCheckpoint2.getTaskCheckpoint(taskMetadata.getTaskName());
            boolean bl = false;
            boolean bl2 = false;
            TaskCheckpoint $this$addTaskEvent_u24lambda_u2d0 = taskCheckpoint;
            boolean bl3 = false;
            $this$addTaskEvent_u24lambda_u2d0.setStartTime(taskMetadata.getStartTime());
            $this$addTaskEvent_u24lambda_u2d0.setEndTime(taskMetadata.getEndTime());
            $this$addTaskEvent_u24lambda_u2d0.setExecuted(taskMetadata.getMetadataResult().getDidExecute());
            $this$addTaskEvent_u24lambda_u2d0.setFinishedSuccessfully(taskMetadata.getMetadataResult().getFinishedSuccessfully());
            $this$addTaskEvent_u24lambda_u2d0.setFromCache(taskMetadata.getMetadataResult().isFromCache());
            $this$addTaskEvent_u24lambda_u2d0.setExecutionReasons(taskMetadata.getMetadataResult().getExecutionReasons());
            $this$addTaskEvent_u24lambda_u2d0.setSkippedMessage(taskMetadata.getMetadataResult().getSkippedMessage());
            $this$addTaskEvent_u24lambda_u2d0.setRegistered(true);
            $this$addTaskEvent_u24lambda_u2d0.setConfigured(true);
        }

        public final void addException(@NotNull Exception exception) {
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            this.exceptions.add(this.buildFullStacktrace(exception));
        }

        public final void addException(@NotNull VariantDescriptor variantDescriptor, @NotNull Exception exception) {
            Intrinsics.checkNotNullParameter((Object)variantDescriptor, (String)"variantDescriptor");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            boolean bl = false;
            boolean bl2 = false;
            VariantDescriptor $this$addException_u24lambda_u2d1 = variantDescriptor;
            boolean bl3 = false;
            Object object = this.getVariantCheckpoint($this$addException_u24lambda_u2d1.getVariantName());
            VariantCheckpoint variantCheckpoint = object == null ? this.createVariantCheckpoint($this$addException_u24lambda_u2d1.getVariantName(), $this$addException_u24lambda_u2d1.getAppId()) : object;
            object = variantCheckpoint.getExceptions();
            (object == null ? null : Boolean.valueOf(object.add(this.buildFullStacktrace(exception)))).booleanValue();
        }

        private final String buildFullStacktrace(Exception exception) {
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sw.toString()");
            return string;
        }

        public final void addBreadcrumb(@NotNull String breadcrumbMessage) {
            Intrinsics.checkNotNullParameter((Object)breadcrumbMessage, (String)"breadcrumbMessage");
            this.breadcrumbs.add(breadcrumbMessage);
        }

        @NotNull
        public final VariantCheckpoint createVariantCheckpoint(@NotNull String variantName, @NotNull String appId) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            VariantCheckpoint variantCheckpoint = new VariantCheckpoint(variantName, appId, null, null, 12, null);
            this.variantsCheckpoints.add(variantCheckpoint);
            return variantCheckpoint;
        }

        @VisibleForTesting
        @Nullable
        public final VariantCheckpoint getVariantCheckpoint(@NotNull String variantName) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
                Iterable iterable = this.variantsCheckpoints;
                boolean bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    VariantCheckpoint it = (VariantCheckpoint)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getVariantName(), (Object)variantName)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0;
        }

        @NotNull
        public final List<VariantCheckpoint> component1() {
            return this.variantsCheckpoints;
        }

        @NotNull
        public final List<String> component2() {
            return this.exceptions;
        }

        @NotNull
        public final List<String> component3() {
            return this.breadcrumbs;
        }

        public final boolean component4() {
            return this.buildFailed;
        }

        @Nullable
        public final Long component5() {
            return this.buildStartedTime;
        }

        @Nullable
        public final Long component6() {
            return this.buildEndTime;
        }

        @Nullable
        public final String component7() {
            return this.metadataRequestId;
        }

        @NotNull
        public final Checkpoints copy(@NotNull List<VariantCheckpoint> variantsCheckpoints, @NotNull List<String> exceptions, @NotNull List<String> breadcrumbs, boolean buildFailed, @Nullable Long buildStartedTime, @Nullable Long buildEndTime, @Nullable String metadataRequestId) {
            Intrinsics.checkNotNullParameter(variantsCheckpoints, (String)"variantsCheckpoints");
            Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
            Intrinsics.checkNotNullParameter(breadcrumbs, (String)"breadcrumbs");
            return new Checkpoints(variantsCheckpoints, exceptions, breadcrumbs, buildFailed, buildStartedTime, buildEndTime, metadataRequestId);
        }

        public static /* synthetic */ Checkpoints copy$default(Checkpoints checkpoints, List list, List list2, List list3, boolean bl, Long l, Long l2, String string, int n, Object object) {
            if ((n & 1) != 0) {
                list = checkpoints.variantsCheckpoints;
            }
            if ((n & 2) != 0) {
                list2 = checkpoints.exceptions;
            }
            if ((n & 4) != 0) {
                list3 = checkpoints.breadcrumbs;
            }
            if ((n & 8) != 0) {
                bl = checkpoints.buildFailed;
            }
            if ((n & 0x10) != 0) {
                l = checkpoints.buildStartedTime;
            }
            if ((n & 0x20) != 0) {
                l2 = checkpoints.buildEndTime;
            }
            if ((n & 0x40) != 0) {
                string = checkpoints.metadataRequestId;
            }
            return checkpoints.copy(list, list2, list3, bl, l, l2, string);
        }

        @NotNull
        public String toString() {
            return "Checkpoints(variantsCheckpoints=" + this.variantsCheckpoints + ", exceptions=" + this.exceptions + ", breadcrumbs=" + this.breadcrumbs + ", buildFailed=" + this.buildFailed + ", buildStartedTime=" + this.buildStartedTime + ", buildEndTime=" + this.buildEndTime + ", metadataRequestId=" + this.metadataRequestId + ')';
        }

        public int hashCode() {
            int result = ((Object)this.variantsCheckpoints).hashCode();
            result = result * 31 + ((Object)this.exceptions).hashCode();
            result = result * 31 + ((Object)this.breadcrumbs).hashCode();
            int n = this.buildFailed ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + (this.buildStartedTime == null ? 0 : ((Object)this.buildStartedTime).hashCode());
            result = result * 31 + (this.buildEndTime == null ? 0 : ((Object)this.buildEndTime).hashCode());
            result = result * 31 + (this.metadataRequestId == null ? 0 : this.metadataRequestId.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Checkpoints)) {
                return false;
            }
            Checkpoints checkpoints = (Checkpoints)other;
            if (!Intrinsics.areEqual(this.variantsCheckpoints, checkpoints.variantsCheckpoints)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.exceptions, checkpoints.exceptions)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.breadcrumbs, checkpoints.breadcrumbs)) {
                return false;
            }
            if (this.buildFailed != checkpoints.buildFailed) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.buildStartedTime, (Object)checkpoints.buildStartedTime)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.buildEndTime, (Object)checkpoints.buildEndTime)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.metadataRequestId, (Object)checkpoints.metadataRequestId);
        }

        public Checkpoints() {
            this(null, null, null, false, null, null, null, 127, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0003J=\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u00d6\u0003J\u000e\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\t\u0010\u001f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006 "}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$VariantCheckpoint;", "Ljava/io/Serializable;", "variantName", "", "appId", "exceptions", "", "embraceTasks", "", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$TaskCheckpoint;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/Set;)V", "getAppId", "()Ljava/lang/String;", "getEmbraceTasks", "()Ljava/util/Set;", "getExceptions", "()Ljava/util/List;", "getVariantName", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "getTaskCheckpoint", "taskName", "hashCode", "", "toString", "embrace-swazzler"})
    private static final class VariantCheckpoint
    implements Serializable {
        @NotNull
        private final String variantName;
        @NotNull
        private final String appId;
        @NotNull
        private final List<String> exceptions;
        @NotNull
        private final Set<TaskCheckpoint> embraceTasks;

        public VariantCheckpoint(@NotNull String variantName, @NotNull String appId, @NotNull List<String> exceptions, @NotNull Set<TaskCheckpoint> embraceTasks) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
            Intrinsics.checkNotNullParameter(embraceTasks, (String)"embraceTasks");
            this.variantName = variantName;
            this.appId = appId;
            this.exceptions = exceptions;
            this.embraceTasks = embraceTasks;
        }

        public /* synthetic */ VariantCheckpoint(String string, String string2, List list, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
            boolean bl;
            if ((n & 4) != 0) {
                bl = false;
                list = new ArrayList();
            }
            if ((n & 8) != 0) {
                bl = false;
                set = new LinkedHashSet();
            }
            this(string, string2, list, set);
        }

        @NotNull
        public final String getVariantName() {
            return this.variantName;
        }

        @NotNull
        public final String getAppId() {
            return this.appId;
        }

        @NotNull
        public final List<String> getExceptions() {
            return this.exceptions;
        }

        @NotNull
        public final Set<TaskCheckpoint> getEmbraceTasks() {
            return this.embraceTasks;
        }

        @NotNull
        public final TaskCheckpoint getTaskCheckpoint(@NotNull String taskName) {
            TaskCheckpoint taskCheckpoint;
            Object v0;
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
                Iterable iterable = this.embraceTasks;
                bl = false;
                Iterable iterable2 = iterable;
                boolean bl2 = false;
                for (Object t : iterable2) {
                    TaskCheckpoint it = (TaskCheckpoint)t;
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual((Object)it.getTaskName(), (Object)taskName)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            TaskCheckpoint taskCheckpoint2 = v0;
            if (taskCheckpoint2 == null) {
                boolean bl4 = false;
                bl = false;
                boolean bl5 = false;
                TaskCheckpoint taskCheckpoint3 = new TaskCheckpoint(taskName, 0L, 0L, false, false, false, false, null, null, null, 1022, null);
                this.getEmbraceTasks().add(taskCheckpoint3);
                taskCheckpoint = taskCheckpoint3;
            } else {
                taskCheckpoint = taskCheckpoint2;
            }
            return taskCheckpoint;
        }

        @NotNull
        public final String component1() {
            return this.variantName;
        }

        @NotNull
        public final String component2() {
            return this.appId;
        }

        @NotNull
        public final List<String> component3() {
            return this.exceptions;
        }

        @NotNull
        public final Set<TaskCheckpoint> component4() {
            return this.embraceTasks;
        }

        @NotNull
        public final VariantCheckpoint copy(@NotNull String variantName, @NotNull String appId, @NotNull List<String> exceptions, @NotNull Set<TaskCheckpoint> embraceTasks) {
            Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
            Intrinsics.checkNotNullParameter(embraceTasks, (String)"embraceTasks");
            return new VariantCheckpoint(variantName, appId, exceptions, embraceTasks);
        }

        public static /* synthetic */ VariantCheckpoint copy$default(VariantCheckpoint variantCheckpoint, String string, String string2, List list, Set set, int n, Object object) {
            if ((n & 1) != 0) {
                string = variantCheckpoint.variantName;
            }
            if ((n & 2) != 0) {
                string2 = variantCheckpoint.appId;
            }
            if ((n & 4) != 0) {
                list = variantCheckpoint.exceptions;
            }
            if ((n & 8) != 0) {
                set = variantCheckpoint.embraceTasks;
            }
            return variantCheckpoint.copy(string, string2, list, set);
        }

        @NotNull
        public String toString() {
            return "VariantCheckpoint(variantName=" + this.variantName + ", appId=" + this.appId + ", exceptions=" + this.exceptions + ", embraceTasks=" + this.embraceTasks + ')';
        }

        public int hashCode() {
            int result = this.variantName.hashCode();
            result = result * 31 + this.appId.hashCode();
            result = result * 31 + ((Object)this.exceptions).hashCode();
            result = result * 31 + ((Object)this.embraceTasks).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VariantCheckpoint)) {
                return false;
            }
            VariantCheckpoint variantCheckpoint = (VariantCheckpoint)other;
            if (!Intrinsics.areEqual((Object)this.variantName, (Object)variantCheckpoint.variantName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.appId, (Object)variantCheckpoint.appId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.exceptions, variantCheckpoint.exceptions)) {
                return false;
            }
            return Intrinsics.areEqual(this.embraceTasks, variantCheckpoint.embraceTasks);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b-\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001Bs\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u0012\b\b\u0002\u0010\n\u001a\u00020\b\u0012\b\b\u0002\u0010\u000b\u001a\u00020\b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\u0010J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010/\u001a\u0004\u0018\u00010\bH\u00c6\u0003\u00a2\u0006\u0002\u0010!J\t\u00100\u001a\u00020\u0005H\u00c6\u0003J\t\u00101\u001a\u00020\u0005H\u00c6\u0003J\t\u00102\u001a\u00020\bH\u00c6\u0003J\t\u00103\u001a\u00020\bH\u00c6\u0003J\t\u00104\u001a\u00020\bH\u00c6\u0003J\t\u00105\u001a\u00020\bH\u00c6\u0003J\u000b\u00106\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u00107\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eH\u00c6\u0003J~\u00108\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u0010\n\u001a\u00020\b2\b\b\u0002\u0010\u000b\u001a\u00020\b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\bH\u00c6\u0001\u00a2\u0006\u0002\u00109J\u0013\u0010:\u001a\u00020\b2\b\u0010;\u001a\u0004\u0018\u00010<H\u00d6\u0003J\t\u0010=\u001a\u00020>H\u00d6\u0001J\t\u0010?\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\t\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014R\"\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u000b\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0012\"\u0004\b \u0010\u0014R\u001e\u0010\u000f\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010$\u001a\u0004\b\u000f\u0010!\"\u0004\b\"\u0010#R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0012\"\u0004\b&\u0010\u0014R\u001c\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0016\"\u0004\b,\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010(\u00a8\u0006@"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$TaskCheckpoint;", "Ljava/io/Serializable;", "taskName", "", "startTime", "", "endTime", "registered", "", "configured", "executed", "finishedSuccessfully", "skippedMessage", "executionReasons", "", "isFromCache", "(Ljava/lang/String;JJZZZZLjava/lang/String;Ljava/util/List;Ljava/lang/Boolean;)V", "getConfigured", "()Z", "setConfigured", "(Z)V", "getEndTime", "()J", "setEndTime", "(J)V", "getExecuted", "setExecuted", "getExecutionReasons", "()Ljava/util/List;", "setExecutionReasons", "(Ljava/util/List;)V", "getFinishedSuccessfully", "setFinishedSuccessfully", "()Ljava/lang/Boolean;", "setFromCache", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getRegistered", "setRegistered", "getSkippedMessage", "()Ljava/lang/String;", "setSkippedMessage", "(Ljava/lang/String;)V", "getStartTime", "setStartTime", "getTaskName", "component1", "component10", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;JJZZZZLjava/lang/String;Ljava/util/List;Ljava/lang/Boolean;)Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints$TaskCheckpoint;", "equals", "other", "", "hashCode", "", "toString", "embrace-swazzler"})
    private static final class TaskCheckpoint
    implements Serializable {
        @NotNull
        private final String taskName;
        private long startTime;
        private long endTime;
        private boolean registered;
        private boolean configured;
        private boolean executed;
        private boolean finishedSuccessfully;
        @Nullable
        private String skippedMessage;
        @Nullable
        private List<String> executionReasons;
        @Nullable
        private Boolean isFromCache;

        public TaskCheckpoint(@NotNull String taskName, long startTime, long endTime, boolean registered, boolean configured, boolean executed, boolean finishedSuccessfully, @Nullable String skippedMessage, @Nullable List<String> executionReasons, @Nullable Boolean isFromCache) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            this.taskName = taskName;
            this.startTime = startTime;
            this.endTime = endTime;
            this.registered = registered;
            this.configured = configured;
            this.executed = executed;
            this.finishedSuccessfully = finishedSuccessfully;
            this.skippedMessage = skippedMessage;
            this.executionReasons = executionReasons;
            this.isFromCache = isFromCache;
        }

        public /* synthetic */ TaskCheckpoint(String string, long l, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2, List list, Boolean bl5, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                l = 0L;
            }
            if ((n & 4) != 0) {
                l2 = 0L;
            }
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            if ((n & 0x40) != 0) {
                bl4 = false;
            }
            if ((n & 0x80) != 0) {
                string2 = null;
            }
            if ((n & 0x100) != 0) {
                list = null;
            }
            if ((n & 0x200) != 0) {
                bl5 = null;
            }
            this(string, l, l2, bl, bl2, bl3, bl4, string2, list, bl5);
        }

        @NotNull
        public final String getTaskName() {
            return this.taskName;
        }

        public final long getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(long l) {
            this.startTime = l;
        }

        public final long getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(long l) {
            this.endTime = l;
        }

        public final boolean getRegistered() {
            return this.registered;
        }

        public final void setRegistered(boolean bl) {
            this.registered = bl;
        }

        public final boolean getConfigured() {
            return this.configured;
        }

        public final void setConfigured(boolean bl) {
            this.configured = bl;
        }

        public final boolean getExecuted() {
            return this.executed;
        }

        public final void setExecuted(boolean bl) {
            this.executed = bl;
        }

        public final boolean getFinishedSuccessfully() {
            return this.finishedSuccessfully;
        }

        public final void setFinishedSuccessfully(boolean bl) {
            this.finishedSuccessfully = bl;
        }

        @Nullable
        public final String getSkippedMessage() {
            return this.skippedMessage;
        }

        public final void setSkippedMessage(@Nullable String string) {
            this.skippedMessage = string;
        }

        @Nullable
        public final List<String> getExecutionReasons() {
            return this.executionReasons;
        }

        public final void setExecutionReasons(@Nullable List<String> list) {
            this.executionReasons = list;
        }

        @Nullable
        public final Boolean isFromCache() {
            return this.isFromCache;
        }

        public final void setFromCache(@Nullable Boolean bl) {
            this.isFromCache = bl;
        }

        @NotNull
        public final String component1() {
            return this.taskName;
        }

        public final long component2() {
            return this.startTime;
        }

        public final long component3() {
            return this.endTime;
        }

        public final boolean component4() {
            return this.registered;
        }

        public final boolean component5() {
            return this.configured;
        }

        public final boolean component6() {
            return this.executed;
        }

        public final boolean component7() {
            return this.finishedSuccessfully;
        }

        @Nullable
        public final String component8() {
            return this.skippedMessage;
        }

        @Nullable
        public final List<String> component9() {
            return this.executionReasons;
        }

        @Nullable
        public final Boolean component10() {
            return this.isFromCache;
        }

        @NotNull
        public final TaskCheckpoint copy(@NotNull String taskName, long startTime, long endTime, boolean registered, boolean configured, boolean executed, boolean finishedSuccessfully, @Nullable String skippedMessage, @Nullable List<String> executionReasons, @Nullable Boolean isFromCache) {
            Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
            return new TaskCheckpoint(taskName, startTime, endTime, registered, configured, executed, finishedSuccessfully, skippedMessage, executionReasons, isFromCache);
        }

        public static /* synthetic */ TaskCheckpoint copy$default(TaskCheckpoint taskCheckpoint, String string, long l, long l2, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string2, List list, Boolean bl5, int n, Object object) {
            if ((n & 1) != 0) {
                string = taskCheckpoint.taskName;
            }
            if ((n & 2) != 0) {
                l = taskCheckpoint.startTime;
            }
            if ((n & 4) != 0) {
                l2 = taskCheckpoint.endTime;
            }
            if ((n & 8) != 0) {
                bl = taskCheckpoint.registered;
            }
            if ((n & 0x10) != 0) {
                bl2 = taskCheckpoint.configured;
            }
            if ((n & 0x20) != 0) {
                bl3 = taskCheckpoint.executed;
            }
            if ((n & 0x40) != 0) {
                bl4 = taskCheckpoint.finishedSuccessfully;
            }
            if ((n & 0x80) != 0) {
                string2 = taskCheckpoint.skippedMessage;
            }
            if ((n & 0x100) != 0) {
                list = taskCheckpoint.executionReasons;
            }
            if ((n & 0x200) != 0) {
                bl5 = taskCheckpoint.isFromCache;
            }
            return taskCheckpoint.copy(string, l, l2, bl, bl2, bl3, bl4, string2, list, bl5);
        }

        @NotNull
        public String toString() {
            return "TaskCheckpoint(taskName=" + this.taskName + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", registered=" + this.registered + ", configured=" + this.configured + ", executed=" + this.executed + ", finishedSuccessfully=" + this.finishedSuccessfully + ", skippedMessage=" + this.skippedMessage + ", executionReasons=" + this.executionReasons + ", isFromCache=" + this.isFromCache + ')';
        }

        public int hashCode() {
            int result = this.taskName.hashCode();
            result = result * 31 + Long.hashCode(this.startTime);
            result = result * 31 + Long.hashCode(this.endTime);
            int n = this.registered ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            int n2 = this.configured ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            int n3 = this.executed ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            int n4 = this.finishedSuccessfully ? 1 : 0;
            if (n4 != 0) {
                n4 = 1;
            }
            result = result * 31 + n4;
            result = result * 31 + (this.skippedMessage == null ? 0 : this.skippedMessage.hashCode());
            result = result * 31 + (this.executionReasons == null ? 0 : ((Object)this.executionReasons).hashCode());
            result = result * 31 + (this.isFromCache == null ? 0 : ((Object)this.isFromCache).hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TaskCheckpoint)) {
                return false;
            }
            TaskCheckpoint taskCheckpoint = (TaskCheckpoint)other;
            if (!Intrinsics.areEqual((Object)this.taskName, (Object)taskCheckpoint.taskName)) {
                return false;
            }
            if (this.startTime != taskCheckpoint.startTime) {
                return false;
            }
            if (this.endTime != taskCheckpoint.endTime) {
                return false;
            }
            if (this.registered != taskCheckpoint.registered) {
                return false;
            }
            if (this.configured != taskCheckpoint.configured) {
                return false;
            }
            if (this.executed != taskCheckpoint.executed) {
                return false;
            }
            if (this.finishedSuccessfully != taskCheckpoint.finishedSuccessfully) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.skippedMessage, (Object)taskCheckpoint.skippedMessage)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.executionReasons, taskCheckpoint.executionReasons)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.isFromCache, (Object)taskCheckpoint.isFromCache);
        }
    }
}

