/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.buildreporter;

import com.google.gson.Gson;
import io.embrace.android.gradle.swazzler.network.EmbraceEndpoint;
import io.embrace.android.gradle.swazzler.network.HttpCallResult;
import io.embrace.android.gradle.swazzler.network.NetworkService;
import io.embrace.android.gradle.swazzler.network.PostJsonParams;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildData;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildDataSender;", "", "networkService", "Lio/embrace/android/gradle/swazzler/network/NetworkService;", "gson", "Lcom/google/gson/Gson;", "(Lio/embrace/android/gradle/swazzler/network/NetworkService;Lcom/google/gson/Gson;)V", "sendBuildData", "", "buildData", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildData;", "embrace-swazzler"})
public final class BuildDataSender {
    @NotNull
    private final NetworkService networkService;
    @NotNull
    private final Gson gson;

    public BuildDataSender(@NotNull NetworkService networkService, @NotNull Gson gson2) {
        Intrinsics.checkNotNullParameter((Object)networkService, (String)"networkService");
        Intrinsics.checkNotNullParameter((Object)gson2, (String)"gson");
        this.networkService = networkService;
        this.gson = gson2;
    }

    public final boolean sendBuildData(@NotNull BuildData buildData) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)buildData, (String)"buildData");
        String buildDataJson = this.gson.toJson((Object)buildData);
        Intrinsics.checkNotNullExpressionValue((Object)buildDataJson, (String)"buildDataJson");
        HttpCallResult httpCallResult = this.networkService.postJson(new PostJsonParams(EmbraceEndpoint.BUILD_DATA, null, null, buildDataJson, 6, null));
        if (httpCallResult instanceof HttpCallResult.Success) {
            bl = true;
        } else if (httpCallResult instanceof HttpCallResult.Failure) {
            bl = false;
        } else if (httpCallResult instanceof HttpCallResult.Error) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

