/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.buildreporter;

import com.google.common.annotations.VisibleForTesting;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionProviderBuildService;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildCheckpoints;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildData;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.TaskMetadata;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.TaskMetadataResult;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.VariantDescriptor;
import io.embrace.android.gradle.swazzler.util.Clock;
import io.embrace.android.gradle.swazzler.util.SystemClock;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.provider.Property;
import org.gradle.api.services.BuildService;
import org.gradle.api.services.BuildServiceParameters;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationCompletionListener;
import org.gradle.tooling.events.OperationResult;
import org.gradle.tooling.events.task.TaskExecutionResult;
import org.gradle.tooling.events.task.TaskSkippedResult;
import org.gradle.tooling.events.task.TaskSuccessResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u00042\u00020\u0005:\u0001EB\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J\b\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0016J\u0010\u00100\u001a\u00020,2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u00101\u001a\u00020,2\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u00102\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J\u0012\u00104\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*H\u0002J\b\u00105\u001a\u00020\bH\u0014J\b\u00106\u001a\u00020\u000eH\u0014J\u0010\u00107\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u00108\u001a\u00020!2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020\u0014H\u0016J\u0014\u0010;\u001a\u00020,2\n\u0010<\u001a\u00060=j\u0002`>H\u0016J\u001e\u0010;\u001a\u00020,2\b\u0010?\u001a\u0004\u0018\u00010\u00142\n\u0010<\u001a\u00060=j\u0002`>H\u0016J\u0012\u0010@\u001a\u00020,2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0010\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020CH\u0016J\b\u0010D\u001a\u00020!H\u0002R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001b\u0010\r\u001a\u00020\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\f\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00138\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0006\u001a\u0004\b\u0016\u0010\u0017R(\u0010\u0018\u001a\u0004\u0018\u00010\u00198\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0016\n\u0002\u0010\u001f\u0012\u0004\b\u001a\u0010\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010 \u001a\u00020!8\u0004@\u0004X\u0085\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\"\u0010\u0006\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006F"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildInfoReporterService;", "Lorg/gradle/api/services/BuildService;", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildInfoReporterService$Params;", "Ljava/lang/AutoCloseable;", "Lorg/gradle/tooling/events/OperationCompletionListener;", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildReporter;", "()V", "buildCheckpoints", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints;", "getBuildCheckpoints", "()Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildCheckpoints;", "buildCheckpoints$delegate", "Lkotlin/Lazy;", "clock", "Lio/embrace/android/gradle/swazzler/util/Clock;", "getClock", "()Lio/embrace/android/gradle/swazzler/util/Clock;", "clock$delegate", "embraceTasks", "", "", "getEmbraceTasks$annotations", "getEmbraceTasks", "()Ljava/util/List;", "firstTaskExecutionTime", "", "getFirstTaskExecutionTime$annotations", "getFirstTaskExecutionTime", "()Ljava/lang/Long;", "setFirstTaskExecutionTime", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "hasAnyTaskFailed", "", "getHasAnyTaskFailed$annotations", "getHasAnyTaskFailed", "()Z", "setHasAnyTaskFailed", "(Z)V", "buildEmbraceTaskMetadata", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/TaskMetadata;", "event", "Lorg/gradle/tooling/events/FinishEvent;", "close", "", "configureTask", "task", "Lorg/gradle/api/Task;", "determineFirstTaskExecution", "determineIfFailure", "handleAsmTransformTask", "handleNonTransformEmbraceTask", "handleOldTransformTask", "initializeBuildCheckpoints", "initializeClock", "isAsmTransformTask", "isOldTransformTask", "onBreadcrumb", "breadcrumb", "onException", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "variant", "onFinish", "reportBuildData", "buildData", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildData;", "shouldReportData", "Params", "embrace-swazzler"})
public abstract class BuildInfoReporterService
implements BuildService<Params>,
AutoCloseable,
OperationCompletionListener,
BuildReporter {
    @NotNull
    private final List<String> embraceTasks;
    @NotNull
    private final Lazy buildCheckpoints$delegate;
    @NotNull
    private final Lazy clock$delegate;
    private boolean hasAnyTaskFailed;
    @Nullable
    private Long firstTaskExecutionTime;

    public BuildInfoReporterService() {
        Object[] objectArray = new String[]{"injectEmbraceResources", "deobfuscationMappingCompressionTask", "deobfuscationMappingUploadTask", "cleanEmbraceProjectFor", "embraceRNSourcemapGeneratorFor", "ndkUploadTask", "cleanEmbraceSwazzlingRulesFor", "generateEmbraceSwazzlingRulesFor"};
        this.embraceTasks = CollectionsKt.listOf((Object[])objectArray);
        this.buildCheckpoints$delegate = LazyKt.lazy((Function0)((Function0)new Function0<BuildCheckpoints>(this){
            final /* synthetic */ BuildInfoReporterService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final BuildCheckpoints invoke() {
                return this.this$0.initializeBuildCheckpoints();
            }
        }));
        this.clock$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Clock>(this){
            final /* synthetic */ BuildInfoReporterService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Clock invoke() {
                return this.this$0.initializeClock();
            }
        }));
    }

    @NotNull
    public final List<String> getEmbraceTasks() {
        return this.embraceTasks;
    }

    @VisibleForTesting
    public static /* synthetic */ void getEmbraceTasks$annotations() {
    }

    private final BuildCheckpoints getBuildCheckpoints() {
        Lazy lazy = this.buildCheckpoints$delegate;
        boolean bl = false;
        return (BuildCheckpoints)lazy.getValue();
    }

    private final Clock getClock() {
        Lazy lazy = this.clock$delegate;
        boolean bl = false;
        return (Clock)lazy.getValue();
    }

    protected final boolean getHasAnyTaskFailed() {
        return this.hasAnyTaskFailed;
    }

    protected final void setHasAnyTaskFailed(boolean bl) {
        this.hasAnyTaskFailed = bl;
    }

    @VisibleForTesting
    protected static /* synthetic */ void getHasAnyTaskFailed$annotations() {
    }

    @Nullable
    protected final Long getFirstTaskExecutionTime() {
        return this.firstTaskExecutionTime;
    }

    protected final void setFirstTaskExecutionTime(@Nullable Long l) {
        this.firstTaskExecutionTime = l;
    }

    @VisibleForTesting
    protected static /* synthetic */ void getFirstTaskExecutionTime$annotations() {
    }

    @Override
    public void close() {
        if (!this.shouldReportData()) {
            return;
        }
        this.getBuildCheckpoints().onBuildFinished(this.getClock().now());
        if (((Params)this.getParameters()).getBuildStaticData().isPresent()) {
            Object object = ((Params)this.getParameters()).getBuildStaticData().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.getBuildStaticData().get()");
            BuildData buildData = (BuildData)object;
            object = ((Params)this.getParameters()).getDidGradleConfigurationPhaseRan().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.getDidGradleConfigurationPhaseRan().get()");
            BuildData staticData = BuildData.copy$default(buildData, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, (Boolean)object, false, null, null, null, null, 0x3EFFFFF, null);
            BuildData fullBuildData = this.getBuildCheckpoints().collectBuildDynamicData(staticData);
            this.reportBuildData(fullBuildData);
        }
    }

    public void onFinish(@Nullable FinishEvent event) {
        Object object = ((Params)this.getParameters()).getIsCollectBuildDataDisabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.getIsCollectBuildDataDisabled().get()");
        if (((Boolean)object).booleanValue()) {
            return;
        }
        object = event;
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object2;
            boolean bl3 = false;
            this.determineFirstTaskExecution((FinishEvent)it);
            this.determineIfFailure((FinishEvent)it);
            TaskMetadata taskMetadata = this.buildEmbraceTaskMetadata(event);
            if (taskMetadata != null) {
                TaskMetadata taskMetadata2 = taskMetadata;
                boolean bl4 = false;
                boolean bl5 = false;
                TaskMetadata taskMetadata3 = taskMetadata2;
                boolean bl6 = false;
                this.getBuildCheckpoints().onTaskEvent(taskMetadata3);
            }
        }
    }

    @Override
    public void configureTask(@NotNull Task task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
    }

    @Override
    public void onException(@NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        this.getBuildCheckpoints().onException(exception);
    }

    @Override
    public void onException(@Nullable String variant, @NotNull Exception exception) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        VariantDescriptor variantDescriptor = variant == null ? (VariantDescriptor)null : new VariantDescriptor(variant, ((BuildData)((Params)this.getParameters()).getBuildStaticData().get()).getAppIdFor(variant));
        this.getBuildCheckpoints().onException(variantDescriptor, exception);
    }

    @Override
    public void onBreadcrumb(@NotNull String breadcrumb) {
        Intrinsics.checkNotNullParameter((Object)breadcrumb, (String)"breadcrumb");
        this.getBuildCheckpoints().onBreadcrumb(breadcrumb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldReportData() {
        if ((Boolean)((Params)this.getParameters()).getIsCollectBuildDataDisabled().get() == false) return true;
        Collection collection = this.getBuildCheckpoints().getExceptions();
        boolean bl = false;
        boolean bl2 = false;
        if (collection == null) return false;
        if (!collection.isEmpty()) return true;
        return false;
    }

    private final TaskMetadata buildEmbraceTaskMetadata(FinishEvent event) {
        TaskMetadata taskMetadata = this.handleAsmTransformTask(event);
        if (taskMetadata == null) {
            taskMetadata = this.handleOldTransformTask(event);
        }
        if (taskMetadata == null) {
            taskMetadata = this.handleNonTransformEmbraceTask(event);
        }
        return taskMetadata;
    }

    private final TaskMetadata handleNonTransformEmbraceTask(FinishEvent event) {
        TaskMetadata taskMetadata;
        Object v0;
        boolean bl;
        Object object;
        block3: {
            object = this.embraceTasks;
            bl = false;
            Iterable iterable = object;
            boolean bl2 = false;
            for (Object object2 : iterable) {
                String it = (String)object2;
                boolean bl3 = false;
                String string = event.getDescriptor().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.descriptor.name");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                v0 = object2;
                break block3;
            }
            v0 = null;
        }
        String string = v0;
        if (string == null) {
            taskMetadata = null;
        } else {
            Object object2;
            object = string;
            bl = false;
            boolean bl4 = false;
            Object embraceTaskName = object;
            boolean bl5 = false;
            object2 = event.getDescriptor().getName();
            Intrinsics.checkNotNullExpressionValue(object2, (String)"event.descriptor.name");
            String variant = StringsKt.substringAfter$default(object2, (String)embraceTaskName, null, (int)2, null);
            taskMetadata = new TaskMetadata((String)embraceTaskName, variant, ((BuildData)((Params)this.getParameters()).getBuildStaticData().get()).getAppIdFor(variant), event.getResult().getStartTime(), event.getResult().getEndTime(), TaskMetadataResult.Companion.build(event));
        }
        return taskMetadata;
    }

    private final TaskMetadata handleOldTransformTask(FinishEvent event) {
        if (this.isOldTransformTask(event)) {
            String string = event.getDescriptor().getName();
            boolean bl = false;
            boolean bl2 = false;
            String $this$handleOldTransformTask_u24lambda_u2d4 = string;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$handleOldTransformTask_u24lambda_u2d4, (String)"");
            int lastIndexTransform = StringsKt.lastIndexOf$default((CharSequence)$this$handleOldTransformTask_u24lambda_u2d4, (String)"transformClassesWithswazzleFor", (int)0, (boolean)true, (int)2, null);
            String string2 = $this$handleOldTransformTask_u24lambda_u2d4;
            int n = lastIndexTransform + "transformClassesWithswazzleFor".length();
            boolean bl4 = false;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String variant = string3;
            return new TaskMetadata($this$handleOldTransformTask_u24lambda_u2d4, variant, ((BuildData)((Params)this.getParameters()).getBuildStaticData().get()).getAppIdFor(variant), event.getResult().getStartTime(), event.getResult().getEndTime(), TaskMetadataResult.Companion.build(event));
        }
        return null;
    }

    private final TaskMetadata handleAsmTransformTask(FinishEvent event) {
        if (this.isAsmTransformTask(event)) {
            String string = event.getDescriptor().getName();
            boolean bl = false;
            boolean bl2 = false;
            String $this$handleAsmTransformTask_u24lambda_u2d5 = string;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$handleAsmTransformTask_u24lambda_u2d5, (String)"");
            String string2 = $this$handleAsmTransformTask_u24lambda_u2d5;
            int n = StringsKt.lastIndexOf$default((CharSequence)$this$handleAsmTransformTask_u24lambda_u2d5, (String)"transform", (int)0, (boolean)false, (int)6, null) + "transform".length();
            int n2 = StringsKt.lastIndexOf$default((CharSequence)$this$handleAsmTransformTask_u24lambda_u2d5, (String)"ClassesWithAsm", (int)0, (boolean)false, (int)6, null);
            boolean bl4 = false;
            String string3 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String variant = string3;
            return new TaskMetadata($this$handleAsmTransformTask_u24lambda_u2d5, variant, ((BuildData)((Params)this.getParameters()).getBuildStaticData().get()).getAppIdFor(variant), event.getResult().getStartTime(), event.getResult().getEndTime(), TaskMetadataResult.Companion.build(event));
        }
        return null;
    }

    private final boolean isOldTransformTask(FinishEvent event) {
        String string = event.getDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.descriptor.name");
        return StringsKt.contains((CharSequence)string, (CharSequence)"transformClassesWithswazzleFor", (boolean)true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAsmTransformTask(FinishEvent event) {
        String string = event.getDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.descriptor.name");
        if (!StringsKt.contains((CharSequence)string, (CharSequence)"transform", (boolean)true)) return false;
        string = event.getDescriptor().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"event.descriptor.name");
        if (!StringsKt.endsWith((String)string, (String)"ClassesWithAsm", (boolean)true)) return false;
        return true;
    }

    @NotNull
    protected BuildCheckpoints initializeBuildCheckpoints() {
        Object object = ((Params)this.getParameters()).getIsCollectBuildDataDisabled().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.getIsCollectBuildDataDisabled().get()");
        boolean bl = (Boolean)object;
        object = ((Params)this.getParameters()).getIsTesting().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.getIsTesting().get()");
        return new BuildCheckpoints(bl, (Boolean)object, null, 4, null);
    }

    @NotNull
    protected Clock initializeClock() {
        return new SystemClock();
    }

    @Override
    public void reportBuildData(@NotNull BuildData buildData) {
        Intrinsics.checkNotNullParameter((Object)buildData, (String)"buildData");
        ((DependencyInjectionProviderBuildService)((Params)this.getParameters()).getDependencyInjectionProvider().get()).getBuildDataSender().sendBuildData(buildData);
    }

    /*
     * WARNING - void declaration
     */
    private final void determineIfFailure(FinishEvent event) {
        if (!this.hasAnyTaskFailed) {
            boolean bl;
            void $this$determineIfFailure_u24lambda_u2d6;
            OperationResult operationResult = event.getResult();
            boolean bl2 = false;
            boolean bl3 = false;
            OperationResult operationResult2 = operationResult;
            BuildInfoReporterService buildInfoReporterService = this;
            boolean bl4 = false;
            if (!($this$determineIfFailure_u24lambda_u2d6 instanceof TaskSkippedResult || $this$determineIfFailure_u24lambda_u2d6 instanceof TaskExecutionResult && $this$determineIfFailure_u24lambda_u2d6 instanceof TaskSuccessResult)) {
                this.getBuildCheckpoints().onTaskFailed();
                bl = true;
            } else {
                bl = false;
            }
            boolean bl5 = bl;
            buildInfoReporterService.hasAnyTaskFailed = bl5;
        }
    }

    private final void determineFirstTaskExecution(FinishEvent event) {
        if (this.firstTaskExecutionTime == null) {
            long l = this.getClock().now();
            boolean bl = false;
            boolean bl2 = false;
            long $this$determineFirstTaskExecution_u24lambda_u2d7 = l;
            boolean bl3 = false;
            this.setFirstTaskExecutionTime($this$determineFirstTaskExecution_u24lambda_u2d7);
            this.getBuildCheckpoints().onFirstTaskStartedExecution($this$determineFirstTaskExecution_u24lambda_u2d7);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u000e\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H&J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003H&J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H&J\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H&J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H&\u00a8\u0006\u000b"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildInfoReporterService$Params;", "Lorg/gradle/api/services/BuildServiceParameters;", "getBuildStaticData", "Lorg/gradle/api/provider/Property;", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildData;", "getDependencyInjectionProvider", "Lio/embrace/android/gradle/swazzler/di/DependencyInjectionProviderBuildService;", "getDidGradleConfigurationPhaseRan", "", "getIsCollectBuildDataDisabled", "getIsTesting", "embrace-swazzler"})
    public static interface Params
    extends BuildServiceParameters {
        @NotNull
        public Property<BuildData> getBuildStaticData();

        @NotNull
        public Property<Boolean> getIsCollectBuildDataDisabled();

        @NotNull
        public Property<Boolean> getIsTesting();

        @NotNull
        public Property<DependencyInjectionProviderBuildService> getDependencyInjectionProvider();

        @NotNull
        public Property<Boolean> getDidGradleConfigurationPhaseRan();
    }
}

