/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.configuration;

import com.android.build.gradle.AppExtension;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.Config;
import io.embrace.android.gradle.swazzler.config.VariantConfiguration;
import io.embrace.android.gradle.swazzler.config.variant.VariantConfigurationBuilder;
import io.embrace.android.gradle.swazzler.plugin.ProjectPropertiesKt;
import io.embrace.android.gradle.swazzler.plugin.buildid.BuildIdProvider;
import io.embrace.android.gradle.swazzler.plugin.configuration.TasksConfigurator;
import io.embrace.android.gradle.swazzler.plugin.deobfuscation.DeobfuscationArtifactUploadTaskRegistration;
import io.embrace.android.gradle.swazzler.plugin.deobfuscation.DeobfuscationNativeTaskFetcher;
import io.embrace.android.gradle.swazzler.plugin.extension.EmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.BuildIdToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.ConfigToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.VariantConfigurationToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.VariantDataToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.utils.VariantSmartConfigurationToEmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.il2cpp.Il2CppUploadTaskRegistration;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.plugin.ndk.NdkUploadTask;
import io.embrace.android.gradle.swazzler.plugin.ndk.NdkUploadTaskRegistration;
import io.embrace.android.gradle.swazzler.plugin.resourcesinjection.ResourceInjectionTask;
import io.embrace.android.gradle.swazzler.plugin.resourcesinjection.ResourcesInjectionRegistration;
import io.embrace.android.gradle.swazzler.testcheckpoints.SwazzlerTestCheckPoints;
import io.embrace.android.gradle.swazzler.testcheckpoints.TestCheckpointsExtension;
import io.embrace.android.gradle.swazzler.util.GradleCompatibilityHelper;
import io.embrace.android.gradle.swazzler.util.ReactNativeUtils;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJL\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\r0\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010%\u001a\u00020!2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\u0006\u0010)\u001a\u00020#H$J\u0010\u0010*\u001a\u00020!2\u0006\u0010)\u001a\u00020#H$J\u001e\u0010+\u001a\u00020!2\u0006\u0010)\u001a\u00020#2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0'H$J\b\u0010.\u001a\u00020!H&J&\u0010/\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001000\u00052\u0006\u0010)\u001a\u00020#2\f\u00101\u001a\b\u0012\u0004\u0012\u0002020'H\u0016J\u0010\u00103\u001a\u00020!2\u0006\u0010)\u001a\u00020#H\u0004J\u0010\u00104\u001a\u00020!2\u0006\u0010)\u001a\u00020#H\u0002J\u0010\u00105\u001a\u00020!2\u0006\u0010)\u001a\u00020#H\u0002J\u0010\u00106\u001a\u00020!2\u0006\u0010)\u001a\u00020#H\u0002J\u0010\u00107\u001a\u00020!2\u0006\u0010)\u001a\u00020#H\u0002J\u0010\u00108\u001a\u00020!2\u0006\u0010)\u001a\u00020#H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0015\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00000\u0000 \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/configuration/TasksConfigurator;", "", "project", "Lorg/gradle/api/Project;", "buildIdProvider", "Lorg/gradle/api/provider/Provider;", "Lio/embrace/android/gradle/swazzler/plugin/buildid/BuildIdProvider;", "variantConfigurationBuilder", "Lio/embrace/android/gradle/swazzler/config/variant/VariantConfigurationBuilder;", "config", "Lio/embrace/android/gradle/swazzler/config/Config;", "variantConfigurationsListProperty", "Lorg/gradle/api/provider/ListProperty;", "Lio/embrace/android/gradle/swazzler/config/VariantConfiguration;", "(Lorg/gradle/api/Project;Lorg/gradle/api/provider/Provider;Lio/embrace/android/gradle/swazzler/config/variant/VariantConfigurationBuilder;Lio/embrace/android/gradle/swazzler/config/Config;Lorg/gradle/api/provider/ListProperty;)V", "androidExtension", "Lcom/android/build/gradle/AppExtension;", "embraceExtensionInternal", "Lio/embrace/android/gradle/swazzler/plugin/extension/EmbraceExtensionInternal;", "il2cppTaskRegistration", "Lio/embrace/android/gradle/swazzler/plugin/il2cpp/Il2CppUploadTaskRegistration;", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "ndkUploadTaskRegistration", "Lio/embrace/android/gradle/swazzler/plugin/ndk/NdkUploadTaskRegistration;", "resourcesInjectionRegistration", "Lio/embrace/android/gradle/swazzler/plugin/resourcesinjection/ResourcesInjectionRegistration;", "swazzlerExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;", "testCheckpointsExtension", "Lio/embrace/android/gradle/swazzler/testcheckpoints/TestCheckpointsExtension;", "configureEmbraceExtensionInternalForVariant", "", "variantInfo", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "variantConfigurationProvider", "configureNdkUploadTask", "ndkUploadTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lio/embrace/android/gradle/swazzler/plugin/ndk/NdkUploadTask;", "variant", "configureRNSourcemapGeneratorTask", "configureResourceInjectionTask", "resourceInjectionTask", "Lio/embrace/android/gradle/swazzler/plugin/resourcesinjection/ResourceInjectionTask;", "configureTasks", "fetchDeobfuscationMappingFile", "Ljava/io/File;", "nativeObfuscationTask", "Lorg/gradle/api/Task;", "onVariant", "registerDeobfuscationUploadTask", "registerIl2cppUploadTask", "registerNdkUploadTask", "registerRNTask", "registerResourceInjectionTask", "embrace-swazzler"})
public abstract class TasksConfigurator {
    @NotNull
    private final Project project;
    @NotNull
    private final Provider<BuildIdProvider> buildIdProvider;
    @NotNull
    private final VariantConfigurationBuilder variantConfigurationBuilder;
    @NotNull
    private final Config config;
    @NotNull
    private final ListProperty<VariantConfiguration> variantConfigurationsListProperty;
    private final Logger<TasksConfigurator> logger;
    @NotNull
    private final AppExtension androidExtension;
    @NotNull
    private final SwazzlerExtension swazzlerExtension;
    @NotNull
    private final EmbraceExtensionInternal embraceExtensionInternal;
    @NotNull
    private final TestCheckpointsExtension testCheckpointsExtension;
    @NotNull
    private final ResourcesInjectionRegistration resourcesInjectionRegistration;
    @NotNull
    private final Il2CppUploadTaskRegistration il2cppTaskRegistration;
    @NotNull
    private final NdkUploadTaskRegistration ndkUploadTaskRegistration;

    public TasksConfigurator(@NotNull Project project, @NotNull Provider<BuildIdProvider> buildIdProvider, @NotNull VariantConfigurationBuilder variantConfigurationBuilder, @NotNull Config config, @NotNull ListProperty<VariantConfiguration> variantConfigurationsListProperty) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(buildIdProvider, (String)"buildIdProvider");
        Intrinsics.checkNotNullParameter((Object)variantConfigurationBuilder, (String)"variantConfigurationBuilder");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(variantConfigurationsListProperty, (String)"variantConfigurationsListProperty");
        this.project = project;
        this.buildIdProvider = buildIdProvider;
        this.variantConfigurationBuilder = variantConfigurationBuilder;
        this.config = config;
        this.variantConfigurationsListProperty = variantConfigurationsListProperty;
        this.logger = Logger.newLogger(TasksConfigurator.class);
        Object object = this.project.getProperties().get("android");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.android.build.gradle.AppExtension");
        }
        object = (AppExtension)object;
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        this.androidExtension = object;
        object = this.project.getExtensions().findByType(SwazzlerExtension.class);
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (object == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.swazzlerExtension = (SwazzlerExtension)object;
        object = this.project.getExtensions().findByType(EmbraceExtensionInternal.class);
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (object == null) {
            boolean bl5 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.embraceExtensionInternal = (EmbraceExtensionInternal)object;
        object = this.project.getExtensions().findByType(TestCheckpointsExtension.class);
        bl = false;
        bl2 = false;
        bl2 = false;
        bl3 = false;
        if (object == null) {
            boolean bl6 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.testCheckpointsExtension = (TestCheckpointsExtension)object;
        this.resourcesInjectionRegistration = new ResourcesInjectionRegistration(this.project);
        this.il2cppTaskRegistration = new Il2CppUploadTaskRegistration(this.project, this.embraceExtensionInternal, null, 4, null);
        object = this.testCheckpointsExtension.getTestCheckpoints().get();
        Intrinsics.checkNotNullExpressionValue(object, (String)"testCheckpointsExtension.testCheckpoints.get()");
        this.ndkUploadTaskRegistration = new NdkUploadTaskRegistration(this.project, (SwazzlerTestCheckPoints)object);
    }

    public abstract void configureTasks();

    protected abstract void configureResourceInjectionTask(@NotNull AndroidCompactedVariantData var1, @NotNull TaskProvider<ResourceInjectionTask> var2);

    protected abstract void configureRNSourcemapGeneratorTask(@NotNull AndroidCompactedVariantData var1);

    protected abstract void configureNdkUploadTask(@NotNull TaskProvider<NdkUploadTask> var1, @NotNull AndroidCompactedVariantData var2);

    @NotNull
    public Provider<File> fetchDeobfuscationMappingFile(@NotNull AndroidCompactedVariantData variant, @NotNull TaskProvider<Task> nativeObfuscationTask) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter(nativeObfuscationTask, (String)"nativeObfuscationTask");
        Provider provider = nativeObfuscationTask.flatMap((Transformer)new Transformer<Provider<File>, Task>(){

            @NotNull
            public Provider<File> transform(@NotNull Task taskToTransform) {
                Intrinsics.checkNotNullParameter((Object)taskToTransform, (String)"taskToTransform");
                Provider provider = taskToTransform.getOutputs().getFiles().getAsFileTree().filter(fetchDeobfuscationMappingFile.1::transform$lambda-0).getElements().map((Transformer)new Transformer<File, Set<? extends FileSystemLocation>>(){

                    @Nullable
                    public File transform(@NotNull Set<? extends FileSystemLocation> filesSystemLocationToTransform) {
                        Intrinsics.checkNotNullParameter(filesSystemLocationToTransform, (String)"filesSystemLocationToTransform");
                        FileSystemLocation fileSystemLocation = (FileSystemLocation)CollectionsKt.firstOrNull((Iterable)filesSystemLocationToTransform);
                        return fileSystemLocation == null ? null : fileSystemLocation.getAsFile();
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"taskToTransform.outputs.files.asFileTree.filter {\n                        it.name == \"mapping.txt\"\n                    }.elements.map(\n                        // do not convert this to lambda otherwise Gradle will fail to restore configuration cache\n                        object : Transformer<File?, Set<FileSystemLocation>> {\n                            override fun transform(filesSystemLocationToTransform: Set<FileSystemLocation>): File? {\n                                return filesSystemLocationToTransform.firstOrNull()?.asFile\n                            }\n                        }\n                    )");
                return provider;
            }

            private static final boolean transform$lambda-0(File it) {
                return Intrinsics.areEqual((Object)it.getName(), (Object)"mapping.txt");
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"nativeObfuscationTask.flatMap(\n            // do not convert this to lambda otherwise Gradle will fail to restore configuration cache\n            object : Transformer<Provider<File>, Task> {\n                override fun transform(taskToTransform: Task): Provider<File> {\n                    return taskToTransform.outputs.files.asFileTree.filter {\n                        it.name == \"mapping.txt\"\n                    }.elements.map(\n                        // do not convert this to lambda otherwise Gradle will fail to restore configuration cache\n                        object : Transformer<File?, Set<FileSystemLocation>> {\n                            override fun transform(filesSystemLocationToTransform: Set<FileSystemLocation>): File? {\n                                return filesSystemLocationToTransform.firstOrNull()?.asFile\n                            }\n                        }\n                    )\n                }\n            }\n        )");
        return provider;
    }

    protected final void onVariant(@NotNull AndroidCompactedVariantData variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.logger.info(Intrinsics.stringPlus((String)"Configuring variant=", (Object)variant.getName()));
        this.logger.debug(Intrinsics.stringPlus((String)"Adding buildId for variant=", (Object)variant.getName()));
        ((BuildIdProvider)this.buildIdProvider.get()).addBuildIdFor(variant.getName());
        Provider<VariantConfiguration> variantConfiguration = this.variantConfigurationBuilder.buildVariantConfiguration(variant);
        this.configureEmbraceExtensionInternalForVariant(variant, variantConfiguration, this.buildIdProvider, this.config, this.androidExtension, this.project, this.swazzlerExtension);
        GradleCompatibilityHelper.INSTANCE.add((HasMultipleValues)this.variantConfigurationsListProperty, variantConfiguration);
        this.logger.debug(Intrinsics.stringPlus((String)"About to register resource injection task for variant=", (Object)variant.getName()));
        this.registerResourceInjectionTask(variant);
        if (ProjectPropertiesKt.isUploadMappingFilesDisabled(this.project)) {
            this.logger.info("embrace.disableMappingFileUpload was set to true - skipping registration of upload tasks.");
            return;
        }
        this.logger.debug(Intrinsics.stringPlus((String)"About to register deobfuscation task for variant=", (Object)variant.getName()));
        this.registerDeobfuscationUploadTask(variant);
        this.logger.debug(Intrinsics.stringPlus((String)"About to register react native sourcemap generator task for variant=", (Object)variant.getName()));
        this.registerRNTask(variant);
        this.logger.debug(Intrinsics.stringPlus((String)"About to register Ndk upload task for variant=", (Object)variant.getName()));
        this.registerNdkUploadTask(variant);
        this.logger.debug(Intrinsics.stringPlus((String)"About to register IL2cpp task for variant=", (Object)variant.getName()));
        this.registerIl2cppUploadTask(variant);
        this.logger.info(Intrinsics.stringPlus((String)"Successfully configured variant=", (Object)variant.getName()));
    }

    private final void registerRNTask(AndroidCompactedVariantData variant) {
        ProjectLayout projectLayout = this.project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        if (ReactNativeUtils.INSTANCE.isReactNative(projectLayout)) {
            this.logger.info("This is a RN project. Will register embrace RN tasks");
            this.configureRNSourcemapGeneratorTask(variant);
        } else {
            this.logger.info("Not a RN project");
        }
    }

    private final void registerResourceInjectionTask(AndroidCompactedVariantData variant) {
        TaskProvider<ResourceInjectionTask> taskProvider = this.resourcesInjectionRegistration.register(variant);
        if (taskProvider != null) {
            TaskProvider<ResourceInjectionTask> taskProvider2 = taskProvider;
            boolean bl = false;
            boolean bl2 = false;
            TaskProvider<ResourceInjectionTask> task = taskProvider2;
            boolean bl3 = false;
            this.configureResourceInjectionTask(variant, task);
        }
    }

    private final void configureEmbraceExtensionInternalForVariant(AndroidCompactedVariantData variantInfo, Provider<VariantConfiguration> variantConfigurationProvider, Provider<BuildIdProvider> buildIdProvider, Config config, AppExtension androidExtension, Project project, SwazzlerExtension swazzlerExtension) {
        ExtensionContainer extensionContainer = project.getExtensions();
        boolean bl = false;
        boolean bl2 = false;
        ExtensionContainer $this$configureEmbraceExtensionInternalForVariant_u24lambda_u2d1 = extensionContainer;
        boolean bl3 = false;
        String string = variantInfo.getName();
        ObjectFactory objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ObjectFactory objectFactory2 = objectFactory;
        objectFactory = project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.providers");
        $this$configureEmbraceExtensionInternalForVariant_u24lambda_u2d1.configure(EmbraceExtensionInternal.class, (Action)new VariantConfigurationToEmbraceExtensionInternal(string, variantConfigurationProvider, objectFactory2, (ProviderFactory)objectFactory));
        String string2 = variantInfo.getName();
        objectFactory = project.getLayout().getBuildDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.layout.buildDirectory");
        Provider provider = (Provider)objectFactory;
        objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        $this$configureEmbraceExtensionInternalForVariant_u24lambda_u2d1.configure(EmbraceExtensionInternal.class, (Action)new VariantDataToEmbraceExtensionInternal(string2, variantInfo, (Provider<Directory>)provider, objectFactory));
        String string3 = variantInfo.getName();
        objectFactory = project.getObjects();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.objects");
        ObjectFactory objectFactory3 = objectFactory;
        objectFactory = project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)objectFactory, (String)"project.providers");
        $this$configureEmbraceExtensionInternalForVariant_u24lambda_u2d1.configure(EmbraceExtensionInternal.class, (Action)new BuildIdToEmbraceExtensionInternal(string3, buildIdProvider, objectFactory3, (ProviderFactory)objectFactory));
        $this$configureEmbraceExtensionInternalForVariant_u24lambda_u2d1.configure(EmbraceExtensionInternal.class, (Action)new ConfigToEmbraceExtensionInternal(config));
        $this$configureEmbraceExtensionInternalForVariant_u24lambda_u2d1.configure(EmbraceExtensionInternal.class, (Action)new VariantSmartConfigurationToEmbraceExtensionInternal(variantConfigurationProvider, variantInfo, androidExtension, project, swazzlerExtension));
    }

    private final void registerIl2cppUploadTask(AndroidCompactedVariantData variant) {
        this.il2cppTaskRegistration.register(variant);
    }

    private final void registerDeobfuscationUploadTask(AndroidCompactedVariantData variant) {
        this.project.afterEvaluate(arg_0 -> TasksConfigurator.registerDeobfuscationUploadTask$lambda-2(this, variant, arg_0));
    }

    private final void registerNdkUploadTask(AndroidCompactedVariantData variant) {
        TaskProvider<NdkUploadTask> ndkUploadTask = this.ndkUploadTaskRegistration.execute(variant);
        this.configureNdkUploadTask(ndkUploadTask, variant);
    }

    private static final void registerDeobfuscationUploadTask$lambda-2(TasksConfigurator this$0, AndroidCompactedVariantData $variant, Project it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        DeobfuscationNativeTaskFetcher deobfuscationNativeTaskFetcher = new DeobfuscationNativeTaskFetcher(this$0.project);
        TaskProvider<Task> nativeObfuscationTask = deobfuscationNativeTaskFetcher.fetchNativeTask($variant);
        if (nativeObfuscationTask != null) {
            this$0.logger.debug(Intrinsics.stringPlus((String)"Native obfuscation task found. Task=", (Object)nativeObfuscationTask.getName()));
            DeobfuscationArtifactUploadTaskRegistration deobfuscationArtifactUploadTaskRegistration = new DeobfuscationArtifactUploadTaskRegistration(this$0.project, null, nativeObfuscationTask, this$0.fetchDeobfuscationMappingFile($variant, nativeObfuscationTask), 2, null);
            deobfuscationArtifactUploadTaskRegistration.register($variant);
            this$0.logger.info("Successfully registered embrace deobfuscation task.");
        } else {
            this$0.logger.debug("Missing dependent obfuscation task(s). Skipping registration of embrace deobfuscation taskGradle task for variant=" + $variant.getName() + '.');
        }
    }
}

