/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.configuration;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.Config;
import io.embrace.android.gradle.swazzler.config.VariantConfiguration;
import io.embrace.android.gradle.swazzler.config.variant.VariantConfigurationBuilder;
import io.embrace.android.gradle.swazzler.plugin.buildid.BuildIdProvider;
import io.embrace.android.gradle.swazzler.plugin.configuration.TasksConfigurator;
import io.embrace.android.gradle.swazzler.plugin.configuration.newvariantapi.NewVariantApiTasksConfigurator;
import io.embrace.android.gradle.swazzler.plugin.configuration.oldvariantapi.OldVariantApiTasksConfigurator;
import io.embrace.android.gradle.swazzler.util.AgpVersion;
import io.embrace.android.gradle.swazzler.util.ReactNativeUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00000\u0000 \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/configuration/TasksConfiguratorFactory;", "", "project", "Lorg/gradle/api/Project;", "buildIdProvider", "Lorg/gradle/api/provider/Provider;", "Lio/embrace/android/gradle/swazzler/plugin/buildid/BuildIdProvider;", "variantConfigurationBuilder", "Lio/embrace/android/gradle/swazzler/config/variant/VariantConfigurationBuilder;", "config", "Lio/embrace/android/gradle/swazzler/config/Config;", "variantConfigurationsListProperty", "Lorg/gradle/api/provider/ListProperty;", "Lio/embrace/android/gradle/swazzler/config/VariantConfiguration;", "(Lorg/gradle/api/Project;Lorg/gradle/api/provider/Provider;Lio/embrace/android/gradle/swazzler/config/variant/VariantConfigurationBuilder;Lio/embrace/android/gradle/swazzler/config/Config;Lorg/gradle/api/provider/ListProperty;)V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "buildTaskConfigurator", "Lio/embrace/android/gradle/swazzler/plugin/configuration/TasksConfigurator;", "hasNewVariant", "", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "embrace-swazzler"})
public final class TasksConfiguratorFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final Provider<BuildIdProvider> buildIdProvider;
    @NotNull
    private final VariantConfigurationBuilder variantConfigurationBuilder;
    @NotNull
    private final Config config;
    @NotNull
    private final ListProperty<VariantConfiguration> variantConfigurationsListProperty;
    private final Logger<TasksConfiguratorFactory> logger;

    public TasksConfiguratorFactory(@NotNull Project project, @NotNull Provider<BuildIdProvider> buildIdProvider, @NotNull VariantConfigurationBuilder variantConfigurationBuilder, @NotNull Config config, @NotNull ListProperty<VariantConfiguration> variantConfigurationsListProperty) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(buildIdProvider, (String)"buildIdProvider");
        Intrinsics.checkNotNullParameter((Object)variantConfigurationBuilder, (String)"variantConfigurationBuilder");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter(variantConfigurationsListProperty, (String)"variantConfigurationsListProperty");
        this.project = project;
        this.buildIdProvider = buildIdProvider;
        this.variantConfigurationBuilder = variantConfigurationBuilder;
        this.config = config;
        this.variantConfigurationsListProperty = variantConfigurationsListProperty;
        this.logger = Logger.newLogger(TasksConfiguratorFactory.class);
    }

    @NotNull
    public final TasksConfigurator buildTaskConfigurator() {
        TasksConfigurator tasksConfigurator;
        ProjectLayout projectLayout = this.project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        if (this.hasNewVariant(projectLayout)) {
            this.logger.info("Using new variant api");
            tasksConfigurator = new NewVariantApiTasksConfigurator(this.project, this.buildIdProvider, this.variantConfigurationBuilder, this.config, this.variantConfigurationsListProperty);
        } else {
            this.logger.info("Using old variant api since it doesn't exist or it's unstable");
            tasksConfigurator = new OldVariantApiTasksConfigurator(this.project, this.buildIdProvider, this.variantConfigurationBuilder, this.config, this.variantConfigurationsListProperty);
        }
        return tasksConfigurator;
    }

    private final boolean hasNewVariant(ProjectLayout projectLayout) {
        if (ReactNativeUtils.INSTANCE.isReactNative(projectLayout)) {
            return ReactNativeUtils.INSTANCE.isReactNativeWithNewVariant(this.project);
        }
        return AgpVersion.Companion.isAtLeast(AgpVersion.AGP_7_4_1.INSTANCE);
    }
}

