/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.deobfuscation;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.TaskRegistrationUtilsKt;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eR2\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00000\u0000 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000f"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/deobfuscation/DeobfuscationNativeTaskFetcher;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "getProject", "()Lorg/gradle/api/Project;", "fetchNativeTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "variant", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "embrace-swazzler"})
public final class DeobfuscationNativeTaskFetcher {
    @NotNull
    private final Project project;
    private final Logger<DeobfuscationNativeTaskFetcher> logger;

    public DeobfuscationNativeTaskFetcher(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.logger = Logger.newLogger(DeobfuscationNativeTaskFetcher.class);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final TaskProvider<Task> fetchNativeTask(@NotNull AndroidCompactedVariantData variant) {
        Object v0;
        Project $this$fetchNativeTask_u24lambda_u2d1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            String variantCapitalized = StringUtils.capitalize((String)variant.getName());
            this.logger.debug(Intrinsics.stringPlus((String)"Will search for native obfuscation task for variant=", (Object)variantCapitalized));
            Project project = this.project;
            boolean bl = false;
            boolean bl2 = false;
            $this$fetchNativeTask_u24lambda_u2d1 = project;
            boolean bl3 = false;
            Object[] objectArray = new String[]{Intrinsics.stringPlus((String)"dexguardApk", (Object)variantCapitalized), Intrinsics.stringPlus((String)"dexguardAab", (Object)variantCapitalized), Intrinsics.stringPlus((String)"transformClassesAndResourcesWithProguardFor", (Object)variantCapitalized), "minify" + variantCapitalized + "WithProguard", Intrinsics.stringPlus((String)"transformClassesAndResourcesWithR8For", (Object)variantCapitalized), "minify" + variantCapitalized + "WithR8"};
            List targetNativeTasks = CollectionsKt.listOf((Object[])objectArray);
            Iterable $this$firstOrNull$iv = targetNativeTasks;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String taskName = (String)element$iv;
                boolean bl4 = false;
                if (!TaskRegistrationUtilsKt.isTaskRegistered(TaskRegistrationUtilsKt.tryGetTaskProvider($this$fetchNativeTask_u24lambda_u2d1, taskName))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        String nativeTask = v0;
        if (nativeTask == null) {
            $this$fetchNativeTask_u24lambda_u2d1.getLogger().info("No native obfuscation task was found");
            return null;
        }
        $this$fetchNativeTask_u24lambda_u2d1.getLogger().info(Intrinsics.stringPlus((String)nativeTask, (Object)" was found"));
        return TaskRegistrationUtilsKt.tryGetTaskProvider($this$fetchNativeTask_u24lambda_u2d1, nativeTask);
    }
}

