/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.extension;

import com.google.common.annotations.VisibleForTesting;
import io.embrace.android.gradle.swazzler.plugin.extension.ExtensionException;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;

public class SwazzlerExtension {
    private static final Boolean DEFAULT_FORCE_INCREMENTAL_OVERWRITE = false;
    private static final Boolean DEFAULT_FORCE_OKHTTP_INJECTION = false;
    private static final Boolean DEFAULT_DISABLE_DEPENDENCY_INJECTION = false;
    private static final Boolean DEFAULT_DISABLE_COMPOSE_DEPENDENCY_INJECTION = true;
    private static final Boolean DEFAULT_DISABLE_RN_BUNDLE_RETRIEVER = false;
    private static final Boolean DEFAULT_ENCODE_EXTRACTED_FILE_NAMES = false;
    private static final String DEFAULT_CUSTOM_SYMBOLS_DIRECTORY = "";
    private static final List<String> DEFAULT_JAR_SKIP_LIST = new ArrayList<String>();
    private static final List<String> DEFAULT_CLASS_SKIP_LIST = new ArrayList<String>();
    @VisibleForTesting
    public static final Boolean DEFAULT_INSTRUMENT_OKHTTP = true;
    @VisibleForTesting
    public static final Boolean DEFAULT_INSTRUMENT_ON_CLICK = true;
    @VisibleForTesting
    public static final Boolean DEFAULT_INSTRUMENT_ON_LONG_CLICK = true;
    @VisibleForTesting
    public static final Boolean DEFAULT_INSTRUMENT_WEBVIEW = true;
    @VisibleForTesting
    public static final Boolean DEFAULT_INSTRUMENT_FIREBASE_MESSAGING = false;
    Property<Boolean> forceIncrementalOverwrite;
    Property<Boolean> disableDependencyInjection;
    Property<Boolean> disableComposeDependencyInjection;
    Property<Boolean> disableRNBundleRetriever;
    Property<Boolean> encodeExtractedFileNames;
    Action<Variant> variantFilter;
    Property<Boolean> instrumentOkHttp;
    Property<Boolean> instrumentOnClick;
    Property<Boolean> instrumentOnLongClick;
    Property<Boolean> instrumentWebview;
    Property<Boolean> instrumentFirebaseMessaging;
    Property<String> customSymbolsDirectory;
    ListProperty<String> jarSkipList;
    ListProperty<String> classSkipList;

    public SwazzlerExtension(ObjectFactory objectFactory) throws ExtensionException {
        this.forceIncrementalOverwrite = objectFactory.property(Boolean.class).convention((Object)DEFAULT_FORCE_INCREMENTAL_OVERWRITE);
        this.disableDependencyInjection = objectFactory.property(Boolean.class).convention((Object)DEFAULT_DISABLE_DEPENDENCY_INJECTION);
        this.disableComposeDependencyInjection = objectFactory.property(Boolean.class).convention((Object)DEFAULT_DISABLE_COMPOSE_DEPENDENCY_INJECTION);
        this.disableRNBundleRetriever = objectFactory.property(Boolean.class).convention((Object)DEFAULT_DISABLE_RN_BUNDLE_RETRIEVER);
        this.encodeExtractedFileNames = objectFactory.property(Boolean.class).convention((Object)DEFAULT_ENCODE_EXTRACTED_FILE_NAMES);
        this.instrumentOkHttp = objectFactory.property(Boolean.class).convention((Object)DEFAULT_INSTRUMENT_OKHTTP);
        this.instrumentOnClick = objectFactory.property(Boolean.class).convention((Object)DEFAULT_INSTRUMENT_ON_CLICK);
        this.instrumentOnLongClick = objectFactory.property(Boolean.class).convention((Object)DEFAULT_INSTRUMENT_ON_LONG_CLICK);
        this.instrumentWebview = objectFactory.property(Boolean.class).convention((Object)DEFAULT_INSTRUMENT_WEBVIEW);
        this.instrumentFirebaseMessaging = objectFactory.property(Boolean.class).convention((Object)DEFAULT_INSTRUMENT_FIREBASE_MESSAGING);
        this.customSymbolsDirectory = objectFactory.property(String.class).convention((Object)DEFAULT_CUSTOM_SYMBOLS_DIRECTORY);
        this.jarSkipList = objectFactory.listProperty(String.class).convention(DEFAULT_JAR_SKIP_LIST);
        this.classSkipList = objectFactory.listProperty(String.class).convention(DEFAULT_CLASS_SKIP_LIST);
    }

    public Property<Boolean> getForceIncrementalOverwrite() {
        return this.forceIncrementalOverwrite;
    }

    public Property<Boolean> getDisableDependencyInjection() {
        return this.disableDependencyInjection;
    }

    public Property<Boolean> getDisableComposeDependencyInjection() {
        return this.disableComposeDependencyInjection;
    }

    public Property<Boolean> getDisableRNBundleRetriever() {
        return this.disableRNBundleRetriever;
    }

    public Property<Boolean> getEncodeExtractedFileNames() {
        return this.encodeExtractedFileNames;
    }

    public ListProperty<String> getJarSkipList() {
        return this.jarSkipList;
    }

    public ListProperty<String> getClassSkipList() {
        return this.classSkipList;
    }

    public void variantFilter(Action<Variant> variantFilter) {
        this.variantFilter = variantFilter;
    }

    public Property<Boolean> getInstrumentOkHttp() {
        return this.instrumentOkHttp;
    }

    public Property<Boolean> getInstrumentOnClick() {
        return this.instrumentOnClick;
    }

    public Property<Boolean> getInstrumentOnLongClick() {
        return this.instrumentOnLongClick;
    }

    public Property<Boolean> getInstrumentWebview() {
        return this.instrumentWebview;
    }

    public Property<Boolean> getInstrumentFirebaseMessaging() {
        return this.instrumentFirebaseMessaging;
    }

    @Deprecated
    public Property<String> getCustomSymbolsDirectory() {
        return this.customSymbolsDirectory;
    }

    public boolean isSwazzlingDisabled(String variantName) {
        Variant variant = new Variant(variantName);
        if (this.variantFilter != null) {
            this.variantFilter.execute((Object)variant);
        }
        return !variant.swazzlingEnabled;
    }

    public static class Variant {
        public String name;
        private boolean swazzlingEnabled = true;

        Variant(String name) {
            this.name = name;
        }

        public void setSwazzlingEnabled(boolean enabled) {
            this.swazzlingEnabled = enabled;
        }
    }
}

