/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.extension.utils;

import com.android.build.gradle.AppExtension;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.SmartDefaultsProvider;
import io.embrace.android.gradle.swazzler.config.VariantConfiguration;
import io.embrace.android.gradle.swazzler.config.unity.UnityConfig;
import io.embrace.android.gradle.swazzler.config.unity.UnitySymbolsDir;
import io.embrace.android.gradle.swazzler.plugin.extension.EmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.util.ProjectType;
import io.embrace.android.gradle.swazzler.util.ProjectTypeVerifier;
import io.embrace.android.gradle.swazzler.util.UnitySymbolFilesManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B3\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u000f\u001a&\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00000\u0000 \u0011*\u0012\u0012\f\u0012\n \u0011*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/extension/utils/VariantSmartConfigurationToEmbraceExtensionInternal;", "Lorg/gradle/api/Action;", "Lio/embrace/android/gradle/swazzler/plugin/extension/EmbraceExtensionInternal;", "variantConfigurationProvider", "Lorg/gradle/api/provider/Provider;", "Lio/embrace/android/gradle/swazzler/config/VariantConfiguration;", "variantInfo", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "androidExtension", "Lcom/android/build/gradle/AppExtension;", "project", "Lorg/gradle/api/Project;", "swazzlerExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;", "(Lorg/gradle/api/provider/Provider;Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;Lcom/android/build/gradle/AppExtension;Lorg/gradle/api/Project;Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;)V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "execute", "", "extension", "embrace-swazzler"})
public final class VariantSmartConfigurationToEmbraceExtensionInternal
implements Action<EmbraceExtensionInternal> {
    @NotNull
    private final Provider<VariantConfiguration> variantConfigurationProvider;
    @NotNull
    private final AndroidCompactedVariantData variantInfo;
    @NotNull
    private final AppExtension androidExtension;
    @NotNull
    private final Project project;
    @NotNull
    private final SwazzlerExtension swazzlerExtension;
    private final Logger<VariantSmartConfigurationToEmbraceExtensionInternal> logger;

    public VariantSmartConfigurationToEmbraceExtensionInternal(@NotNull Provider<VariantConfiguration> variantConfigurationProvider, @NotNull AndroidCompactedVariantData variantInfo, @NotNull AppExtension androidExtension, @NotNull Project project, @NotNull SwazzlerExtension swazzlerExtension) {
        Intrinsics.checkNotNullParameter(variantConfigurationProvider, (String)"variantConfigurationProvider");
        Intrinsics.checkNotNullParameter((Object)variantInfo, (String)"variantInfo");
        Intrinsics.checkNotNullParameter((Object)androidExtension, (String)"androidExtension");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)swazzlerExtension, (String)"swazzlerExtension");
        this.variantConfigurationProvider = variantConfigurationProvider;
        this.variantInfo = variantInfo;
        this.androidExtension = androidExtension;
        this.project = project;
        this.swazzlerExtension = swazzlerExtension;
        this.logger = Logger.newLogger(VariantSmartConfigurationToEmbraceExtensionInternal.class);
    }

    public void execute(@NotNull EmbraceExtensionInternal extension) {
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        Provider provider = this.project.provider(() -> VariantSmartConfigurationToEmbraceExtensionInternal.execute$lambda-0(this));
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.provider {\n            // there is no need to let Gradle know about the knowledge of how to get unitySymbolsDir, because\n            // all properties that getSymbolsDir depends on are already config-cache aware. Meaning that if any\n            // of the properties that this function uses changes, Gradle will invalidate config cache.\n            val unityConfig = if (variantConfigurationProvider.isPresent) {\n                variantConfigurationProvider.get().unityConfig\n            } else {\n                null\n            }\n\n            val realProject = project.parent ?: project\n            UnitySymbolFilesManager.of().getSymbolsDir(\n                realProject.layout.projectDirectory,\n                project.layout.projectDirectory,\n                variantInfo,\n                unityConfig\n            )\n        }");
        Provider symbolsDir = provider;
        Provider projectType = this.project.provider(() -> VariantSmartConfigurationToEmbraceExtensionInternal.execute$lambda-1(symbolsDir, this));
        extension.getProjectType().set(projectType);
        extension.getUnitySymbolsDir().set(symbolsDir);
        extension.getNdkEnabled().set(this.project.provider(() -> VariantSmartConfigurationToEmbraceExtensionInternal.execute$lambda-2(this, extension)));
    }

    private static final UnitySymbolsDir execute$lambda-0(VariantSmartConfigurationToEmbraceExtensionInternal this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        UnityConfig unityConfig = this$0.variantConfigurationProvider.isPresent() ? ((VariantConfiguration)this$0.variantConfigurationProvider.get()).getUnityConfig() : (UnityConfig)null;
        Project project = this$0.project.getParent();
        Project project2 = project == null ? this$0.project : project;
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.parent ?: project");
        Project realProject = project2;
        UnitySymbolFilesManager unitySymbolFilesManager = UnitySymbolFilesManager.Factory.of();
        project2 = realProject.getLayout().getProjectDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"realProject.layout.projectDirectory");
        Project project3 = project2;
        project2 = this$0.project.getLayout().getProjectDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.layout.projectDirectory");
        return unitySymbolFilesManager.getSymbolsDir((Directory)project3, (Directory)project2, this$0.variantInfo, unityConfig);
    }

    private static final ProjectType execute$lambda-1(Provider $symbolsDir, VariantSmartConfigurationToEmbraceExtensionInternal this$0) {
        Intrinsics.checkNotNullParameter((Object)$symbolsDir, (String)"$symbolsDir");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return ProjectTypeVerifier.getProjectType((Provider<UnitySymbolsDir>)$symbolsDir, this$0.androidExtension, this$0.swazzlerExtension);
    }

    /*
     * WARNING - void declaration
     */
    private static final Boolean execute$lambda-2(VariantSmartConfigurationToEmbraceExtensionInternal this$0, EmbraceExtensionInternal $extension) {
        Boolean bl;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$extension, (String)"$extension");
        if (!this$0.variantConfigurationProvider.isPresent() || ((VariantConfiguration)this$0.variantConfigurationProvider.get()).getNdkEnabled() == null) {
            this$0.logger.debug("Ndk enabled has not been set by the customer. We will automatically decide if ndk is enabled.");
            Object object = $extension.getProjectType().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extension.projectType.get()");
            boolean smartNdkEnabled = SmartDefaultsProvider.getNdkEnabledSmartDefault((ProjectType)((Object)object));
            this$0.logger.debug(Intrinsics.stringPlus((String)"Automatic ndkEnabled=", (Object)smartNdkEnabled));
            bl = smartNdkEnabled;
        } else {
            void var2_4;
            Boolean customerNdkEnabled = ((VariantConfiguration)this$0.variantConfigurationProvider.get()).getNdkEnabled();
            this$0.logger.debug(Intrinsics.stringPlus((String)"Ndk enabled has been set by the customer. NdkEnabled=", (Object)customerNdkEnabled));
            bl = var2_4;
        }
        return bl;
    }
}

