/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.knownissues;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.knownissues.KnownIssueListener;
import io.embrace.android.gradle.swazzler.util.ExceptionUtilsKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\t\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00000\u0000 \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/knownissues/KnownIssuesAction;", "Lorg/gradle/api/Action;", "Lorg/gradle/BuildResult;", "issuesListeners", "", "Lio/embrace/android/gradle/swazzler/plugin/knownissues/KnownIssueListener;", "([Lio/embrace/android/gradle/swazzler/plugin/knownissues/KnownIssueListener;)V", "knownIssuesListeners", "", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "addKnownIssueListener", "", "knownIssueListener", "execute", "buildResult", "embrace-swazzler"})
public final class KnownIssuesAction
implements Action<BuildResult> {
    private final Logger<KnownIssuesAction> logger;
    @NotNull
    private final Set<KnownIssueListener> knownIssuesListeners;

    public KnownIssuesAction(KnownIssueListener ... issuesListeners) {
        Intrinsics.checkNotNullParameter((Object)issuesListeners, (String)"issuesListeners");
        this.logger = Logger.newLogger(KnownIssuesAction.class);
        this.knownIssuesListeners = ArraysKt.toMutableSet((Object[])issuesListeners);
    }

    public void execute(@NotNull BuildResult buildResult) {
        Intrinsics.checkNotNullParameter((Object)buildResult, (String)"buildResult");
        Throwable throwable = buildResult.getFailure();
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl = false;
            boolean bl2 = false;
            Throwable failure = throwable2;
            boolean bl3 = false;
            Throwable rootCause = ExceptionUtilsKt.findRootCause$default(failure, null, 2, null);
            for (KnownIssueListener listener : this.knownIssuesListeners) {
                String string = rootCause.getMessage();
                if (string == null) continue;
                String string2 = string;
                boolean bl4 = false;
                boolean bl5 = false;
                String failureMessage = string2;
                boolean bl6 = false;
                if (!listener.isKnownIssue(failureMessage)) continue;
                this.logger.warn("Known issue=" + listener.getName() + " has been detected");
                listener.setOriginalStacktrace(failureMessage);
                listener.performAction();
            }
        }
    }

    public final void addKnownIssueListener(@NotNull KnownIssueListener knownIssueListener) {
        Intrinsics.checkNotNullParameter((Object)knownIssueListener, (String)"knownIssueListener");
        this.knownIssuesListeners.add(knownIssueListener);
    }
}

