/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.ndk;

import com.google.gson.Gson;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.network.EmbraceEndpoint;
import io.embrace.android.gradle.swazzler.network.HttpCallResult;
import io.embrace.android.gradle.swazzler.network.NetworkService;
import io.embrace.android.gradle.swazzler.network.PostJsonParams;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.ndk.NdkUploadHandshakeRequest;
import io.embrace.android.gradle.swazzler.plugin.ndk.NdkUploadHandshakeResponse;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J,\u0010\n\u001a \u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\r\u0018\u00010\u000bj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0007\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00000\u0000 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/ndk/NdkUploadHandshake;", "", "dependencyInjectionProvider", "Lio/embrace/android/gradle/swazzler/di/DependencyInjectionProvider;", "buildReporter", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildReporter;", "(Lio/embrace/android/gradle/swazzler/di/DependencyInjectionProvider;Lio/embrace/android/gradle/swazzler/plugin/buildreporter/BuildReporter;)V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "getRequestedSymbols", "", "", "", "Lio/embrace/android/gradle/swazzler/plugin/ndk/SymbolsOnHandshakeResponse;", "ndkUploadHandshakeRequest", "Lio/embrace/android/gradle/swazzler/plugin/ndk/NdkUploadHandshakeRequest;", "embrace-swazzler"})
public final class NdkUploadHandshake {
    @NotNull
    private final DependencyInjectionProvider dependencyInjectionProvider;
    @NotNull
    private final BuildReporter buildReporter;
    private final Logger<NdkUploadHandshake> logger;

    public NdkUploadHandshake(@NotNull DependencyInjectionProvider dependencyInjectionProvider, @NotNull BuildReporter buildReporter) {
        Intrinsics.checkNotNullParameter((Object)dependencyInjectionProvider, (String)"dependencyInjectionProvider");
        Intrinsics.checkNotNullParameter((Object)buildReporter, (String)"buildReporter");
        this.dependencyInjectionProvider = dependencyInjectionProvider;
        this.buildReporter = buildReporter;
        this.logger = Logger.newLogger(NdkUploadHandshake.class);
    }

    @Nullable
    public final Map<String, List<String>> getRequestedSymbols(@NotNull NdkUploadHandshakeRequest ndkUploadHandshakeRequest) {
        Intrinsics.checkNotNullParameter((Object)ndkUploadHandshakeRequest, (String)"ndkUploadHandshakeRequest");
        this.logger.debug("NDK Handshake invoked.");
        try {
            HttpCallResult uploadResult;
            Gson gson2 = this.dependencyInjectionProvider.getGson();
            String requestJson = gson2.toJson((Object)ndkUploadHandshakeRequest);
            NetworkService networkService = this.dependencyInjectionProvider.getNetworkService();
            String string = ndkUploadHandshakeRequest.getAppId();
            String string2 = ndkUploadHandshakeRequest.getApiToken();
            Intrinsics.checkNotNullExpressionValue((Object)requestJson, (String)"requestJson");
            HttpCallResult httpCallResult = uploadResult = networkService.postJson(new PostJsonParams(EmbraceEndpoint.NDK_HANDSHAKE, string, string2, requestJson));
            if (httpCallResult instanceof HttpCallResult.Success) {
                Map<String, List<String>> map2;
                Map<String, List<String>> symbolsToUpload;
                this.logger.info(Intrinsics.stringPlus((String)"NDK Handshake was successful. Variant = ", (Object)ndkUploadHandshakeRequest.getVariant()));
                CharSequence charSequence = ((HttpCallResult.Success)uploadResult).getResponseBody();
                boolean bl = false;
                boolean bl2 = false;
                if (charSequence == null || charSequence.length() == 0) {
                    this.logger.error("NDK upload handshake returned a successful response, but body is null or empty.");
                    return null;
                }
                this.logger.debug(Intrinsics.stringPlus((String)"NDK Handshake responseBody = ", (Object)((HttpCallResult.Success)uploadResult).getResponseBody()));
                Object object = gson2.fromJson(((HttpCallResult.Success)uploadResult).getResponseBody(), NdkUploadHandshakeResponse.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(\n                        uploadResult.responseBody,\n                        NdkUploadHandshakeResponse::class.java\n                    )");
                NdkUploadHandshakeResponse response = (NdkUploadHandshakeResponse)object;
                Map<String, List<String>> map3 = symbolsToUpload = response.getSymbols();
                boolean bl3 = false;
                boolean bl4 = false;
                if (map3 == null || map3.isEmpty()) {
                    this.logger.info("No NDK files requested. Skipping NDK symbols upload.");
                    map2 = null;
                } else {
                    this.logger.info(Intrinsics.stringPlus((String)"Requested NDK symbols: ", (Object)gson2.toJson(response.getSymbols())));
                    map2 = symbolsToUpload;
                }
                return map2;
            }
            if (httpCallResult instanceof HttpCallResult.Failure) {
                this.logger.warn("Failed to perform NDK Handshake. \nVariant=" + ndkUploadHandshakeRequest.getVariant() + " \nStatus: " + ((HttpCallResult.Failure)uploadResult).getCode() + ". Error: " + ((HttpCallResult.Failure)uploadResult).getErrorMessage() + ". \n");
                return null;
            }
            if (httpCallResult instanceof HttpCallResult.Error) {
                this.logger.error("Failed to perform NDK Handshake (HttpCallResult.Error). \nVariant=" + ndkUploadHandshakeRequest.getVariant() + " \nException: " + ((HttpCallResult.Error)uploadResult).getException() + " \n");
                this.buildReporter.onException(((HttpCallResult.Error)uploadResult).getException());
                return null;
            }
            throw new NoWhenBranchMatchedException();
        }
        catch (Exception ex) {
            this.logger.error("Failed to perform NDK Handshake. ", ex);
            this.buildReporter.onException(ex);
            return null;
        }
    }
}

