/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.ndk;

import com.google.gson.annotations.SerializedName;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.unity.UnitySymbolsDir;
import io.embrace.android.gradle.swazzler.constant.HttpConstants;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.network.EmbraceEndpoint;
import io.embrace.android.gradle.swazzler.plugin.GradleUploadTask;
import io.embrace.android.gradle.swazzler.plugin.TaskException;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.configuration.newvariantapi.ResourcesGenerator;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.plugin.ndk.GetNativeSoFilesInDirectory;
import io.embrace.android.gradle.swazzler.plugin.ndk.NdkUploadHandshake;
import io.embrace.android.gradle.swazzler.plugin.ndk.NdkUploadHandshakeRequest;
import io.embrace.android.gradle.swazzler.plugin.ndk.SymbolResourceInjector;
import io.embrace.android.gradle.swazzler.util.HashUtils;
import io.embrace.android.gradle.swazzler.util.UnitySymbolFilesManager;
import io.embrace.android.gradle.swazzler.util.compression.FileCompressor;
import io.embrace.android.gradle.swazzler.util.compression.ZstdFileCompressor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import net.fornwall.jelf.ElfFile;
import net.fornwall.jelf.ElfSection;
import net.fornwall.jelf.ElfUtil;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;

public class NdkUploadTask
extends GradleUploadTask
implements ResourcesGenerator {
    public static final String NAME = "ndkUploadTask";
    private static final Logger logger = Logger.newLogger(NdkUploadTask.class);
    private static final String KEY_VARIANT = "variant";
    private static final String KEY_ARCH = "arch";
    private static final String KEY_FILE_NAME = "filename";
    public static final String FILE_NDK_SYMBOLS = "ndk_symbols.xml";
    private static final String KEY_SYMBOL_ID = "id";
    private static final MediaType MEDIA_TYPE_JSON = MediaType.parse((String)"application/json");
    private static final String ELF_BUILD_ID_SECTION_NAME = ".note.gnu.build-id";
    private static final Map<String, String> unityFilenameMapping = NdkUploadTask.initUnityFilenameMap();
    private Map<String, Map<String, String>> deobfuscatedHashedObjects = new HashMap<String, Map<String, String>>();
    private final GetNativeSoFilesInDirectory getNativeSoFilesInDirectory = new GetNativeSoFilesInDirectory();
    private final FileCompressor fileCompressor = new ZstdFileCompressor(this.getBuildReporter());
    private Property<NdkType> ndkType = this.getObjects().property(NdkType.class).convention((Object)NdkType.UNDEFINED);
    private DirectoryProperty deobfuscatedFilesDirPath = this.getObjects().directoryProperty();
    private Property<UnitySymbolsDir> unitySymbolsDir = this.getObjects().property(UnitySymbolsDir.class);
    private Property<Boolean> ndkEnabled = this.getObjects().property(Boolean.class);
    private DirectoryProperty generatedEmbraceResourcesDirectory = this.getObjects().directoryProperty();
    private ConfigurableFileCollection architecturesDirectoryForNative = this.getObjects().fileCollection();
    private UnitySymbolFilesManager unitySymbolFilesManager;

    private static Map<String, String> initUnityFilenameMap() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("libunity.sym.so", "libunity.so");
        map2.put("libil2cpp.sym", "libil2cpp.so");
        map2.put("libil2cpp.sym.so", "libil2cpp.so");
        return Collections.unmodifiableMap(map2);
    }

    @InputFiles
    public ConfigurableFileCollection getArchitecturesDirectoryForNative() {
        return this.architecturesDirectoryForNative;
    }

    @Override
    @OutputDirectory
    public DirectoryProperty getGeneratedEmbraceResourcesDirectory() {
        return this.generatedEmbraceResourcesDirectory;
    }

    @Input
    @Optional
    public Property<NdkType> getNdkType() {
        return this.ndkType;
    }

    @Internal
    public DirectoryProperty getDeobfuscatedFilesDirPath() {
        return this.deobfuscatedFilesDirPath;
    }

    @Optional
    @Input
    public Property<UnitySymbolsDir> getUnitySymbolsDir() {
        return this.unitySymbolsDir;
    }

    @Input
    public Property<Boolean> getNdkEnabled() {
        return this.ndkEnabled;
    }

    @Inject
    public ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onRun() {
        if (!((Boolean)this.getNdkEnabled().get()).booleanValue()) {
            logger.info("NDK crash capture is not enabled. Skipping symbol upload.");
            return;
        }
        if (this.ndkType.get() == NdkType.UNDEFINED) {
            logger.warn("Trying NDK upload task run without ndk defined. NDK upload task stopped.");
            return;
        }
        this.unitySymbolFilesManager = UnitySymbolFilesManager.Factory.of();
        logger.info(String.format("Starting NDK upload task {app-id=%s, api-token=%s}.", this.getAppId().get(), this.getApiToken().get()));
        try {
            logger.debug("About to generate hashed objects");
            this.generateHashedObjects();
            logger.debug("About to upload handshake");
            this.uploadHandshake();
            logger.debug("About to inject symbols as resources");
            this.injectSymbolsAsResources();
        }
        catch (Exception ex) {
            this.onException(ex);
            throw new TaskException("Failed uploading mapping artifact.", ex);
        }
    }

    private HashMap<String, List<File>> getSoFilesByArchitectureForUnity() {
        logger.debug("Will try to get so files by architecture for unity");
        File[] unitySymbolFiles = null;
        if (this.getUnitySymbolsDir().isPresent() && this.getUnitySymbolsDir().get() != null) {
            unitySymbolFiles = this.unitySymbolFilesManager.getSymbolFiles((UnitySymbolsDir)this.getUnitySymbolsDir().get(), (Directory)this.getProjectLayout().getBuildDirectory().get(), (AndroidCompactedVariantData)this.getVariantInfo().get());
        }
        if (unitySymbolFiles == null) {
            logger.warn("Failed to retrieve Unity symbols by architecture.");
            return null;
        }
        logger.debug(String.format("Found %s architectures", unitySymbolFiles.length));
        return this.generateArchSoMap(unitySymbolFiles);
    }

    private HashMap<String, List<File>> getSoFilesByArchitectureForNative() {
        HashMap<String, List<File>> archSoMap = new HashMap<String, List<File>>();
        File[] archFiles = null;
        if (!this.architecturesDirectoryForNative.isEmpty()) {
            archFiles = this.architecturesDirectoryForNative.getSingleFile().listFiles();
        }
        if (archFiles != null && archFiles.length > 0) {
            logger.info("Shared Objects files (.so) found.");
            archSoMap.putAll(this.generateArchSoMap(archFiles));
        } else {
            logger.warn("No Shared Objects files (.so) found");
        }
        return archSoMap;
    }

    private HashMap<String, List<File>> generateArchSoMap(File[] listOfArch) {
        logger.debug("About to generate map or architectures");
        HashMap<String, List<File>> archSoMap = new HashMap<String, List<File>>();
        Arrays.stream(listOfArch).filter(arch -> arch != null && arch.exists()).forEach(arch -> {
            String archName = arch.getName();
            logger.debug(String.format("arch folder absolute path:%s for arch=%s", arch.getAbsolutePath(), archName));
            File[] soFiles = this.getNativeSoFilesInDirectory.invoke((File)arch);
            if (soFiles != null) {
                List<File> soFileList = Arrays.asList(soFiles);
                archSoMap.put(archName, soFileList);
                soFileList.forEach(file -> logger.info(String.format("Symbol file found for arch %s in path %s", archName, file.getPath())));
            } else {
                logger.debug("soFiles is null");
            }
        });
        return archSoMap;
    }

    @Nullable
    private String readSha1FromBuildFile(File file) {
        ElfFile ef;
        logger.debug(String.format("About to read SHA1 from file=%s", file.getPath()));
        try {
            ef = ElfFile.from((File)file);
            logger.debug("Successfully obtained ElfFile");
        }
        catch (IOException e) {
            this.onException(e);
            logger.warn("Failed to get build ID from " + file.getAbsolutePath(), e);
            return null;
        }
        ElfSection section = ef.firstSectionByName(ELF_BUILD_ID_SECTION_NAME);
        if (section == null) {
            logger.warn("Failed to get build ID from " + file.getAbsolutePath() + ". Could not find build ID section");
            return null;
        }
        logger.debug("Successfully obtained ElfSection");
        String buildId = ElfUtil.getElfNoteSectionDescriptor(section);
        if (buildId == null) {
            logger.warn("Read build ID from " + file.getAbsolutePath() + ", but it was null.");
        }
        logger.debug(String.format("Build Id=%s successfully read", buildId));
        return buildId;
    }

    private void generateHashedObjects() throws IllegalArgumentException {
        HashMap<String, List<File>> soFileMap;
        if (this.ndkType.get() == NdkType.UNITY) {
            logger.debug("ndk type is UNITY");
            soFileMap = this.getSoFilesByArchitectureForUnity();
        } else if (this.ndkType.get() == NdkType.NATIVE) {
            logger.debug("ndk type is NATIVE");
            soFileMap = this.getSoFilesByArchitectureForNative();
        } else {
            logger.debug("ndk type is undefined");
            throw new IllegalArgumentException("Cannot generate NDK map file. Unsupported NDK type.");
        }
        if (soFileMap == null) {
            logger.error("Failed to generate map of NDK symbol files.");
            return;
        }
        soFileMap.forEach((arch, sharedObjects) -> {
            HashMap hashedObjects = new HashMap();
            logger.debug(String.format("About to generate hash for arch=%s", arch));
            sharedObjects.forEach(shared -> {
                try {
                    String outputDir = ((Directory)this.deobfuscatedFilesDirPath.dir(arch).get()).getAsFile().getAbsolutePath();
                    File compressedFile = this.fileCompressor.compress((File)shared, outputDir);
                    if (compressedFile != null) {
                        String buildId;
                        if (this.ndkType.get() == NdkType.UNITY) {
                            logger.debug("ndk type is UNITY");
                            buildId = this.readSha1FromBuildFile((File)shared);
                            if (buildId == null) {
                                logger.error("Could not read build ID from " + shared.getAbsolutePath() + ". Crash symbolication will not work properly.");
                                return;
                            }
                            logger.debug(String.format("BuildId=%s", buildId));
                        } else if (this.ndkType.get() == NdkType.NATIVE) {
                            logger.debug("ndk type is NATIVE");
                            buildId = HashUtils.generateSha1FromFile(compressedFile);
                            logger.debug(String.format("Successfully generated SHA1 form file. BuildId=%s", buildId));
                        } else {
                            throw new IllegalArgumentException("Failed to generate native libraries map file. Unsupported NDK type.");
                        }
                        logger.debug(String.format("Attempting to add a new hashed symbol object {arch=%s, sha1=%s, filePath=%s}.", arch, buildId, compressedFile.getAbsolutePath()));
                        hashedObjects.put(compressedFile.getName(), buildId);
                    } else {
                        logger.debug("File was not compressed");
                    }
                }
                catch (IOException ex) {
                    this.onException(ex);
                    logger.error(String.format("Failed to generate hash for %s object.", shared.getName()), ex);
                }
            });
            this.deobfuscatedHashedObjects.put((String)arch, hashedObjects);
        });
    }

    private void uploadHandshake() {
        NdkUploadHandshakeRequest params = new NdkUploadHandshakeRequest((String)this.getAppId().get(), (String)this.getApiToken().get(), ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName(), this.deobfuscatedHashedObjects);
        NdkUploadHandshake ndkUploadHandshake = new NdkUploadHandshake((DependencyInjectionProvider)this.getDependencyInjectionProvider().get(), (BuildReporter)this.getBuildReporter().get());
        Map<String, List<String>> requestedSymbols = ndkUploadHandshake.getRequestedSymbols(params);
        if (requestedSymbols != null) {
            logger.info("Requested NDK symbols: " + ((DependencyInjectionProvider)this.getDependencyInjectionProvider().get()).getGson().toJson(requestedSymbols));
            this.uploadSymbols(requestedSymbols);
        } else {
            logger.info("No NDK files requested. Skipping NDK symbols upload.");
        }
    }

    private void uploadSymbols(Map<String, List<String>> requestedSymbols) {
        String url = (String)this.getUrlSymbolUpload().get() + EmbraceEndpoint.NDK.getUrl();
        logger.debug("URL for NDK upload: " + url);
        Map<String, Map<String, File>> symbolsToUpload = this.filterRequestedSymbolsFiles(requestedSymbols);
        symbolsToUpload.forEach((arch, files) -> files.forEach((id, symbolFile) -> {
            try {
                logger.debug(String.format("About to upload symbol file with id=%s and file=%s", id, symbolFile.getName()));
                MultipartBody requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("app", (String)this.getAppId().get()).addFormDataPart("token", (String)this.getApiToken().get()).addFormDataPart(KEY_VARIANT, ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName()).addFormDataPart(KEY_ARCH, arch).addFormDataPart(KEY_SYMBOL_ID, id).addFormDataPart(KEY_FILE_NAME, symbolFile.getName()).addFormDataPart("file", symbolFile.getName(), RequestBody.create((MediaType)HttpConstants.MEDIA_TYPE_TEXT_PLAIN, (File)symbolFile)).build();
                this.executeUpload(url, (RequestBody)requestBody, new GradleUploadTask.UploadResponse(){
                    final /* synthetic */ String val$arch;
                    final /* synthetic */ String val$id;
                    final /* synthetic */ File val$symbolFile;
                    {
                        this.val$arch = string;
                        this.val$id = string2;
                        this.val$symbolFile = file;
                    }

                    @Override
                    public void onResponse(ResponseBody responseBody) {
                        logger.info(String.format("Requested symbol file was successfully uploaded {variant=%s arch=%s id=%s filename=%s}", ((AndroidCompactedVariantData)NdkUploadTask.this.getVariantInfo().get()).getName(), this.val$arch, this.val$id, this.val$symbolFile.getName()));
                    }

                    @Override
                    public void onError(String errorMessage, int code) {
                        logger.error(String.format("Failed to upload requested symbols {variant=%s arch=%s id=%s filename=%s}. status=%d error=%s", ((AndroidCompactedVariantData)NdkUploadTask.this.getVariantInfo().get()).getName(), this.val$arch, this.val$id, this.val$symbolFile.getName(), code, errorMessage));
                    }
                });
            }
            catch (Exception ex) {
                this.onException(ex);
                logger.error(String.format("An exception occurred when attempting to upload symbols %s for arch %s.", symbolFile.getName(), arch), ex);
            }
        }));
    }

    private Map<String, Map<String, File>> filterRequestedSymbolsFiles(Map<String, List<String>> requestedSymbols) {
        logger.debug("About to filter requested symbols");
        HashMap<String, Map<String, File>> selectedSymbols = new HashMap<String, Map<String, File>>();
        HashMap<String, List<File>> deobfuscatedSymbols = this.getDeobfuscatedSymbolsFiles();
        requestedSymbols.forEach((arch, symbols) -> {
            if (deobfuscatedSymbols.containsKey(arch)) {
                logger.debug(String.format("Architecture=%s found within deobfuscatedSymbols", arch));
                HashMap requested = new HashMap();
                List symbolFiles = (List)deobfuscatedSymbols.get(arch);
                symbolFiles.forEach(symbolFile -> {
                    if (symbols.contains(symbolFile.getName())) {
                        logger.debug(String.format("Symbol=%s found within deobfuscated symbols", symbolFile.getName()));
                        String sha1 = this.getSha1ByFile((File)symbolFile, (String)arch);
                        if (sha1 != null) {
                            logger.debug(String.format("Sha1=%s", sha1));
                            requested.put(sha1, symbolFile);
                        } else {
                            logger.debug("Sha1 not found");
                        }
                    } else {
                        logger.debug(String.format("Will discard symbol=%s because it's not contained in deobfuscated symbols map", symbolFile.getName()));
                    }
                });
                if (!requested.isEmpty()) {
                    logger.debug(String.format("Adding map entry with arch=%s", arch));
                    selectedSymbols.put((String)arch, requested);
                }
            } else {
                logger.debug(String.format("Will discard architecture=%s because it's not contained in deobfuscated symbols map", arch));
            }
        });
        return selectedSymbols;
    }

    private String getSha1ByFile(File symbolFile, String archName) {
        if (archName == null) {
            logger.debug("architecture name is null, will return null");
            return null;
        }
        if (symbolFile == null) {
            logger.debug("symbol file is null, will return null");
            return null;
        }
        AtomicReference sha1Value = new AtomicReference();
        this.deobfuscatedHashedObjects.forEach((arch, symbolMap) -> {
            if (archName.equals(arch)) {
                symbolMap.forEach((fileName, sha1) -> {
                    if (fileName.equals(symbolFile.getName())) {
                        logger.debug(String.format("sha1=%s found", sha1));
                        sha1Value.set(sha1);
                    }
                });
            }
        });
        return (String)sha1Value.get();
    }

    private HashMap<String, List<File>> getDeobfuscatedSymbolsFiles() {
        HashMap<String, List<File>> archSoMap = new HashMap<String, List<File>>();
        File symbolsDir = new File(((File)this.deobfuscatedFilesDirPath.getAsFile().get()).getAbsolutePath());
        if (!symbolsDir.exists()) {
            logger.debug("Deobfuscation directory does not exist, will return an empty map");
            return archSoMap;
        }
        logger.debug("Deobfuscation directory exists");
        File[] listOfArch = symbolsDir.listFiles();
        if (listOfArch != null) {
            Arrays.stream(listOfArch).filter(arch -> arch != null && arch.exists()).forEach(arch -> {
                String archName = arch.getName();
                File[] soFiles = arch.listFiles();
                if (soFiles != null) {
                    List<File> soFileList = Arrays.asList(soFiles);
                    logger.debug(String.format("Architecture=%s has %s files", archName, soFileList.size()));
                    archSoMap.put(archName, soFileList);
                } else {
                    logger.debug(String.format("No so files for architecture=%s", archName));
                }
            });
        } else {
            logger.debug("there are no architecture files");
        }
        return archSoMap;
    }

    private void injectSymbolsAsResources() throws FileNotFoundException, UnsupportedEncodingException, TransformerException, ParserConfigurationException {
        logger.debug("Attempting to inject symbols as resources.");
        File ndkSymbolsFile = ((Directory)this.getGeneratedEmbraceResourcesDirectory().dir(String.format("values/%s", FILE_NDK_SYMBOLS)).get()).getAsFile();
        try {
            logger.debug(String.format("About to delete previous config file for variant=%s and path=%s", ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName(), ndkSymbolsFile.getPath()));
            Files.deleteIfExists(ndkSymbolsFile.toPath());
            logger.debug("Successfully deleted");
        }
        catch (IOException e) {
            logger.debug("Previous ndk symbol files not found.");
        }
        File buildInfoFile = new File(ndkSymbolsFile.getPath());
        SymbolResourceInjector injector = new SymbolResourceInjector(((DependencyInjectionProvider)this.getDependencyInjectionProvider().get()).getGson());
        injector.writeSymbolResourceFile(buildInfoFile, this.deobfuscatedHashedObjects);
    }

    public static enum NdkType {
        NATIVE,
        UNITY,
        UNDEFINED;


        String getNdkTypeName() {
            switch (this) {
                case NATIVE: {
                    return "Native";
                }
                case UNITY: {
                    return "Unity";
                }
            }
            return "No";
        }
    }

    static class NdkSymbolsResource {
        @SerializedName(value="symbols")
        private Map<String, Map<String, String>> symbols;

        NdkSymbolsResource(Map<String, Map<String, String>> symbols) {
            HashMap<String, Map<String, String>> resourceSymbols = new HashMap<String, Map<String, String>>();
            symbols.forEach((arch, archSymbols) -> {
                if (archSymbols.isEmpty()) {
                    return;
                }
                HashMap archObjects = new HashMap();
                archSymbols.forEach((name, sha) -> {
                    String finalName = name;
                    if (unityFilenameMapping.containsKey(name)) {
                        finalName = (String)unityFilenameMapping.get(name);
                    }
                    archObjects.put(finalName, sha);
                });
                resourceSymbols.put((String)arch, archObjects);
            });
            this.symbols = resourceSymbols;
        }
    }
}

