/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.ndk;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.unity.UnitySymbolsDir;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import io.embrace.android.gradle.swazzler.plugin.TaskRegisterKt;
import io.embrace.android.gradle.swazzler.plugin.TaskRegistrationUtilsKt;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporterExtension;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.ProvidedBuildReporter;
import io.embrace.android.gradle.swazzler.plugin.extension.EmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.plugin.ndk.NdkUploadTask;
import io.embrace.android.gradle.swazzler.testcheckpoints.SwazzlerTestCheckPoints;
import io.embrace.android.gradle.swazzler.util.GradleUtils;
import io.embrace.android.gradle.swazzler.util.ProjectType;
import java.io.File;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0002R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\f\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00000\u0000 \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/ndk/NdkUploadTaskRegistration;", "", "project", "Lorg/gradle/api/Project;", "testCheckpoints", "Lio/embrace/android/gradle/swazzler/testcheckpoints/SwazzlerTestCheckPoints;", "(Lorg/gradle/api/Project;Lio/embrace/android/gradle/swazzler/testcheckpoints/SwazzlerTestCheckPoints;)V", "buildReporter", "Lio/embrace/android/gradle/swazzler/plugin/buildreporter/ProvidedBuildReporter;", "kotlin.jvm.PlatformType", "embraceExtensionInternal", "Lio/embrace/android/gradle/swazzler/plugin/extension/EmbraceExtensionInternal;", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "getProject", "()Lorg/gradle/api/Project;", "swazzlerExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;", "variantExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/EmbraceExtensionInternal$VariantExtension;", "execute", "Lorg/gradle/api/tasks/TaskProvider;", "Lio/embrace/android/gradle/swazzler/plugin/ndk/NdkUploadTask;", "variant", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "getMappingFileFolder", "Lorg/gradle/api/provider/Provider;", "", "embrace-swazzler"})
public final class NdkUploadTaskRegistration {
    @NotNull
    private final Project project;
    @NotNull
    private final SwazzlerTestCheckPoints testCheckpoints;
    private final Logger<NdkUploadTaskRegistration> logger;
    private final ProvidedBuildReporter buildReporter;
    @NotNull
    private final EmbraceExtensionInternal embraceExtensionInternal;
    @NotNull
    private final SwazzlerExtension swazzlerExtension;
    private EmbraceExtensionInternal.VariantExtension variantExtension;

    public NdkUploadTaskRegistration(@NotNull Project project, @NotNull SwazzlerTestCheckPoints testCheckpoints) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)testCheckpoints, (String)"testCheckpoints");
        this.project = project;
        this.testCheckpoints = testCheckpoints;
        this.logger = Logger.newLogger(NdkUploadTaskRegistration.class);
        this.buildReporter = (ProvidedBuildReporter)((BuildReporterExtension)this.project.getExtensions().getByType(BuildReporterExtension.class)).getBuildReporter().get();
        Object object = this.project.getExtensions().getByType(EmbraceExtensionInternal.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.extensions.getByType(\n            EmbraceExtensionInternal::class.java\n        )");
        this.embraceExtensionInternal = (EmbraceExtensionInternal)object;
        object = this.project.getExtensions().findByType(SwazzlerExtension.class);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (object == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.swazzlerExtension = (SwazzlerExtension)object;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TaskProvider<NdkUploadTask> execute(@NotNull AndroidCompactedVariantData variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Object object = this.embraceExtensionInternal.getVariants().getByName(variant.getName());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"embraceExtensionInternal.variants.getByName(variant.name)");
        this.variantExtension = (EmbraceExtensionInternal.VariantExtension)object;
        object = this.variantExtension;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
            throw null;
        }
        this.logger.debug(Intrinsics.stringPlus((String)"Starting to execute NdkUploadTaskRegistration for variant=", (Object)((EmbraceExtensionInternal.VariantExtension)object).getName()));
        try {
            Provider mergeNativeLibsProvider = this.project.provider(() -> NdkUploadTaskRegistration.execute$lambda-0(this, variant)).flatMap(NdkUploadTaskRegistration::execute$lambda-1);
            TaskProvider<NdkUploadTask> ndkUploadTaskProvider2 = TaskRegisterKt.registerTask(this.project, "ndkUploadTask", NdkUploadTask.class, variant, arg_0 -> NdkUploadTaskRegistration.execute$lambda-6(this, variant, mergeNativeLibsProvider, arg_0));
            TaskContainer taskContainer = this.project.getTasks();
            this.logger.debug(Intrinsics.stringPlus((String)"Will attempt to configure task=", (Object)ndkUploadTaskProvider2.getName()));
            ndkUploadTaskProvider2.configure(arg_0 -> NdkUploadTaskRegistration.execute$lambda-9(this, taskContainer, arg_0));
            return ndkUploadTaskProvider2;
        }
        catch (Exception e) {
            EmbraceExtensionInternal.VariantExtension variantExtension = this.variantExtension;
            if (variantExtension == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
                throw null;
            }
            this.logger.error("Error while registering NdkUploadTask for variant=" + variantExtension.getName() + '.', e);
            this.testCheckpoints.exception(e);
            this.buildReporter.onException(variant.getName(), e);
            throw e;
        }
    }

    private final Provider<String> getMappingFileFolder() {
        EmbraceExtensionInternal.VariantExtension variantExtension = this.variantExtension;
        if (variantExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
            throw null;
        }
        Provider provider = variantExtension.getFlavorName().orElse(this.project.provider(NdkUploadTaskRegistration::getMappingFileFolder$lambda-11));
        variantExtension = this.variantExtension;
        if (variantExtension == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
            throw null;
        }
        Provider<String> provider2 = GradleUtils.zip(() -> NdkUploadTaskRegistration.getMappingFileFolder$lambda-10(this), provider, (Provider)variantExtension.getBuildTypeName(), NdkUploadTaskRegistration::getMappingFileFolder$lambda-12);
        Intrinsics.checkNotNullExpressionValue(provider2, (String)"zip(\n            { project.objects.listProperty(Any::class.java) },\n            variantExtension.flavorName.orElse(project.provider { \"\" }),\n            variantExtension.buildTypeName,\n            { flavorName, buildTypeName ->\n                if (flavorName.isNullOrEmpty()) {\n                    buildTypeName\n                } else {\n                    \"$flavorName/$buildTypeName\"\n                }\n            }\n        )");
        return provider2;
    }

    private static final TaskProvider execute$lambda-0(NdkUploadTaskRegistration this$0, AndroidCompactedVariantData $variant) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        return TaskRegistrationUtilsKt.tryGetTaskProvider(this$0.getProject(), "merge" + StringsKt.capitalize((String)$variant.getName()) + "NativeLibs");
    }

    private static final Provider execute$lambda-1(TaskProvider it) {
        return (Provider)it;
    }

    private static final Directory execute$lambda-6$lambda-3$lambda-2(Directory directory) {
        if (!directory.getAsFile().exists()) {
            directory.getAsFile().mkdirs();
        }
        return directory;
    }

    private static final UnitySymbolsDir execute$lambda-6$lambda-4(NdkUploadTaskRegistration this$0, ProjectType it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return it == ProjectType.UNITY ? (UnitySymbolsDir)this$0.embraceExtensionInternal.getUnitySymbolsDir().getOrNull() : null;
    }

    private static final String execute$lambda-6$lambda-5(String it) {
        return Intrinsics.stringPlus((String)"outputs/embrace/native/mapping/", (Object)it);
    }

    private static final void execute$lambda-6(NdkUploadTaskRegistration this$0, AndroidCompactedVariantData $variant, Provider $mergeNativeLibsProvider, NdkUploadTask task) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        task.getApiToken().set((Provider)this$0.embraceExtensionInternal.getApiToken());
        Object object = this$0.embraceExtensionInternal.getVariants().getByName($variant.getName());
        boolean bl = false;
        boolean bl2 = false;
        EmbraceExtensionInternal.VariantExtension variantExtension = (EmbraceExtensionInternal.VariantExtension)object;
        boolean bl3 = false;
        task.getAppId().set((Provider)variantExtension.getAppId());
        task.getGeneratedEmbraceResourcesDirectory().set(variantExtension.getEmbraceGeneratedResourcesForNdkPath().map(NdkUploadTaskRegistration::execute$lambda-6$lambda-3$lambda-2));
        task.getUrlSymbolUpload().set((Provider)this$0.embraceExtensionInternal.getSymbolStoreHostUrl());
        task.getUnitySymbolsDir().set(this$0.embraceExtensionInternal.getProjectType().map(arg_0 -> NdkUploadTaskRegistration.execute$lambda-6$lambda-4(this$0, arg_0)));
        task.getNdkEnabled().set((Provider)this$0.embraceExtensionInternal.getNdkEnabled());
        task.getDeobfuscatedFilesDirPath().set(this$0.getProject().getLayout().getBuildDirectory().dir(this$0.getMappingFileFolder().map(NdkUploadTaskRegistration::execute$lambda-6$lambda-5)));
        String customSymbolsDirectory = (String)this$0.swazzlerExtension.getCustomSymbolsDirectory().get();
        Object[] objectArray = (Object[])customSymbolsDirectory;
        bl2 = false;
        boolean bl4 = false;
        if (objectArray == null || objectArray.length() == 0) {
            this$0.logger.debug("Will automatically look for native symbols.");
            objectArray = new Object[]{$mergeNativeLibsProvider.flatMap((Transformer)new Transformer<Provider<File>, Task>(){

                @NotNull
                public Provider<File> transform(@NotNull Task inToTransform) {
                    Intrinsics.checkNotNullParameter((Object)inToTransform, (String)"inToTransform");
                    Provider provider = inToTransform.getOutputs().getFiles().getAsFileTree().getElements().map((Transformer)new Transformer<File, Set<? extends FileSystemLocation>>(){

                        @NotNull
                        public File transform(@NotNull Set<? extends FileSystemLocation> filesSystemLocationToTransform) {
                            T element$iv2;
                            block1: {
                                Intrinsics.checkNotNullParameter(filesSystemLocationToTransform, (String)"filesSystemLocationToTransform");
                                Iterable $this$first$iv = filesSystemLocationToTransform;
                                boolean $i$f$first = false;
                                for (T element$iv2 : $this$first$iv) {
                                    FileSystemLocation possibleSoFile = (FileSystemLocation)element$iv2;
                                    boolean bl = false;
                                    String string = possibleSoFile.getAsFile().getAbsolutePath();
                                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"possibleSoFile.asFile.absolutePath");
                                    if (!StringsKt.endsWith$default((String)string, (String)".so", (boolean)false, (int)2, null)) continue;
                                    break block1;
                                }
                                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                            }
                            File file = ((FileSystemLocation)element$iv2).getAsFile().getParentFile().getParentFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"filesSystemLocationToTransform.first { possibleSoFile ->\n                                                    possibleSoFile.asFile.absolutePath.endsWith(\".so\")\n                                                }.asFile.parentFile.parentFile");
                            return file;
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"inToTransform.outputs.files.asFileTree.elements.map(\n                                        // do not convert this to lambda otherwise Gradle will fail to restore configuration cache\n                                        object : Transformer<File, Set<FileSystemLocation>> {\n                                            override fun transform(filesSystemLocationToTransform: Set<FileSystemLocation>): File {\n                                                // we want the directory where all architectures live. So to make it generic and\n                                                // work with any native build tool, we will go to any .so file, and then go up from\n                                                // there to the architectures directory. This way we don't have to hardcode any path\n                                                // For example:\n                                                // /Users/.../build/intermediates/embrace/NdkTest/_tmp_/app/build/intermediates/merged_native_libs/release/out/lib/armeabi-v7a/libembrace-native.so\n                                                // the .so file will always be inside its corresponding architecture folder.\n                                                // By going 2 levels up, we will get all available architecture folders\n                                                return filesSystemLocationToTransform.first { possibleSoFile ->\n                                                    possibleSoFile.asFile.absolutePath.endsWith(\".so\")\n                                                }.asFile.parentFile.parentFile\n                                            }\n                                        }\n                                    )");
                    return provider;
                }
            })};
            task.getArchitecturesDirectoryForNative().from(objectArray);
        } else {
            File customSymbolsFile = this$0.getProject().getRootProject().file((Object)customSymbolsDirectory);
            this$0.logger.info(Intrinsics.stringPlus((String)"Custom symbols directory was found. Will look for native symbols at ", (Object)customSymbolsFile.getPath()));
            if (customSymbolsFile.exists()) {
                Object[] objectArray2 = new Object[]{customSymbolsFile};
                task.getArchitecturesDirectoryForNative().from(objectArray2);
            } else {
                String msg = "Can not retrieve native symbols. Custom symbols directory=" + customSymbolsFile.getPath() + " does not exist.\nMake sure native symbols are located in that directory";
                this$0.logger.error(msg);
                throw new SwazzlerException(msg);
            }
        }
    }

    private static final boolean execute$lambda-9$lambda-7(Property $ndkEnabled, Task it) {
        Intrinsics.checkNotNullParameter((Object)$ndkEnabled, (String)"$ndkEnabled");
        Object object = $ndkEnabled.getOrElse((Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ndkEnabled.getOrElse(false)");
        return (Boolean)object;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final NdkUploadTask.NdkType execute$lambda-9$lambda-8(NdkUploadTaskRegistration this$0, TaskContainer $taskContainer, ProjectType it) {
        NdkUploadTask.NdkType ndkType;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ProjectType projectType = it;
        int n = projectType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[projectType.ordinal()];
        switch (n) {
            case 1: {
                ndkType = NdkUploadTask.NdkType.UNITY;
                return ndkType;
            }
            case 2: {
                Object object = (CharSequence)this$0.swazzlerExtension.getCustomSymbolsDirectory().get();
                boolean bl = false;
                boolean bl2 = false;
                if (object == null || object.length() == 0) {
                    Intrinsics.checkNotNullExpressionValue((Object)$taskContainer, (String)"taskContainer");
                    object = this$0.variantExtension;
                    if (object == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
                        throw null;
                    }
                    if (!TaskRegistrationUtilsKt.isTaskRegistered($taskContainer, "externalNativeBuild", ((EmbraceExtensionInternal.VariantExtension)object).getName())) {
                        ndkType = NdkUploadTask.NdkType.UNDEFINED;
                        return ndkType;
                    }
                }
                ndkType = NdkUploadTask.NdkType.NATIVE;
                return ndkType;
            }
        }
        this$0.logger.debug("Failed to configure NDK upload task. Unknown NDK type.");
        ndkType = NdkUploadTask.NdkType.UNDEFINED;
        return ndkType;
    }

    private static final void execute$lambda-9(NdkUploadTaskRegistration this$0, TaskContainer $taskContainer, NdkUploadTask ndkUploadTask) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)ndkUploadTask, (String)"ndkUploadTask");
        this$0.logger.debug("Starting to configure NdkUploadTask");
        Property<Boolean> ndkEnabled = this$0.embraceExtensionInternal.getNdkEnabled();
        ndkUploadTask.onlyIf(arg_0 -> NdkUploadTaskRegistration.execute$lambda-9$lambda-7(ndkEnabled, arg_0));
        ndkUploadTask.getNdkType().set(this$0.embraceExtensionInternal.getProjectType().map(arg_0 -> NdkUploadTaskRegistration.execute$lambda-9$lambda-8(this$0, $taskContainer, arg_0)));
        Object[] objectArray = new Object[]{new Callable<Object>(this$0){
            final /* synthetic */ NdkUploadTaskRegistration this$0;
            {
                this.this$0 = $receiver;
            }

            @NotNull
            public Object call() {
                Object[] objectArray = new TaskProvider[3];
                EmbraceExtensionInternal.VariantExtension variantExtension = NdkUploadTaskRegistration.access$getVariantExtension$p(this.this$0);
                if (variantExtension == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
                    throw null;
                }
                objectArray[0] = TaskRegistrationUtilsKt.tryGetTaskProvider(this.this$0.getProject(), "merge" + StringsKt.capitalize((String)variantExtension.getName()) + "JniLibFolders");
                variantExtension = NdkUploadTaskRegistration.access$getVariantExtension$p(this.this$0);
                if (variantExtension == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
                    throw null;
                }
                objectArray[1] = TaskRegistrationUtilsKt.tryGetTaskProvider(this.this$0.getProject(), Intrinsics.stringPlus((String)"transformNativeLibsWithMergeJniLibsFor", (Object)StringsKt.capitalize((String)variantExtension.getName())));
                variantExtension = NdkUploadTaskRegistration.access$getVariantExtension$p(this.this$0);
                if (variantExtension == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"variantExtension");
                    throw null;
                }
                objectArray[2] = TaskRegistrationUtilsKt.tryGetTaskProvider(this.this$0.getProject(), "merge" + StringsKt.capitalize((String)variantExtension.getName()) + "NativeLibs");
                return CollectionsKt.listOfNotNull((Object[])objectArray);
            }
        }};
        ndkUploadTask.mustRunAfter(objectArray);
    }

    private static final ListProperty getMappingFileFolder$lambda-10(NdkUploadTaskRegistration this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.getProject().getObjects().listProperty(Object.class);
    }

    private static final String getMappingFileFolder$lambda-11() {
        return "";
    }

    private static final String getMappingFileFolder$lambda-12(String flavorName, String buildTypeName) {
        CharSequence charSequence = flavorName;
        boolean bl = false;
        boolean bl2 = false;
        return charSequence == null || charSequence.length() == 0 ? buildTypeName : flavorName + '/' + buildTypeName;
    }

    public static final /* synthetic */ EmbraceExtensionInternal.VariantExtension access$getVariantExtension$p(NdkUploadTaskRegistration $this) {
        return $this.variantExtension;
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProjectType.values().length];
            nArray[ProjectType.UNITY.ordinal()] = 1;
            nArray[ProjectType.NATIVE.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

