/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.ndk;

import com.google.gson.Gson;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.TaskException;
import io.embrace.android.gradle.swazzler.plugin.ndk.NdkUploadTask;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SymbolResourceInjector {
    private static final Logger logger = Logger.newLogger(SymbolResourceInjector.class);
    private static final String KEY_NDK_SYMBOLS = "emb_ndk_symbols";
    private final Gson gson;

    public SymbolResourceInjector(Gson gson2) {
        this.gson = gson2;
    }

    public void writeSymbolResourceFile(File buildInfoFile, Map<String, Map<String, String>> deobfuscatedHashedObjects) throws FileNotFoundException, UnsupportedEncodingException, ParserConfigurationException, TransformerException {
        buildInfoFile.getParentFile().mkdirs();
        try (PrintWriter writer = new PrintWriter(buildInfoFile, StandardCharsets.UTF_8.toString());){
            writer.println(this.buildSymbolResourcesFile(deobfuscatedHashedObjects));
            logger.debug("Symbols successfully added as resources.");
        }
    }

    private String buildSymbolResourcesFile(Map<String, Map<String, String>> deobfuscatedHashedObjects) throws TaskException, ParserConfigurationException, TransformerException {
        logger.debug("About to build symbol resources file");
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = doc.createElement("resources");
        doc.appendChild(root);
        Comment comment = doc.createComment("This file is automatically generated by Embrace");
        root.appendChild(comment);
        NdkUploadTask.NdkSymbolsResource symbolsResource = new NdkUploadTask.NdkSymbolsResource(deobfuscatedHashedObjects);
        String symbols = this.gson.toJson((Object)symbolsResource);
        if (symbols != null && !symbols.isEmpty()) {
            logger.debug(String.format("Symbols raw=\n%s", symbols));
            byte[] bytes = symbols.getBytes(StandardCharsets.UTF_8);
            Base64.Encoder encoder = Base64.getEncoder();
            String encodedSymbols = new String(encoder.encode(bytes));
            logger.debug(String.format("Symbols after encoding=%s", encodedSymbols));
            Element element = doc.createElement("string");
            element.setAttribute("name", KEY_NDK_SYMBOLS);
            element.setTextContent(encodedSymbols);
            root.appendChild(element);
        } else {
            logger.debug("Symbols is null or empty");
        }
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        doc.setXmlVersion("1.0");
        transformer.transform(new DOMSource(doc.getDocumentElement()), result);
        Properties properties = new Properties();
        properties.setProperty("encoding", "UTF-8");
        properties.setProperty("indent", "yes");
        properties.setProperty("standalone", "no");
        transformer.setOutputProperties(properties);
        String output = writer.toString();
        logger.debug(String.format("Symbols output file to be written=\n%s", output));
        return output;
    }
}

