/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.oldtransform;

import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.api.ApplicationVariant;
import io.embrace.android.gradle.swazzler.compile.manifest.SwazzleManifest;
import io.embrace.android.gradle.swazzler.config.Config;
import io.embrace.android.gradle.swazzler.config.SmartDefaultsProvider;
import io.embrace.android.gradle.swazzler.instrumentation.AsmCompatibilityHelper;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporterExtension;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.knownissues.KnownIssuesBuildService;
import io.embrace.android.gradle.swazzler.plugin.knownissues.KnownIssuesBuildServiceKt;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.SwazzleTransform;
import io.embrace.android.gradle.swazzler.plugin.rules.SmartSwazzlingManager;
import io.embrace.android.gradle.swazzler.plugin.rules.SwazzlerRulesFileStorage;
import io.embrace.android.gradle.swazzler.plugin.rules.SwazzlingRulesRegistration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a&\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a0\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0014"}, d2={"registerBuildListenerForTransform", "", "project", "Lorg/gradle/api/Project;", "registerOldTransformTasks", "androidExtension", "Lcom/android/build/gradle/AppExtension;", "swazzlerExtension", "Lio/embrace/android/gradle/swazzler/plugin/extension/SwazzlerExtension;", "config", "Lio/embrace/android/gradle/swazzler/config/Config;", "registerSwazzlerTransformer", "swazzleExtension", "swazzleManifest", "Lio/embrace/android/gradle/swazzler/compile/manifest/SwazzleManifest;", "smartSwazzlingManager", "Lio/embrace/android/gradle/swazzler/plugin/rules/SmartSwazzlingManager;", "registerSwazzlingRules", "", "appExtension", "embrace-swazzler"})
public final class OldTransformTasksKt {
    public static final void registerOldTransformTasks(@NotNull Project project, @NotNull AppExtension androidExtension, @NotNull SwazzlerExtension swazzlerExtension, @NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)androidExtension, (String)"androidExtension");
        Intrinsics.checkNotNullParameter((Object)swazzlerExtension, (String)"swazzlerExtension");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        SwazzleManifest swazzleManifest = SwazzleManifest.buildManifest(config);
        SmartSwazzlingManager smartSwazzlingManager = new SmartSwazzlingManager(new SwazzlerRulesFileStorage(project));
        Intrinsics.checkNotNullExpressionValue((Object)swazzleManifest, (String)"swazzleManifest");
        OldTransformTasksKt.registerSwazzlerTransformer(project, androidExtension, swazzlerExtension, swazzleManifest, smartSwazzlingManager);
        OldTransformTasksKt.registerBuildListenerForTransform(project);
        if (OldTransformTasksKt.registerSwazzlingRules(androidExtension, project, smartSwazzlingManager)) {
            project.getLogger().debug("Successfully registered swazzling rules");
        }
    }

    public static final boolean registerSwazzlingRules(@NotNull AppExtension appExtension, @NotNull Project project, @NotNull SmartSwazzlingManager smartSwazzlingManager) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)appExtension, (String)"appExtension");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)smartSwazzlingManager, (String)"smartSwazzlingManager");
        if (AsmCompatibilityHelper.INSTANCE.shouldUseASM(project)) {
            project.getLogger().debug("Swazzling rules not needed for any variant");
            bl = false;
        } else {
            appExtension.getApplicationVariants().configureEach(arg_0 -> OldTransformTasksKt.registerSwazzlingRules$lambda-0(project, smartSwazzlingManager, arg_0));
            bl = true;
        }
        return bl;
    }

    private static final void registerSwazzlerTransformer(Project project, AppExtension androidExtension, SwazzlerExtension swazzleExtension, SwazzleManifest swazzleManifest, SmartSwazzlingManager smartSwazzlingManager) {
        project.getLogger().info("Registering Swazzle transform.");
        Object object = project.getExtensions().findByType(BuildReporterExtension.class);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (object == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object object2 = object;
        BuildReporterExtension buildReporterExtension = (BuildReporterExtension)object2;
        boolean encodeExtractedFileNames = Intrinsics.areEqual((Object)swazzleExtension.getEncodeExtractedFileNames().get(), (Object)true) ? true : SmartDefaultsProvider.getEncodeExtractedFileNamesSmartDefault();
        androidExtension.registerTransform((Transform)new SwazzleTransform((BaseExtension)androidExtension, swazzleExtension, swazzleManifest, smartSwazzlingManager, (BuildReporter)buildReporterExtension.getBuildReporter().get(), encodeExtractedFileNames), new Object[0]);
        project.getLogger().info("Successfully registered Swazzle transform.");
    }

    private static final void registerBuildListenerForTransform(Project project) {
        KnownIssuesBuildServiceKt.registerKnownIssueBuildService(project, KnownIssuesBuildService.KnownIssueType.IRONSOURCE);
    }

    private static final void registerSwazzlingRules$lambda-0(Project $project, SmartSwazzlingManager $smartSwazzlingManager, ApplicationVariant variant) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$smartSwazzlingManager, (String)"$smartSwazzlingManager");
        $project.getLogger().debug(Intrinsics.stringPlus((String)"Registering swazzling rules tasks for variant=", (Object)variant.getName()));
        SwazzlingRulesRegistration swazzlingRulesRegistration = new SwazzlingRulesRegistration($project, $smartSwazzlingManager);
        Intrinsics.checkNotNullExpressionValue((Object)variant, (String)"variant");
        swazzlingRulesRegistration.execute(variant);
        $project.getLogger().debug(Intrinsics.stringPlus((String)"Successfully registered swazzling rules tasks for variant=", (Object)variant.getName()));
    }
}

