/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.oldtransform;

import com.android.build.api.transform.Context;
import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.Format;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.TransformInvocation;
import com.android.build.api.transform.TransformOutputProvider;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.compile.swazzler.SwazzleExecutor;
import io.embrace.android.gradle.swazzler.compile.swazzler.SwazzleFilter;
import io.embrace.android.gradle.swazzler.compile.swazzler.Swazzler;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import io.embrace.android.gradle.swazzler.plugin.extension.SwazzlerExtension;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.JarInfo;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.SwazzleTransform;
import io.embrace.android.gradle.swazzler.plugin.oldtransform.SwazzleTransformException;
import io.embrace.android.gradle.swazzler.plugin.rules.SmartSwazzlingManager;
import io.embrace.android.gradle.swazzler.util.FileUtils;
import io.embrace.android.gradle.swazzler.util.JarUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javassist.ClassPool;
import org.apache.commons.lang3.Validate;

@Deprecated
abstract class SwazzleTransformer {
    private static final Logger logger = Logger.newLogger(SwazzleTransformer.class);
    protected final SwazzlerExtension swazzlerExtension;
    protected final SmartSwazzlingManager smartSwazzlingManager;
    protected final SwazzleTransform transform;
    protected final ClassPool classPool;
    protected final Swazzler swazzler;
    protected final Boolean encodeExtractedFileNames;
    protected final SwazzleExecutor swazzleExecutor;
    protected Context transformContext;
    private SwazzleFilter jarSwazzleFilter;
    private SwazzleFilter classSwazzleFilter;
    private static final String SWAZZLED_DIRECTORY_PREFIX = "swazzled-";

    SwazzleTransformer(SwazzleTransform transform2, ClassPool classPool, Swazzler swazzler, SwazzlerExtension swazzlerExtension, SmartSwazzlingManager smartSwazzlingManager, Boolean encodeExtractedFileNames) {
        Validate.notNull((Object)smartSwazzlingManager, (String)"Smart swazzling manager is null.", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)transform2), (String)"Transform instance is null.", (Object[])new Object[0]);
        Validate.notNull((Object)classPool, (String)"Class pool instance is null.", (Object[])new Object[0]);
        Validate.notNull((Object)swazzler, (String)"Swazzler instance is null.", (Object[])new Object[0]);
        Validate.notNull((Object)swazzlerExtension, (String)"Swazzler extension is null.", (Object[])new Object[0]);
        Validate.notNull((Object)encodeExtractedFileNames, (String)"Encode extracted file names property is null.", (Object[])new Object[0]);
        this.smartSwazzlingManager = smartSwazzlingManager;
        this.transform = transform2;
        this.classPool = classPool;
        this.swazzler = swazzler;
        this.swazzlerExtension = swazzlerExtension;
        this.encodeExtractedFileNames = encodeExtractedFileNames;
        this.jarSwazzleFilter = new SwazzleFilter((List)swazzlerExtension.getJarSkipList().get(), SwazzleFilter.Kind.JAR);
        this.classSwazzleFilter = new SwazzleFilter((List)swazzlerExtension.getClassSkipList().get(), SwazzleFilter.Kind.CLASS);
        this.swazzleExecutor = new SwazzleExecutor(classPool, swazzler, encodeExtractedFileNames, smartSwazzlingManager);
    }

    void run(TransformInvocation invocation) throws Exception {
        this.transformContext = invocation.getContext();
        logger.info(String.format("Running Swazzle transformation for variant {%s}", this.transformContext.getVariantName()));
    }

    boolean extractJarInput(File destDir, JarInput jarInput) throws SwazzleTransformException {
        File jarFile = jarInput.getFile();
        try {
            logger.debug(String.format("Extracting JAR file {src=%s, dest=%s}.", jarFile, destDir));
            destDir.mkdirs();
            JarUtils.extractJarFileToDirectory(jarFile, destDir, (boolean)this.encodeExtractedFileNames);
            return true;
        }
        catch (IOException e) {
            throw new SwazzleTransformException(String.format("An exception was thrown while extracting the JAR file {file=%s, dest=%s}.", jarFile, destDir), e);
        }
        catch (SecurityException e) {
            logger.warn(String.format("Could not extract Jar file to directory due to a Security exception {file=%s, dest=%s}.", jarFile, destDir), e);
            return false;
        }
    }

    static List<JarInput> dedupeJarInput(List<JarInput> jarInputs) {
        HashSet<String> seen = new HashSet<String>();
        ArrayList<JarInput> out = new ArrayList<JarInput>();
        for (JarInput jarInput : jarInputs) {
            String filename = jarInput.getFile().getAbsolutePath();
            if (seen.contains(filename)) continue;
            seen.add(filename);
            out.add(jarInput);
        }
        return out;
    }

    void swazzleDirectoryInput(TransformOutputProvider outputProvider, DirectoryInput dirInput) throws SwazzleTransformException {
        File srcDir = dirInput.getFile();
        File destDir = this.getOutputFile(outputProvider, dirInput);
        logger.debug(String.format("Swazzling directory input {src=%s, dest=%s}.", srcDir, destDir));
        destDir.mkdirs();
        try {
            this.swazzleDirectory(srcDir.getName(), srcDir, destDir);
        }
        catch (IOException e) {
            throw new SwazzleTransformException(String.format("An exception was thrown while swazzling the directory dependency {src=%s, dest=%s}.", srcDir, destDir), e);
        }
    }

    void cleanCopyJarFile(JarInput jarInput, File jarOutputFile) throws IOException {
        Files.copy(Paths.get(jarInput.getFile().getPath(), new String[0]), Paths.get(jarOutputFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    void swazzleJarInput(TransformOutputProvider outputProvider, JarInput jarInput) throws SwazzleTransformException {
        JarInfo jarInfo = JarUtils.getJarInfo(jarInput);
        try {
            File jarOutputFile = this.getOutputFile(outputProvider, jarInput);
            if (this.shouldSkipJarSwazzling(jarInfo)) {
                logger.debug(String.format("Clean copying JAR {dest=%s}.", jarOutputFile));
                this.cleanCopyJarFile(jarInput, jarOutputFile);
                return;
            }
            logger.debug(String.format("About to Swazzle JAR input {src=%s, dest=%s}.", jarInput.getFile(), jarOutputFile));
            File extractDir = Paths.get(this.transformContext.getTemporaryDir().getPath(), FileUtils.normalizeFileName(jarInput.getName())).toFile();
            File swazzledDir = Paths.get(this.transformContext.getTemporaryDir().getPath(), SWAZZLED_DIRECTORY_PREFIX + FileUtils.normalizeFileName(jarInput.getName())).toFile();
            if (extractDir.exists()) {
                logger.debug("Deleted extraction directory that already existed: " + extractDir.getPath());
                FileUtils.removeDirectory(extractDir);
            }
            if (swazzledDir.exists()) {
                logger.debug("Deleted swazzled directory that already existed: " + swazzledDir.getPath());
                FileUtils.removeDirectory(swazzledDir);
            }
            if (jarOutputFile.exists()) {
                logger.debug("Deleted output JAR file that already existed: " + jarOutputFile);
                Files.delete(Paths.get(jarOutputFile.getPath(), new String[0]));
            }
            jarOutputFile.getParentFile().mkdirs();
            logger.debug(String.format("Swazzling directory {src=%s}.", swazzledDir));
            boolean isJarExtracted = this.extractJarInput(extractDir, jarInput);
            if (isJarExtracted && this.swazzleDirectory(jarInfo.getJarName(), extractDir, swazzledDir)) {
                logger.debug(String.format("Creating JAR file {src=%s, dest=%s}.", swazzledDir, jarOutputFile));
                JarUtils.createJarFileFromDirectory(jarOutputFile, swazzledDir, (boolean)this.encodeExtractedFileNames);
            } else {
                logger.debug(String.format("Clean copying JAR since it did not require modification {src=%s, dest=%s}.", extractDir, jarOutputFile));
                this.cleanCopyJarFile(jarInput, jarOutputFile);
            }
        }
        catch (IOException e) {
            throw new SwazzleTransformException(String.format("An error occurred swazzling the JAR dependency {name:%s , file:%s}", jarInput.getName(), jarInput.getFile()), e);
        }
    }

    private boolean shouldSkipJarSwazzling(JarInfo jarInfo) {
        String message = "Skipping jar {name:%s} Swazzle: %s";
        String jarName = jarInfo.getJarName();
        if (this.swazzlerExtension.isSwazzlingDisabled(this.transformContext.getVariantName())) {
            logger.debug(String.format(message, jarName, "Swazzling disabled."));
            return true;
        }
        if (this.smartSwazzlingManager.shouldSkipJar(jarName)) {
            logger.debug(String.format(message, jarName, "SmartSwazzling defines jar as unnecessary to swazzle."));
            return true;
        }
        if (this.jarSwazzleFilter.shouldSkip(jarName)) {
            logger.info(String.format(message, jarName, String.format("Manually specified jar %s to be skipped during swazzling.", jarName)));
            return true;
        }
        return false;
    }

    boolean swazzleDirectory(String jar, File srcDir, File destDir) throws IOException {
        return this.swazzleDirectory(jar, Paths.get(srcDir.getPath(), new String[0]), Paths.get(destDir.getPath(), new String[0]));
    }

    boolean swazzleDirectory(String jar, Path srcDir, Path destDir) throws IOException {
        logger.debug(String.format("About to swazzle directory {src=%s, dest=%s}.", srcDir, destDir));
        EmbraceSimpleFileVisitor embraceSimpleFileVisitor = new EmbraceSimpleFileVisitor(jar, srcDir, destDir);
        Files.walkFileTree(srcDir, embraceSimpleFileVisitor);
        return embraceSimpleFileVisitor.modifiedJar;
    }

    private boolean shouldSkipClassSwazzling(String jar, String clazz) {
        String message = "Skipping class {%s} Swazzle: %s";
        if (this.swazzlerExtension.isSwazzlingDisabled(this.transformContext.getVariantName())) {
            logger.debug(String.format(message, clazz, "Swazzling disabled."));
            return true;
        }
        if (this.smartSwazzlingManager.shouldSkipClass(jar, clazz)) {
            logger.debug(String.format(message, clazz, "SmartSwazzling defines jar as unnecessary to swazzle."));
            return true;
        }
        if (this.classSwazzleFilter.shouldSkip(clazz)) {
            logger.info(String.format(message, clazz, "Manually specified class to be skipped during swazzling."));
            return true;
        }
        return false;
    }

    File getOutputFile(TransformOutputProvider outputProvider, DirectoryInput dirInput) {
        return outputProvider.getContentLocation(dirInput.getName(), this.transform.getOutputTypes(), dirInput.getScopes(), Format.DIRECTORY);
    }

    File getOutputFile(TransformOutputProvider outputProvider, JarInput jarInput) {
        return outputProvider.getContentLocation(jarInput.getName(), this.transform.getOutputTypes(), jarInput.getScopes(), Format.JAR);
    }

    private class EmbraceSimpleFileVisitor
    extends SimpleFileVisitor<Path> {
        private final String jar;
        private final Path srcDir;
        private final Path destDir;
        public boolean modifiedJar = false;

        EmbraceSimpleFileVisitor(String jar, Path srcDir, Path destDir) {
            this.jar = jar;
            this.srcDir = srcDir;
            this.destDir = destDir;
        }

        @Override
        public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
            String fileName = path.toFile().getName();
            if (!FileUtils.isClassFile(fileName) || SwazzleTransformer.this.shouldSkipClassSwazzling(this.jar, fileName)) {
                logger.debug(String.format("Clean copying file {src=%s}.", path));
                this.cleanCopyOriginalFile(path);
                return FileVisitResult.CONTINUE;
            }
            Path destinationFilePath = this.getDestinationFile(path);
            try {
                logger.debug(String.format("About to swazzle class {src=%s, dest=%s}.", path, destinationFilePath));
                if (SwazzleTransformer.this.swazzleExecutor.swazzleFile(path.toFile(), this.destDir.toFile(), this.jar)) {
                    this.modifiedJar = true;
                    logger.debug(String.format("Swazzled class {src=%s, dest=%s}.", path, destinationFilePath));
                } else {
                    logger.debug(String.format("Nothing to swazzle in the class. Copying original. {src=%s, dest=%s}.", path, destinationFilePath));
                    this.cleanCopyOriginalFile(path);
                }
            }
            catch (SwazzlerException e) {
                logger.info(String.format("An error occurred while swazzling file and will be ignored {src=%s, dest=%s}.", path, destinationFilePath), e);
                this.cleanCopyOriginalFile(path);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes attrs) {
            this.getDestinationFile(path).toFile().mkdirs();
            return FileVisitResult.CONTINUE;
        }

        void cleanCopyOriginalFile(Path path) throws IOException {
            Files.copy(path, this.getDestinationFile(path), StandardCopyOption.REPLACE_EXISTING);
        }

        Path getDestinationFile(Path srcFile) {
            return Paths.get(this.destDir.toString(), this.srcDir.relativize(srcFile).toString());
        }
    }
}

