/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.reactnative;

import com.google.gson.stream.JsonWriter;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.di.DependencyInjectionProvider;
import io.embrace.android.gradle.swazzler.network.EmbraceEndpoint;
import io.embrace.android.gradle.swazzler.network.HttpCallResult;
import io.embrace.android.gradle.swazzler.network.UploadFileParams;
import io.embrace.android.gradle.swazzler.plugin.GradleUploadTask;
import io.embrace.android.gradle.swazzler.plugin.TaskException;
import io.embrace.android.gradle.swazzler.plugin.buildreporter.BuildReporter;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.plugin.reactnative.RnSourcemapPathFinder;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 !2\u00020\u0001:\u0001!B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0017J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u0017H\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R2\u0010\b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00000\u0000 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u00020\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u00020\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\""}, d2={"Lio/embrace/android/gradle/swazzler/plugin/reactnative/EmbraceRnSourcemapGeneratorTask;", "Lio/embrace/android/gradle/swazzler/plugin/GradleUploadTask;", "()V", "buildId", "Lorg/gradle/api/provider/Property;", "", "getBuildId", "()Lorg/gradle/api/provider/Property;", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "reactProperties", "Lorg/gradle/api/provider/MapProperty;", "", "getReactProperties", "()Lorg/gradle/api/provider/MapProperty;", "sourceMapInputFileProperty", "Lorg/gradle/api/file/RegularFileProperty;", "getSourceMapInputFileProperty", "()Lorg/gradle/api/file/RegularFileProperty;", "sourceMapJsonFileProperty", "getSourceMapJsonFileProperty", "generateBundleZipFile", "Ljava/io/File;", "bundleFile", "sourceMapFile", "sourceMapJsonFile", "getProjectLayout", "Lorg/gradle/api/file/ProjectLayout;", "onRun", "", "uploadBundleFiles", "jsonFile", "Companion", "embrace-swazzler"})
public class EmbraceRnSourcemapGeneratorTask
extends GradleUploadTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger<EmbraceRnSourcemapGeneratorTask> logger = Logger.newLogger(EmbraceRnSourcemapGeneratorTask.class);
    @NotNull
    private final RegularFileProperty sourceMapInputFileProperty;
    @NotNull
    private final RegularFileProperty sourceMapJsonFileProperty;
    @NotNull
    private final Property<String> buildId;
    @NotNull
    private final MapProperty<String, Object> reactProperties;
    @NotNull
    public static final String NAME = "embraceRNSourcemapGeneratorFor";
    @NotNull
    private static final String FILE_NAME_SOURCE_MAP_JSON = "sourcemap.json";
    @NotNull
    private static final String KEY_NAME_BUNDLE = "bundle";
    @NotNull
    private static final String KEY_NAME_SOURCE_MAP = "sourcemap";

    public EmbraceRnSourcemapGeneratorTask() {
        RegularFileProperty regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"getObjects().fileProperty()");
        this.sourceMapInputFileProperty = regularFileProperty;
        regularFileProperty = this.getObjects().fileProperty();
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"getObjects().fileProperty()");
        this.sourceMapJsonFileProperty = regularFileProperty;
        regularFileProperty = this.getObjects().property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"getObjects().property(String::class.java)");
        this.buildId = regularFileProperty;
        regularFileProperty = this.getObjects().mapProperty(String.class, Object.class).convention(MapsKt.emptyMap());
        Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"getObjects().mapProperty(\n        String::class.java, Any::class.java\n    ).convention(emptyMap())");
        this.reactProperties = regularFileProperty;
    }

    @Optional
    @InputFile
    @NotNull
    public final RegularFileProperty getSourceMapInputFileProperty() {
        return this.sourceMapInputFileProperty;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getSourceMapJsonFileProperty() {
        return this.sourceMapJsonFileProperty;
    }

    @Input
    @NotNull
    public final Property<String> getBuildId() {
        return this.buildId;
    }

    @Input
    @NotNull
    public final MapProperty<String, Object> getReactProperties() {
        return this.reactProperties;
    }

    @Inject
    @NotNull
    public ProjectLayout getProjectLayout() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void onRun() {
        if (((AndroidCompactedVariantData)this.getVariantInfo().get()).isBuildTypeDebuggable()) {
            String name = ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName();
            this.logger.warn("The variant " + name + " is debuggable, skipping bundle upload");
            return;
        }
        this.logger.info("Starting React native artifacts upload task {app-id=" + this.getAppId().get() + ", api-token=" + this.getApiToken().get() + ", build-id=" + this.buildId.get() + "}.");
        RnSourcemapPathFinder sourceMapFinder = new RnSourcemapPathFinder((Map)this.reactProperties.get(), this.getProjectLayout(), null, 4, null);
        String string = ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        File bundleFile = sourceMapFinder.getBundleFile(string, project);
        if (bundleFile != null && this.sourceMapInputFileProperty.isPresent()) {
            File sourceMapFile = (File)this.sourceMapInputFileProperty.getAsFile().get();
            File sourceMapJsonFile = (File)this.sourceMapJsonFileProperty.getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)sourceMapFile, (String)"sourceMapFile");
            Intrinsics.checkNotNullExpressionValue((Object)sourceMapJsonFile, (String)"sourceMapJsonFile");
            this.uploadBundleFiles(this.generateBundleZipFile(bundleFile, sourceMapFile, sourceMapJsonFile));
        } else {
            this.logger.warn("React native files were not uploaded.");
        }
    }

    private final void uploadBundleFiles(File jsonFile) {
        HttpCallResult uploadResult;
        this.logger.info("About to upload RN bundle files");
        Object object = this.getAppId().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"appId.get()");
        String string = (String)object;
        object = this.getApiToken().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"apiToken.get()");
        UploadFileParams uploadFileParams = new UploadFileParams(EmbraceEndpoint.SOURCE_MAP, string, (String)object, jsonFile, FILE_NAME_SOURCE_MAP_JSON, (String)this.buildId.get());
        HttpCallResult httpCallResult = uploadResult = ((DependencyInjectionProvider)this.getDependencyInjectionProvider().get()).getNetworkService().uploadFile(uploadFileParams);
        if (httpCallResult instanceof HttpCallResult.Success) {
            this.logger.info("React Native sourcemap file was successfully uploaded. \nVariant=" + ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName() + " build_id=" + this.buildId.get() + " \n");
        } else if (httpCallResult instanceof HttpCallResult.Failure) {
            this.logger.warn("Failed to upload React Native sourcemap file. \nVariant=" + ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName() + " build_id=" + this.buildId.get() + ". \nStatus=" + ((HttpCallResult.Failure)uploadResult).getCode() + " Error=" + ((HttpCallResult.Failure)uploadResult).getErrorMessage() + " \n");
        } else if (httpCallResult instanceof HttpCallResult.Error) {
            this.logger.warn("Failed to upload React Native sourcemap file. \nVariant=" + ((AndroidCompactedVariantData)this.getVariantInfo().get()).getName() + " build_id=" + this.buildId.get() + ". \nException=" + ((HttpCallResult.Error)uploadResult).getException() + " \n");
            ((BuildReporter)this.getBuildReporter().get()).onException(((HttpCallResult.Error)uploadResult).getException());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final File generateBundleZipFile(File bundleFile, File sourceMapFile, File sourceMapJsonFile) throws TaskException {
        this.logger.debug("About to zip RN bundle file");
        this.logger.debug(Intrinsics.stringPlus((String)"RN bundle path=", (Object)sourceMapJsonFile));
        sourceMapJsonFile.getParentFile().mkdirs();
        try {
            GZIPOutputStream fos = new GZIPOutputStream(new FileOutputStream(sourceMapJsonFile));
            Closeable closeable = fos;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Closeable closeable2 = closeable;
            int n = 0;
            closeable2 = new OutputStreamWriter((OutputStream)closeable2, charset);
            n = 8192;
            boolean bl2 = false;
            BufferedWriter writer = closeable2 instanceof BufferedWriter ? (BufferedWriter)closeable2 : new BufferedWriter((Writer)closeable2, n);
            closeable = (Closeable)new JsonWriter((Writer)writer);
            boolean bl3 = false;
            bl = false;
            Throwable throwable = null;
            try {
                JsonWriter jsonWriter = (JsonWriter)closeable;
                boolean bl4 = false;
                this.logger.debug("Generating bundle zip file with bundleFile: " + bundleFile + " and sourceMapFile: " + sourceMapFile);
                bl2 = false;
                boolean bl5 = false;
                JsonWriter $this$generateBundleZipFile_u24lambda_u2d1_u24lambda_u2d0 = jsonWriter;
                boolean bl6 = false;
                $this$generateBundleZipFile_u24lambda_u2d1_u24lambda_u2d0.beginObject();
                $this$generateBundleZipFile_u24lambda_u2d1_u24lambda_u2d0.name(KEY_NAME_BUNDLE);
                $this$generateBundleZipFile_u24lambda_u2d1_u24lambda_u2d0.value(FilesKt.readText$default((File)bundleFile, null, (int)1, null));
                $this$generateBundleZipFile_u24lambda_u2d1_u24lambda_u2d0.name(KEY_NAME_SOURCE_MAP);
                $this$generateBundleZipFile_u24lambda_u2d1_u24lambda_u2d0.value(FilesKt.readText$default((File)sourceMapFile, null, (int)1, null));
                closeable2 = $this$generateBundleZipFile_u24lambda_u2d1_u24lambda_u2d0.endObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed generating bundle zip file with bundleFile: " + bundleFile + " and sourceMapFile: " + sourceMapFile);
            throw new TaskException("Failed generating bundle zip file.", e);
        }
        return sourceMapJsonFile;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/reactnative/EmbraceRnSourcemapGeneratorTask$Companion;", "", "()V", "FILE_NAME_SOURCE_MAP_JSON", "", "KEY_NAME_BUNDLE", "KEY_NAME_SOURCE_MAP", "NAME", "embrace-swazzler"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

