/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.reactnative;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.TaskRegisterKt;
import io.embrace.android.gradle.swazzler.plugin.TaskRegistrationUtilsKt;
import io.embrace.android.gradle.swazzler.plugin.extension.EmbraceExtensionInternal;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.plugin.reactnative.EmbraceRnSourcemapGeneratorTask;
import io.embrace.android.gradle.swazzler.plugin.reactnative.RnSourcemapPathFinder;
import io.embrace.android.gradle.swazzler.util.GradleCompatibilityHelper;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.plugins.ExtraPropertiesExtension;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u001e\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00000\u0000 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/reactnative/EmbraceRnSourcemapGeneratorTaskRegistration;", "Lorg/gradle/api/Action;", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "project", "Lorg/gradle/api/Project;", "embraceExtensionInternal", "Lio/embrace/android/gradle/swazzler/plugin/extension/EmbraceExtensionInternal;", "(Lorg/gradle/api/Project;Lio/embrace/android/gradle/swazzler/plugin/extension/EmbraceExtensionInternal;)V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "createRnSourcemapGeneratorTaskProvider", "Lorg/gradle/api/tasks/TaskProvider;", "Lio/embrace/android/gradle/swazzler/plugin/reactnative/EmbraceRnSourcemapGeneratorTask;", "variant", "execute", "", "mapProviderIfFileExists", "Lorg/gradle/api/provider/Provider;", "Lorg/gradle/api/file/RegularFile;", "regularFileProvider", "embrace-swazzler"})
public final class EmbraceRnSourcemapGeneratorTaskRegistration
implements Action<AndroidCompactedVariantData> {
    @NotNull
    private final Project project;
    @NotNull
    private final EmbraceExtensionInternal embraceExtensionInternal;
    private final Logger<EmbraceRnSourcemapGeneratorTaskRegistration> logger;

    public EmbraceRnSourcemapGeneratorTaskRegistration(@NotNull Project project, @NotNull EmbraceExtensionInternal embraceExtensionInternal) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)embraceExtensionInternal, (String)"embraceExtensionInternal");
        this.project = project;
        this.embraceExtensionInternal = embraceExtensionInternal;
        this.logger = Logger.newLogger(EmbraceRnSourcemapGeneratorTaskRegistration.class);
    }

    public void execute(@NotNull AndroidCompactedVariantData variant) {
        Object[] foundTask;
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        this.logger.info("About to register ReactNativeBundleRetrieverTask");
        if (TaskRegistrationUtilsKt.isTaskRegistered(this.project, "embraceRNSourcemapGeneratorFor", variant.getName())) {
            this.logger.debug("Embrace React Native sourcemap generator task found for variant " + variant.getName() + " in the task graph. Skipping task registration.");
            return;
        }
        this.logger.debug("EmbraceRNSourcemapGeneratorTask not registered, will attempt to register it");
        if (variant.isBuildTypeDebuggable()) {
            this.logger.info("This is a Debuggable build, we will skip the Bundle and SourceMap upload.");
            return;
        }
        this.logger.info("This is not a Debuggable build, we will upload the Bundle and SourceMap.");
        String variantCapitalized = StringUtils.capitalize((String)variant.getName());
        String newRNSourceFilesGeneratorTask = "createBundle" + variantCapitalized + "JsAndAssets";
        String oldRNSourceFilesGeneratorTask = "merge" + variantCapitalized + "Resources";
        Object[] objectArray = TaskRegistrationUtilsKt.tryGetTaskProvider(this.project, newRNSourceFilesGeneratorTask);
        Object object = foundTask = objectArray == null ? TaskRegistrationUtilsKt.tryGetTaskProvider(this.project, oldRNSourceFilesGeneratorTask) : objectArray;
        if (foundTask == null || !foundTask.isPresent()) {
            this.logger.warn("We could not find the task that generates the Bundle, please submit the Bundle and SourceMap manually. https://embrace.io/docs/react-native/integration/upload-symbol-files/?platform=android#symbolication-with-codepush");
            return;
        }
        objectArray = foundTask;
        Task task = (Task)objectArray.get();
        objectArray = new Object[]{this.createRnSourcemapGeneratorTaskProvider(variant)};
        task.finalizedBy(objectArray);
    }

    private final TaskProvider<EmbraceRnSourcemapGeneratorTask> createRnSourcemapGeneratorTaskProvider(AndroidCompactedVariantData variant) {
        return TaskRegisterKt.registerTask(this.project, "embraceRNSourcemapGeneratorFor", EmbraceRnSourcemapGeneratorTask.class, variant, arg_0 -> EmbraceRnSourcemapGeneratorTaskRegistration.createRnSourcemapGeneratorTaskProvider$lambda-0(this, variant, arg_0));
    }

    private final Provider<RegularFile> mapProviderIfFileExists(Provider<RegularFile> regularFileProvider) {
        ProviderFactory providerFactory = this.project.getProviders();
        Intrinsics.checkNotNullExpressionValue((Object)providerFactory, (String)"project.providers");
        return GradleCompatibilityHelper.INSTANCE.map(regularFileProvider, providerFactory, EmbraceRnSourcemapGeneratorTaskRegistration::mapProviderIfFileExists$lambda-1);
    }

    private static final void createRnSourcemapGeneratorTaskProvider$lambda-0(EmbraceRnSourcemapGeneratorTaskRegistration this$0, AndroidCompactedVariantData $variant, EmbraceRnSourcemapGeneratorTask rnTask) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)rnTask, (String)"rnTask");
        this$0.logger.info("EmbraceRNSourcemapGeneratorTask Preparing variables to upload the Bundle and the SourceMap");
        try {
            Object object;
            rnTask.getApiToken().set((Provider)this$0.embraceExtensionInternal.getApiToken());
            EmbraceExtensionInternal.VariantExtension variantExtension = (EmbraceExtensionInternal.VariantExtension)this$0.embraceExtensionInternal.getVariants().getByName($variant.getName());
            rnTask.getAppId().set((Provider)variantExtension.getAppId());
            rnTask.getBuildId().set((Provider)variantExtension.getBuildId());
            try {
                object = this$0.project.getExtensions().getExtraProperties().get("react");
                object = object instanceof Map ? (Map)object : null;
            }
            catch (ExtraPropertiesExtension.UnknownPropertyException e) {
                object = null;
            }
            Map reactProperties = object;
            ProjectLayout e = this$0.project.getLayout();
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"project.layout");
            RnSourcemapPathFinder sourcemapFinder = new RnSourcemapPathFinder(reactProperties, e, null, 4, null);
            Provider sourceMapFileProvider = this$0.project.getLayout().getBuildDirectory().file(sourcemapFinder.getEmbraceSourcemapFilePath());
            Provider reactNativeSourceMapFileProvider = this$0.project.getLayout().getBuildDirectory().file(sourcemapFinder.getReactNativeSourcemapFilePath($variant.getSourceMapPath()));
            RegularFileProperty regularFileProperty = rnTask.getSourceMapInputFileProperty();
            Intrinsics.checkNotNullExpressionValue((Object)sourceMapFileProvider, (String)"sourceMapFileProvider");
            Provider<RegularFile> provider = this$0.mapProviderIfFileExists((Provider<RegularFile>)sourceMapFileProvider);
            Intrinsics.checkNotNullExpressionValue((Object)reactNativeSourceMapFileProvider, (String)"reactNativeSourceMapFileProvider");
            regularFileProperty.set(provider.orElse(this$0.mapProviderIfFileExists((Provider<RegularFile>)reactNativeSourceMapFileProvider)));
            rnTask.getSourceMapJsonFileProperty().set(this$0.project.getLayout().getBuildDirectory().file(sourcemapFinder.getSourceMapJson($variant)));
        }
        catch (UnknownDomainObjectException e) {
            this$0.logger.error("EmbraceRNSourcemapGeneratorTask fails preparing variables to upload the Bundle and the SourceMap", e);
        }
        catch (Exception e) {
            this$0.logger.error("EmbraceRNSourcemapGeneratorTask fails getting the Bundle and the SourceMap", e);
        }
    }

    private static final RegularFile mapProviderIfFileExists$lambda-1(RegularFile it) {
        return it.getAsFile().exists() ? it : null;
    }
}

