/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.reactnative;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.plugin.reactnative.RnSourcemapPathFinder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.provider.MissingValueException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B3\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\n\u001a\u00020\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u0003H\u0002J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fJ&\u0010\u0010\u001a\u0004\u0018\u00010\u00042\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u00032\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0006\u0010\u0011\u001a\u00020\u0004J\n\u0010\u0012\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0017J \u0010\u0018\u001a\u0004\u0018\u00010\f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u001a2\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/reactnative/RnSourcemapPathFinder;", "", "reactProps", "", "", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "(Ljava/util/Map;Lorg/gradle/api/file/ProjectLayout;Lio/embrace/android/gradle/swazzler/Logger;)V", "getBundleAssetName", "getBundleFile", "Ljava/io/File;", "variantName", "project", "Lorg/gradle/api/Project;", "getCustomBundleAssetDirectory", "getEmbraceSourcemapFilePath", "getFirstBundleFileFoundedInBuildFolder", "getReactNativeSourcemapFilePath", "variantDirName", "getSourceMapJson", "variantData", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "getValidBundleFile", "jsBundleDirs", "", "bundleAssetName", "logDeprecatedCommands", "", "embrace-swazzler"})
public final class RnSourcemapPathFinder {
    @Nullable
    private final Map<String, Object> reactProps;
    @NotNull
    private final ProjectLayout projectLayout;
    @NotNull
    private final Logger<RnSourcemapPathFinder> logger;

    public RnSourcemapPathFinder(@Nullable Map<String, ? extends Object> reactProps, @NotNull ProjectLayout projectLayout, @NotNull Logger<RnSourcemapPathFinder> logger) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        Intrinsics.checkNotNullParameter(logger, (String)"logger");
        this.reactProps = reactProps;
        this.projectLayout = projectLayout;
        this.logger = logger;
    }

    public /* synthetic */ RnSourcemapPathFinder(Map map2, ProjectLayout projectLayout, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            Logger<RnSourcemapPathFinder> logger2 = Logger.newLogger(RnSourcemapPathFinder.class);
            Intrinsics.checkNotNullExpressionValue(logger2, (String)"newLogger(RnSourcemapPathFinder::class.java)");
            logger = logger2;
        }
        this(map2, projectLayout, logger);
    }

    @NotNull
    public final String getReactNativeSourcemapFilePath(@NotNull String variantDirName) {
        Intrinsics.checkNotNullParameter((Object)variantDirName, (String)"variantDirName");
        String sourceMapsDirPath = Intrinsics.stringPlus((String)"generated/sourcemaps/react/", (Object)variantDirName);
        String bundleAssetName = this.getBundleAssetName(this.reactProps);
        return sourceMapsDirPath + '/' + bundleAssetName + ".map";
    }

    @NotNull
    public final String getEmbraceSourcemapFilePath() {
        this.logDeprecatedCommands();
        String sourceMapsDirPath = "generated/sourcemaps";
        this.logger.debug(Intrinsics.stringPlus((String)"Source map file path=", (Object)sourceMapsDirPath));
        return Intrinsics.stringPlus((String)sourceMapsDirPath, (Object)"/android-embrace.bundle.map");
    }

    private final void logDeprecatedCommands() {
        boolean bl;
        block5: {
            List list;
            Map<String, Object> map2 = this.reactProps;
            Object object = map2 == null ? null : map2.get("extraPackagerArgs");
            List list2 = list = object instanceof List ? (List)object : null;
            if (list == null) {
                return;
            }
            List extraPackagerArgValues = list;
            Iterable $this$any$iv = extraPackagerArgValues;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"--sourcemap-output", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.logger.warn("DEPRECATED: The command --sourcemap-output will be deprecated. Please remove that from your app/build.gradle extraPackagerArgs");
        }
    }

    private final File getValidBundleFile(List<String> jsBundleDirs, String bundleAssetName) {
        Iterable $this$forEach$iv = jsBundleDirs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            RegularFile regularFile = (RegularFile)this.projectLayout.getBuildDirectory().file(((File)this.projectLayout.getBuildDirectory().getAsFile().get()).getPath() + '/' + it + '/' + bundleAssetName).getOrNull();
            File fileFound = regularFile == null ? null : regularFile.getAsFile();
            if (fileFound == null || !fileFound.exists()) continue;
            return fileFound;
        }
        return null;
    }

    private final File getFirstBundleFileFoundedInBuildFolder() {
        Object object = this.projectLayout.getBuildDirectory().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"projectLayout.buildDirectory.asFile.get()");
        return (File)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)((Sequence)FilesKt.walk$default((File)((File)object), null, (int)1, null)), (Function1)getFirstBundleFileFoundedInBuildFolder.1.INSTANCE));
    }

    @Nullable
    public final File getBundleFile(@NotNull String variantName, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)variantName, (String)"variantName");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String capitalizedVariantName = StringUtils.capitalize((String)variantName);
        Intrinsics.checkNotNullExpressionValue((Object)capitalizedVariantName, (String)"capitalizedVariantName");
        String customBundleAssetDir = this.getCustomBundleAssetDirectory(this.reactProps, capitalizedVariantName);
        boolean bl = false;
        ArrayList<String> jsBundleDirs = new ArrayList<String>();
        CharSequence charSequence = customBundleAssetDir;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            jsBundleDirs.add(customBundleAssetDir);
        }
        String bundleAssetName = this.getBundleAssetName(this.reactProps);
        if (project.getExtensions().findByName("react") != null) {
            jsBundleDirs.add("/generated/assets/createBundle" + capitalizedVariantName + "JsAndAssets");
            jsBundleDirs.add("/ASSETS/createBundle" + capitalizedVariantName + "JsAndAssets");
        } else {
            jsBundleDirs.add(Intrinsics.stringPlus((String)"/generated/assets/react/", (Object)variantName));
        }
        File bundleFile = this.getValidBundleFile((List<String>)jsBundleDirs, bundleAssetName);
        if (bundleFile == null) {
            bundleFile = this.getFirstBundleFileFoundedInBuildFolder();
        }
        return bundleFile;
    }

    private final String getCustomBundleAssetDirectory(Map<String, ?> reactProps, String variantName) {
        String customBundleAssetDirectoryKey = Intrinsics.stringPlus((String)"jsBundleDir", (Object)variantName);
        this.logger.debug(Intrinsics.stringPlus((String)"Looking for custom bundle asset directory with key: ", (Object)customBundleAssetDirectoryKey));
        try {
            Object obj;
            String bundleAssetDirectory;
            Map<String, ?> map2 = reactProps;
            String string = map2 == null ? null : (bundleAssetDirectory = (obj = map2.get(customBundleAssetDirectoryKey)) == null ? null : obj.toString());
            if (bundleAssetDirectory != null) {
                this.logger.debug(Intrinsics.stringPlus((String)"Custom bundle asset directory found: ", (Object)bundleAssetDirectory));
                return bundleAssetDirectory;
            }
        }
        catch (MissingValueException e) {
            this.logger.debug("No value available for the custom bundle asset directory provider");
        }
        return null;
    }

    private final String getBundleAssetName(Map<String, ?> reactProps) {
        String string;
        Object obj;
        Map<String, ?> map2 = reactProps;
        return map2 == null ? "index.android.bundle" : ((obj = map2.get("bundleAssetName")) == null ? "index.android.bundle" : ((string = obj.toString()) == null ? "index.android.bundle" : string));
    }

    @NotNull
    public final String getSourceMapJson(@NotNull AndroidCompactedVariantData variantData) {
        Intrinsics.checkNotNullParameter((Object)variantData, (String)"variantData");
        String flavorName = variantData.getFlavorName();
        String buildTypeName = variantData.getBuildTypeName();
        String bundleFileFolder = StringsKt.isBlank((CharSequence)flavorName) ? buildTypeName : flavorName + '/' + buildTypeName;
        return "outputs/embrace/" + bundleFileFolder + "/sourcemap.json";
    }
}

