/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.resourcesinjection;

import com.google.common.base.Charsets;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import io.embrace.android.gradle.swazzler.Logger;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class ResourceInjector {
    private static final Logger logger = Logger.newLogger(ResourceInjector.class);
    public static final String FILE_BUILD_INFO_XML = "build_info.xml";
    private static final String BUILD_INFO_APP_ID = "emb_app_id";
    private static final String BUILD_INFO_NDK_ENABLED = "emb_ndk_enabled";
    private static final String BUILD_INFO_SDK_CONFIG = "emb_sdk_config";
    private static final String BUILD_INFO_BUILD_ID = "emb_build_id";
    private static final String BUILD_INFO_BUILD_TYPE = "emb_build_type";
    private static final String BUILD_INFO_BUILD_FLAVOR = "emb_build_flavor";

    public void writeBuildInfoFile(File generatedBuildInfoDir, Configuration config) throws IOException {
        File buildDir = new File(generatedBuildInfoDir, "values");
        if (!buildDir.exists() && !buildDir.mkdirs()) {
            throw new IOException(String.format("Build info %s directory does not exist and could not be created.", buildDir));
        }
        logger.debug(String.format("Build info %s directory successfully created.", buildDir));
        String buildInfoXmlContent = this.getValuesContent(config);
        logger.debug(String.format("Build info xml content:\n %s", buildInfoXmlContent));
        Files.asCharSink((File)new File(buildDir, FILE_BUILD_INFO_XML), (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)buildInfoXmlContent);
        logger.debug("Build info xml file successfully created and updated.");
    }

    private String getValuesContent(Configuration config) {
        StringBuilder sb = new StringBuilder(256);
        Map<String, String> resValues = this.handleResValues(config);
        sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n");
        sb.append("<resources xmlns:tools=\"http://schemas.android.com/tools\">\n");
        sb.append("<!--This file is automatically generated by Embrace-->\n");
        for (Map.Entry<String, String> entry : resValues.entrySet()) {
            sb.append("    <string name=\"").append(entry.getKey()).append("\"");
            sb.append(">").append(entry.getValue()).append("</string>\n");
        }
        sb.append("</resources>\n");
        return sb.toString();
    }

    private Map<String, String> handleResValues(Configuration config) {
        logger.debug("Starting to generate resources values map");
        TreeMap<String, String> resValues = new TreeMap<String, String>();
        resValues.put(BUILD_INFO_APP_ID, config.getAppId());
        resValues.put(BUILD_INFO_NDK_ENABLED, String.valueOf(config.getNdkEnabled()));
        String sdkConfig = config.getSdkConfig();
        if (sdkConfig != null && !sdkConfig.isEmpty()) {
            byte[] bytes = sdkConfig.getBytes(StandardCharsets.UTF_8);
            Base64.Encoder encoder = Base64.getEncoder();
            String encodedConfig = new String(encoder.encode(bytes));
            resValues.put(BUILD_INFO_SDK_CONFIG, encodedConfig);
        }
        resValues.put(BUILD_INFO_BUILD_ID, config.getBuildId());
        resValues.put(BUILD_INFO_BUILD_TYPE, config.getBuildTypeName());
        if (config.getFlavorName() != null && !config.getFlavorName().isEmpty()) {
            resValues.put(BUILD_INFO_BUILD_FLAVOR, config.getFlavorName());
        }
        logger.debug("Resources values map successfully generated");
        return resValues;
    }

    static interface Configuration {
        public String getAppId();

        public Boolean getNdkEnabled();

        @Nullable
        public String getSdkConfig();

        public String getBuildTypeName();

        @Nullable
        public String getFlavorName();

        public String getBuildId();
    }
}

