/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.rules;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import io.embrace.android.gradle.swazzler.plugin.rules.EmptySwazzlingRules;
import io.embrace.android.gradle.swazzler.plugin.rules.SwazzlerRulesStorage;
import io.embrace.android.gradle.swazzler.plugin.rules.SwazzlingRules;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.gradle.api.Project;

@Deprecated
public class SwazzlerRulesFileStorage
implements SwazzlerRulesStorage {
    private static final String SWAZZLING_RULES_PATH = "%s/embrace-swazzling-rules.json";
    private final Project project;
    private Logger logger;

    public SwazzlerRulesFileStorage(Project project) {
        this.project = project;
    }

    @Override
    public void deleteSwazzlingRulesFile() {
        try {
            Files.delete(Paths.get(this.getSwazzlingRulesFilePath(), new String[0]));
        }
        catch (FileNotFoundException ignored) {
            this.logger.info("Cannot delete swazzling rules file since it does not exist.");
        }
        catch (IOException e) {
            this.logger.info("Failed deleting swazzling rules", e);
        }
    }

    @Override
    public void saveSwazzlingRules(SwazzlingRules swazzlingRules) {
        String swazzlingRulesFilePath = this.getSwazzlingRulesFilePath();
        this.logger.debug(String.format("About to save swazzling rules at path=%s", swazzlingRulesFilePath));
        File swazzlingRulesFile = new File(swazzlingRulesFilePath);
        try (FileWriter fileWriter = new FileWriter(swazzlingRulesFile);){
            fileWriter.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)swazzlingRules));
            fileWriter.flush();
        }
        catch (IOException e) {
            throw new SwazzlerException("Writing the swazzling rules file failed.", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SwazzlingRules loadSwazzlingRules() {
        try (FileReader rulesFileReader = new FileReader(this.getSwazzlingRulesFilePath());){
            GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapter(SwazzlingRules.class, (Object)new SwazzlingRules.SwazzlingRulesDeserializer());
            SwazzlingRules swazzlingRules = (SwazzlingRules)gsonBuilder.create().fromJson((Reader)rulesFileReader, SwazzlingRules.class);
            if (swazzlingRules == null) {
                this.logger.warn("Failed loading Smart swazzling rules.");
                EmptySwazzlingRules emptySwazzlingRules = new EmptySwazzlingRules();
                return emptySwazzlingRules;
            }
            this.logger.info("Smart swazzling rules found.");
            SwazzlingRules swazzlingRules2 = swazzlingRules;
            return swazzlingRules2;
        }
        catch (JsonIOException | JsonSyntaxException e) {
            this.logger.warn(String.format("Failed decoding Swazzling Rules File %s ; skipping step.", e));
            return new EmptySwazzlingRules();
        }
        catch (IOException | NoClassDefFoundError ignored) {
            this.logger.info("Smart swazzling rules not found; skipping step.");
        }
        return new EmptySwazzlingRules();
    }

    @Override
    public void withLogger(Logger logger) {
        this.logger = logger;
    }

    private String getSwazzlingRulesFilePath() {
        return String.format(SWAZZLING_RULES_PATH, this.project.getProjectDir().getAbsolutePath());
    }
}

