/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.rules;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.annotations.SerializedName;
import io.embrace.android.gradle.swazzler.Logger;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

@Deprecated
public class SwazzlingRules {
    private static final String RULES_VERSION_KEY = "v";
    private static final String RULES_KEY = "r";
    private static final String JAR_WILDCARD = "*";
    private static final Logger logger = Logger.newLogger(SwazzlingRules.class);
    @SerializedName(value="v")
    private final int version = 2;
    @SerializedName(value="r")
    private final TreeMap<String, TreeSet<String>> swazzlingRules;

    SwazzlingRules(TreeMap<String, TreeSet<String>> swazzledElements, TreeMap<String, TreeSet<String>> unswazzledElements) {
        for (Map.Entry<String, TreeSet<String>> artifact : unswazzledElements.entrySet()) {
            if (swazzledElements.containsKey(artifact.getKey())) continue;
            artifact.getValue().clear();
            artifact.getValue().add(JAR_WILDCARD);
        }
        this.swazzlingRules = unswazzledElements;
    }

    public boolean shouldSkipJar(String jarInput) {
        return this.swazzlingRules.containsKey(jarInput) && this.swazzlingRules.get(jarInput).size() == 1 && this.swazzlingRules.get(jarInput).contains(JAR_WILDCARD);
    }

    public boolean shouldSkipClass(String jarPackage, String name) {
        return this.swazzlingRules.containsKey(jarPackage) && this.swazzlingRules.get(jarPackage).contains(name) || this.shouldSkipJar(jarPackage);
    }

    static class SwazzlingRulesDeserializer
    implements JsonDeserializer<SwazzlingRules> {
        SwazzlingRulesDeserializer() {
        }

        public SwazzlingRules deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject rules = json.getAsJsonObject();
            if (!rules.has(SwazzlingRules.RULES_VERSION_KEY)) {
                logger.warn("Warning: deprecated swazzling rules detected. The smart swazzling is disabled. Please clean the current swazzling rules and generate new ones to align to the new api.");
                return null;
            }
            return (SwazzlingRules)new Gson().fromJson((JsonElement)rules, SwazzlingRules.class);
        }
    }
}

