/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.plugin.rules;

import com.android.build.gradle.api.ApplicationVariant;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.plugin.TaskRegisterKt;
import io.embrace.android.gradle.swazzler.plugin.TaskRegistrationUtilsKt;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import io.embrace.android.gradle.swazzler.plugin.rules.EmbraceProjectCleanTask;
import io.embrace.android.gradle.swazzler.plugin.rules.SmartSwazzlingManager;
import io.embrace.android.gradle.swazzler.plugin.rules.SwazzlingRulesCleanerTask;
import io.embrace.android.gradle.swazzler.plugin.rules.SwazzlingRulesGeneratorTask;
import io.embrace.android.gradle.swazzler.testcheckpoints.SwazzlerTestCheckPoints;
import io.embrace.android.gradle.swazzler.testcheckpoints.TestCheckpointsExtension;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Deprecated(message="Old transform api is deprecated and replaced by ASM when possible.")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R2\u0010\b\u001a&\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00000\u0000 \n*\u0012\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \n*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/embrace/android/gradle/swazzler/plugin/rules/SwazzlingRulesRegistration;", "Lorg/gradle/api/Action;", "Lcom/android/build/gradle/api/ApplicationVariant;", "project", "Lorg/gradle/api/Project;", "smartSwazzlingManager", "Lio/embrace/android/gradle/swazzler/plugin/rules/SmartSwazzlingManager;", "(Lorg/gradle/api/Project;Lio/embrace/android/gradle/swazzler/plugin/rules/SmartSwazzlingManager;)V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "testCheckpoints", "Lio/embrace/android/gradle/swazzler/testcheckpoints/SwazzlerTestCheckPoints;", "execute", "", "variant", "embrace-swazzler"})
public final class SwazzlingRulesRegistration
implements Action<ApplicationVariant> {
    @NotNull
    private final Project project;
    @NotNull
    private final SmartSwazzlingManager smartSwazzlingManager;
    private final Logger<SwazzlingRulesRegistration> logger;
    private final SwazzlerTestCheckPoints testCheckpoints;

    public SwazzlingRulesRegistration(@NotNull Project project, @NotNull SmartSwazzlingManager smartSwazzlingManager) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)smartSwazzlingManager, (String)"smartSwazzlingManager");
        this.project = project;
        this.smartSwazzlingManager = smartSwazzlingManager;
        this.logger = Logger.newLogger(SwazzlingRulesRegistration.class);
        Object object = this.project.getExtensions().findByType(TestCheckpointsExtension.class);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (object == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.testCheckpoints = (SwazzlerTestCheckPoints)((TestCheckpointsExtension)object).getTestCheckpoints().get();
    }

    public void execute(@NotNull ApplicationVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        try {
            this.logger.info("Registering swazzling rules tasks");
            TaskProvider<EmbraceProjectCleanTask> embraceProjectCleanTask = TaskRegisterKt.registerTask(this.project, "cleanEmbraceProjectFor", EmbraceProjectCleanTask.class, AndroidCompactedVariantData.Companion.from(variant), null);
            TaskProvider<SwazzlingRulesCleanerTask> rulesCleanerTask = TaskRegisterKt.registerTask(this.project, "cleanEmbraceSwazzlingRulesFor", SwazzlingRulesCleanerTask.class, AndroidCompactedVariantData.Companion.from(variant), arg_0 -> SwazzlingRulesRegistration.execute$lambda-0(this, arg_0));
            TaskProvider<SwazzlingRulesGeneratorTask> rulesGeneratorTask = TaskRegisterKt.registerTask(this.project, "generateEmbraceSwazzlingRulesFor", SwazzlingRulesGeneratorTask.class, AndroidCompactedVariantData.Companion.from(variant), arg_0 -> SwazzlingRulesRegistration.execute$lambda-1(this, arg_0));
            embraceProjectCleanTask.configure(arg_0 -> SwazzlingRulesRegistration.execute$lambda-2(this, rulesCleanerTask, embraceProjectCleanTask, arg_0));
            rulesCleanerTask.configure(arg_0 -> SwazzlingRulesRegistration.execute$lambda-3(this, variant, rulesCleanerTask, arg_0));
            rulesGeneratorTask.configure(arg_0 -> SwazzlingRulesRegistration.execute$lambda-4(embraceProjectCleanTask, rulesCleanerTask, this, variant, rulesGeneratorTask, arg_0));
            this.logger.info("Swazzling rules tasks successfully registered");
        }
        catch (UnknownTaskException e) {
            this.logger.info("Missing dependent Gradle task(s). Skipping registration of Gradle task: name=generateEmbraceSwazzlingRulesFor, variant=" + variant.getName() + '.');
            this.testCheckpoints.exception((Exception)((Object)e));
        }
    }

    private static final void execute$lambda-0(SwazzlingRulesRegistration this$0, SwazzlingRulesCleanerTask rulesCleanerTask) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        rulesCleanerTask.getSmartSwazzlingManagerProperty().set((Object)this$0.smartSwazzlingManager);
    }

    private static final void execute$lambda-1(SwazzlingRulesRegistration this$0, SwazzlingRulesGeneratorTask rulesGeneratorTask) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        rulesGeneratorTask.getSmartSwazzlingManagerProperty().set((Object)this$0.smartSwazzlingManager);
    }

    private static final void execute$lambda-2(SwazzlingRulesRegistration this$0, TaskProvider $rulesCleanerTask, TaskProvider $embraceProjectCleanTask, EmbraceProjectCleanTask task) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rulesCleanerTask, (String)"$rulesCleanerTask");
        Intrinsics.checkNotNullParameter((Object)$embraceProjectCleanTask, (String)"$embraceProjectCleanTask");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Object[] objectArray = new Object[]{TaskRegistrationUtilsKt.tryGetTaskProvider(this$0.project, "preBuild")};
        task.finalizedBy(objectArray);
        objectArray = new Object[]{TaskRegistrationUtilsKt.tryGetTaskProvider(this$0.project, "clean")};
        task.dependsOn(objectArray);
        objectArray = new Object[]{$rulesCleanerTask};
        task.finalizedBy(objectArray);
        this$0.logger.debug(Intrinsics.stringPlus((String)"Successfully configured Gradle task: ", (Object)$embraceProjectCleanTask.getName()));
    }

    private static final void execute$lambda-3(SwazzlingRulesRegistration this$0, ApplicationVariant $variant, TaskProvider $rulesCleanerTask, SwazzlingRulesCleanerTask task) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)$rulesCleanerTask, (String)"$rulesCleanerTask");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Object[] objectArray = new Object[1];
        Project project = this$0.project;
        String string = $variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        objectArray[0] = TaskRegistrationUtilsKt.tryGetTaskProvider(project, Intrinsics.stringPlus((String)"transformClassesWithSwazzleFor", (Object)StringsKt.capitalize((String)string)));
        task.finalizedBy(objectArray);
        this$0.logger.debug(Intrinsics.stringPlus((String)"Successfully configured Gradle task: ", (Object)$rulesCleanerTask.getName()));
    }

    private static final void execute$lambda-4(TaskProvider $embraceProjectCleanTask, TaskProvider $rulesCleanerTask, SwazzlingRulesRegistration this$0, ApplicationVariant $variant, TaskProvider $rulesGeneratorTask, SwazzlingRulesGeneratorTask task) {
        Intrinsics.checkNotNullParameter((Object)$embraceProjectCleanTask, (String)"$embraceProjectCleanTask");
        Intrinsics.checkNotNullParameter((Object)$rulesCleanerTask, (String)"$rulesCleanerTask");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)$rulesGeneratorTask, (String)"$rulesGeneratorTask");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Object[] objectArray = new Object[]{$embraceProjectCleanTask};
        task.dependsOn(objectArray);
        objectArray = new Object[]{$rulesCleanerTask};
        task.dependsOn(objectArray);
        objectArray = new Object[1];
        Project project = this$0.project;
        String string = $variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        objectArray[0] = TaskRegistrationUtilsKt.tryGetTaskProvider(project, Intrinsics.stringPlus((String)"assemble", (Object)StringsKt.capitalize((String)string)));
        task.dependsOn(objectArray);
        this$0.logger.debug(Intrinsics.stringPlus((String)"Successfully configured Gradle task: ", (Object)$rulesGeneratorTask.getName()));
    }
}

