/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.util;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.internal.dsl.DefaultConfig;
import com.android.builder.model.ApiVersion;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Task;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0004J\u0014\u0010\u0011\u001a\u00020\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/embrace/android/gradle/swazzler/util/AgpUtils;", "", "()V", "MINIMUM_DESUGARING_LEVEL", "", "getMinSdk", "defaultConfig", "Lcom/android/build/gradle/internal/dsl/DefaultConfig;", "(Lcom/android/build/gradle/internal/dsl/DefaultConfig;)Ljava/lang/Integer;", "getMinSdkVersion", "Lcom/android/builder/model/ApiVersion;", "isDesugaringEnabled", "", "androidExtension", "Lcom/android/build/gradle/AppExtension;", "isDesugaringRequired", "sdkLevel", "isDexguard", "nativeObfuscationTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "embrace-swazzler"})
public final class AgpUtils {
    @NotNull
    public static final AgpUtils INSTANCE = new AgpUtils();
    private static final int MINIMUM_DESUGARING_LEVEL = 23;

    private AgpUtils() {
    }

    public final boolean isDesugaringRequired(int sdkLevel) {
        return sdkLevel <= 23;
    }

    public final boolean isDesugaringRequired(@NotNull ApiVersion sdkLevel) {
        Intrinsics.checkNotNullParameter((Object)sdkLevel, (String)"sdkLevel");
        return sdkLevel.getApiLevel() <= 23;
    }

    public final boolean isDesugaringEnabled(@NotNull AppExtension androidExtension) {
        Intrinsics.checkNotNullParameter((Object)androidExtension, (String)"androidExtension");
        Boolean bl = androidExtension.getCompileOptions().getCoreLibraryDesugaringEnabled();
        return bl == null ? false : bl;
    }

    @Nullable
    public final Integer getMinSdk(@NotNull DefaultConfig defaultConfig) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)defaultConfig, (String)"defaultConfig");
        try {
            n = defaultConfig.getMinSdk();
        }
        catch (NoSuchMethodError e) {
            n = null;
        }
        return n;
    }

    @Nullable
    public final ApiVersion getMinSdkVersion(@NotNull DefaultConfig defaultConfig) {
        ApiVersion apiVersion;
        Intrinsics.checkNotNullParameter((Object)defaultConfig, (String)"defaultConfig");
        try {
            apiVersion = defaultConfig.getMinSdkVersion();
        }
        catch (NoSuchMethodError e) {
            apiVersion = null;
        }
        return apiVersion;
    }

    public final boolean isDexguard(@NotNull TaskProvider<Task> nativeObfuscationTask) {
        Intrinsics.checkNotNullParameter(nativeObfuscationTask, (String)"nativeObfuscationTask");
        String string = nativeObfuscationTask.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nativeObfuscationTask.name");
        boolean bl = false;
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
        return StringsKt.contains$default((CharSequence)string2, (CharSequence)"dexguard", (boolean)false, (int)2, null);
    }
}

