/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.util;

import io.embrace.android.gradle.swazzler.plugin.SwazzlerException;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Enumeration;
import java.util.List;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;

public final class FileUtils {
    static final String FILE_NAME_ILLEGAL_CHARS_REGEX = "[<>:\"/\\\\\\|\\?\\*]";
    static final String FILE_NAME_ILLEGAL_CHARS_REPLACEMENT = "_";

    private FileUtils() {
    }

    /*
     * Exception decompiling
     */
    public static String readFileFromResources(String path) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> getResourceFiles(String prefixPath) throws SwazzlerException {
        if (prefixPath == null) {
            throw new IllegalArgumentException("Prefix filepath cannot be null.");
        }
        ArrayList<String> files = new ArrayList<String>();
        try (ZipFile jarFile = new ZipFile(new File(FileUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getAbsoluteFile());){
            Enumeration<? extends ZipEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String filepath = entry.getName();
                if (entry.isDirectory() || !filepath.startsWith(prefixPath)) continue;
                files.add(filepath);
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new SwazzlerException("Failed to obtain resources file list registered with the JAR file.", e);
        }
        return files;
    }

    public static void removeDirectory(File dir) throws IOException {
        Files.walkFileTree(Paths.get(dir.getPath(), new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path path, IOException e) throws IOException {
                Files.delete(path);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static String normalizeFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        return fileName.replaceAll(FILE_NAME_ILLEGAL_CHARS_REGEX, FILE_NAME_ILLEGAL_CHARS_REPLACEMENT);
    }

    public static boolean fileExistsAtPath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("Filepath is null or blank.");
        }
        File file = new File(path);
        return file.exists() && file.isFile();
    }

    public static File getFileAtPath(String path) {
        if (StringUtils.isBlank((CharSequence)path)) {
            throw new IllegalArgumentException("Filepath is null or blank.");
        }
        return FileUtils.fileExistsAtPath(path) ? new File(path) : null;
    }

    public static boolean isClassFile(String fileName) {
        return FileUtils.isPlainClassFile(fileName) || FileUtils.isEncodedClassFile(fileName);
    }

    public static boolean isPlainClassFile(String fileName) {
        return fileName.endsWith(".class");
    }

    public static boolean isEncodedClassFile(String fileName) {
        return fileName.endsWith(".swzenc");
    }

    public static String encodeFileName(String fileName) {
        return FileUtils.transcodeName(fileName, FileUtils::encodeBase64, ".class", ".swzenc");
    }

    public static String decodeFileName(String fileName) {
        return FileUtils.transcodeName(fileName, FileUtils::decodeBase64, ".swzenc", ".class");
    }

    private static String transcodeName(String name, Function<String, String> transcode, String fromExtension, String toExtension) {
        int extensionStartIdx;
        StringBuilder result = new StringBuilder();
        int classNameStartIdx = 0;
        if (name.contains("/")) {
            classNameStartIdx = name.lastIndexOf(47) + 1;
            result.append(name, 0, classNameStartIdx);
        }
        String className = name.substring(classNameStartIdx, (extensionStartIdx = name.lastIndexOf(fromExtension)) == -1 ? name.length() : extensionStartIdx);
        result.append(transcode.apply(className));
        result.append(toExtension);
        return result.toString();
    }

    private static String encodeBase64(String className) {
        return Base64.getEncoder().encodeToString(className.getBytes(StandardCharsets.UTF_8));
    }

    private static String decodeBase64(String className) {
        return new String(Base64.getDecoder().decode(className.getBytes(StandardCharsets.UTF_8)));
    }
}

