/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.util;

import com.android.build.api.variant.AndroidComponentsExtension;
import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.util.GradleCompatibilityHelper;
import io.embrace.android.gradle.swazzler.util.GradleVersion;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.Transformer;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\b0\fJ \u0010\r\u001a\b\u0012\u0004\u0012\u0002H\b0\f\"\u0004\b\u0000\u0010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0002J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u000fJH\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00150\f\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\b0\f2\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u0018\u001a\u0014\u0012\b\b\u0001\u0012\u0004\u0018\u0001H\u0015\u0012\u0006\b\u0000\u0012\u0002H\b0\u0019J\u0016\u0010\u001a\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001b*\u00020\u001cJ\"\u0010\u001d\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010!0\fR6\u0010\u0003\u001a*\u0012\u000e\b\u0001\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000 \u0005*\u0014\u0012\u000e\b\u0001\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lio/embrace/android/gradle/swazzler/util/GradleCompatibilityHelper;", "", "()V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "add", "", "T", "self", "Lorg/gradle/api/provider/HasMultipleValues;", "provider", "Lorg/gradle/api/provider/Provider;", "forUseAtConfigurationTime", "isGradleAffectedByIssue19252", "", "isGradleAffectedByIssue22331", "isGradleAffectedByIssue7902", "isGradlePropertyAvailable", "isZipSupported", "map", "S", "providerFactory", "Lorg/gradle/api/provider/ProviderFactory;", "transformer", "Lorg/gradle/api/Transformer;", "androidComponents", "Lcom/android/build/api/variant/AndroidComponentsExtension;", "Lorg/gradle/api/Project;", "fileProvider", "Lorg/gradle/api/file/RegularFileProperty;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "Ljava/io/File;", "embrace-swazzler"})
public final class GradleCompatibilityHelper {
    @NotNull
    public static final GradleCompatibilityHelper INSTANCE = new GradleCompatibilityHelper();
    private static final Logger<? extends GradleCompatibilityHelper> logger = Logger.newLogger(INSTANCE.getClass());

    private GradleCompatibilityHelper() {
    }

    @NotNull
    public final <T> Provider<T> forUseAtConfigurationTime(@NotNull Provider<T> provider) {
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        if (GradleVersion.Companion.isAtLeast(GradleVersion.GRADLE_6_5.INSTANCE) && GradleVersion.Companion.isBelow(GradleVersion.GRADLE_7_4.INSTANCE)) {
            logger.debug("Gradle version is between 6.5 and 7.4, we are forced to use provider.forUseAtConfigurationTime.");
            Provider provider2 = provider.forUseAtConfigurationTime();
            Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"provider.forUseAtConfigurationTime()");
            return provider2;
        }
        logger.debug("Gradle version is below 6.5, or greater than 7.4. forUseAtConfigurationTime is either not needed or not supported");
        return provider;
    }

    public final boolean isZipSupported() {
        return GradleVersion.Companion.isAtLeast(GradleVersion.GRADLE_6_6.INSTANCE);
    }

    public final boolean isGradlePropertyAvailable() {
        return GradleVersion.Companion.isAtLeast(GradleVersion.GRADLE_6_2.INSTANCE);
    }

    public final <T> void add(@NotNull HasMultipleValues<T> self, @NotNull Provider<? extends T> provider) {
        Intrinsics.checkNotNullParameter(self, (String)"self");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        if (this.isGradleAffectedByIssue22331()) {
            self.addAll(provider.map(GradleCompatibilityHelper::add$lambda-0));
        } else {
            self.add(provider);
        }
    }

    @NotNull
    public final <S, T> Provider<S> map(@NotNull Provider<T> provider, @NotNull ProviderFactory providerFactory, @NotNull Transformer<? extends S, ? super T> transformer) {
        Provider provider2;
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)providerFactory, (String)"providerFactory");
        Intrinsics.checkNotNullParameter(transformer, (String)"transformer");
        if (this.isGradleAffectedByIssue7902()) {
            Provider provider3 = provider.flatMap(arg_0 -> GradleCompatibilityHelper.map$lambda-2(transformer, providerFactory, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)provider3, (String)"{\n            provider.flatMap {\n                val transformedResult = transformer.transform(it)\n                if (transformedResult == null) {\n                    providerFactory.provider { null }\n                } else {\n                    providerFactory.provider { transformedResult }\n                }\n            }\n        }");
            provider2 = provider3;
        } else {
            Provider provider4 = provider.map(transformer);
            Intrinsics.checkNotNullExpressionValue((Object)provider4, (String)"{\n            provider.map(transformer)\n        }");
            provider2 = provider4;
        }
        return provider2;
    }

    public final boolean isGradleAffectedByIssue19252() {
        return GradleVersion.Companion.isBelow(GradleVersion.GRADLE_8_4.INSTANCE);
    }

    private final boolean isGradleAffectedByIssue22331() {
        return GradleVersion.Companion.isBelow(GradleVersion.GRADLE_8_0.INSTANCE);
    }

    private final boolean isGradleAffectedByIssue7902() {
        return GradleVersion.Companion.isBelow(GradleVersion.GRADLE_6_2.INSTANCE);
    }

    @NotNull
    public final RegularFileProperty fileProvider(@NotNull RegularFileProperty $this$fileProvider, @NotNull ProjectLayout projectLayout, @NotNull Provider<File> fileProvider) {
        RegularFileProperty regularFileProperty;
        Intrinsics.checkNotNullParameter((Object)$this$fileProvider, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        Intrinsics.checkNotNullParameter(fileProvider, (String)"fileProvider");
        try {
            regularFileProperty = $this$fileProvider.fileProvider(fileProvider);
            Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty, (String)"{\n            this.fileProvider(fileProvider)\n        }");
        }
        catch (NoSuchMethodError e) {
            RegularFileProperty regularFileProperty2 = $this$fileProvider.convention(projectLayout.file(fileProvider));
            Intrinsics.checkNotNullExpressionValue((Object)regularFileProperty2, (String)"{\n            // old gradle, RegularFileProperty.fileProvider not available\n            this.convention(projectLayout.file(fileProvider))\n        }");
            regularFileProperty = regularFileProperty2;
        }
        return regularFileProperty;
    }

    @NotNull
    public final AndroidComponentsExtension<?, ?, ?> androidComponents(@NotNull Project $this$androidComponents) {
        Intrinsics.checkNotNullParameter((Object)$this$androidComponents, (String)"<this>");
        Object object = $this$androidComponents.getExtensions().getByType(AndroidComponentsExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.extensions.getByType(AndroidComponentsExtension::class.java)");
        return (AndroidComponentsExtension)object;
    }

    private static final List add$lambda-0(Object it) {
        return Collections.singletonList(it);
    }

    private static final Object map$lambda-2$lambda-1(Object $transformedResult) {
        return $transformedResult;
    }

    private static final Provider map$lambda-2(Transformer $transformer, ProviderFactory $providerFactory, Object it) {
        Intrinsics.checkNotNullParameter((Object)$transformer, (String)"$transformer");
        Intrinsics.checkNotNullParameter((Object)$providerFactory, (String)"$providerFactory");
        Object transformedResult = $transformer.transform(it);
        return transformedResult == null ? $providerFactory.provider((Callable)map.1.1.INSTANCE) : $providerFactory.provider(() -> GradleCompatibilityHelper.map$lambda-2$lambda-1(transformedResult));
    }
}

