/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.util;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.plugins.PluginContainer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lio/embrace/android/gradle/swazzler/util/ReactNativeUtils;", "", "()V", "isReactNative", "", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "isReactNativeWithNewVariant", "project", "Lorg/gradle/api/Project;", "embrace-swazzler"})
public final class ReactNativeUtils {
    @NotNull
    public static final ReactNativeUtils INSTANCE = new ReactNativeUtils();

    private ReactNativeUtils() {
    }

    public final boolean isReactNative(@NotNull ProjectLayout projectLayout) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        File rootFile = projectLayout.getProjectDirectory().getAsFile().getParentFile().getParentFile();
        File nodeModules = new File(Intrinsics.stringPlus((String)rootFile.getPath(), (Object)"/node_modules"));
        File nodeModulesEmbrace = new File(Intrinsics.stringPlus((String)nodeModules.getPath(), (Object)"/react-native"));
        return nodeModulesEmbrace.exists();
    }

    public final boolean isReactNativeWithNewVariant(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            boolean hasReactPlugin = false;
            PluginContainer pluginContainer = project.getPlugins();
            Intrinsics.checkNotNullExpressionValue((Object)pluginContainer, (String)"project.plugins");
            Iterable $this$forEach$iv = (Iterable)pluginContainer;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Plugin it = (Plugin)element$iv;
                boolean bl = false;
                if (it.getClass().getSimpleName().equals("ReactPlugin")) {
                    hasReactPlugin = true;
                }
                if (!hasReactPlugin) continue;
            }
            return hasReactPlugin;
        }
        catch (Exception e) {
            return false;
        }
    }
}

