/*
 * Decompiled with CFR 0.152.
 */
package io.embrace.android.gradle.swazzler.util;

import io.embrace.android.gradle.swazzler.Logger;
import io.embrace.android.gradle.swazzler.config.unity.UnityConfig;
import io.embrace.android.gradle.swazzler.config.unity.UnitySymbolsDir;
import io.embrace.android.gradle.swazzler.plugin.model.AndroidCompactedVariantData;
import java.io.File;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.file.Directory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\b\u0012\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J+\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0017J*\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u0018\u0010\u001b\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J$\u0010\u001c\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J.\u0010\u001d\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\bH\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u0012\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J$\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u0010H\u0002R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000 \u0005*\u0012\u0012\f\u0012\n \u0005*\u0004\u0018\u00010\u00000\u0000\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lio/embrace/android/gradle/swazzler/util/UnitySymbolFilesManager;", "", "()V", "logger", "Lio/embrace/android/gradle/swazzler/Logger;", "kotlin.jvm.PlatformType", "extractSoFilesFromZipFile", "", "Ljava/io/File;", "objFolder", "buildDir", "Lorg/gradle/api/file/Directory;", "variantData", "Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;", "(Ljava/io/File;Lorg/gradle/api/file/Directory;Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;)[Ljava/io/File;", "getCustomSymbolsArchiveName", "", "unityConfig", "Lio/embrace/android/gradle/swazzler/config/unity/UnityConfig;", "getMappingFileFolder", "getSymbolFiles", "unitySymbolsDir", "Lio/embrace/android/gradle/swazzler/config/unity/UnitySymbolsDir;", "(Lio/embrace/android/gradle/swazzler/config/unity/UnitySymbolsDir;Lorg/gradle/api/file/Directory;Lio/embrace/android/gradle/swazzler/plugin/model/AndroidCompactedVariantData;)[Ljava/io/File;", "getSymbolsDir", "realProjectDirectory", "projectDirectory", "getUncompressedUnityFilesPath", "getUnitySymbolsArchive", "getUnitySymbolsArchiveFromExportDir", "projectDir", "exportDir", "getUnitySymbolsDir", "getUnityTempSymbolsDir", "searchSymbolsArchive", "customArchiveName", "Factory", "embrace-swazzler"})
public final class UnitySymbolFilesManager {
    @NotNull
    public static final Factory Factory = new Factory(null);
    private final Logger<UnitySymbolFilesManager> logger = Logger.newLogger(UnitySymbolFilesManager.class);
    private static UnitySymbolFilesManager INSTANCE;

    private UnitySymbolFilesManager() {
    }

    @Nullable
    public final UnitySymbolsDir getSymbolsDir(@NotNull Directory realProjectDirectory, @NotNull Directory projectDirectory, @NotNull AndroidCompactedVariantData variantData, @Nullable UnityConfig unityConfig) {
        Intrinsics.checkNotNullParameter((Object)realProjectDirectory, (String)"realProjectDirectory");
        Intrinsics.checkNotNullParameter((Object)projectDirectory, (String)"projectDirectory");
        Intrinsics.checkNotNullParameter((Object)variantData, (String)"variantData");
        this.logger.debug(Intrinsics.stringPlus((String)"Project at path=", (Object)realProjectDirectory.getAsFile().getAbsolutePath()));
        File unitySymbolsArchiveFile = this.getUnitySymbolsArchive(projectDirectory, variantData, unityConfig);
        if (unitySymbolsArchiveFile != null) {
            this.logger.debug("Unity symbols archive file found");
            return new UnitySymbolsDir(unitySymbolsArchiveFile, true);
        }
        this.logger.debug("Unity symbols archive file not found");
        File unitySymbolsDir = this.getUnitySymbolsDir(projectDirectory);
        if (unitySymbolsDir != null) {
            this.logger.debug("Unity symbols dir found");
            return new UnitySymbolsDir(unitySymbolsDir, false);
        }
        this.logger.debug("Unity symbols dir not found");
        File unityTempSymbolsDir = this.getUnityTempSymbolsDir(realProjectDirectory);
        if (unityTempSymbolsDir != null) {
            this.logger.debug("unityTempSymbols Dir found");
            return new UnitySymbolsDir(unityTempSymbolsDir, false);
        }
        this.logger.debug("unityTempSymbols Dir not found");
        this.logger.debug("No Unity symbols found for project at path=" + realProjectDirectory.getAsFile().getAbsolutePath() + ". The project is not a Unity project or symbols file was not exported.");
        return new UnitySymbolsDir(null, false, 3, null);
    }

    @Nullable
    public final File[] getSymbolFiles(@NotNull UnitySymbolsDir unitySymbolsDir, @NotNull Directory buildDir, @NotNull AndroidCompactedVariantData variantData) {
        Intrinsics.checkNotNullParameter((Object)unitySymbolsDir, (String)"unitySymbolsDir");
        Intrinsics.checkNotNullParameter((Object)buildDir, (String)"buildDir");
        Intrinsics.checkNotNullParameter((Object)variantData, (String)"variantData");
        File[] listOfArch = null;
        if (unitySymbolsDir.isDirPresent() && unitySymbolsDir.getZippedSymbols()) {
            File file = unitySymbolsDir.getUnitySymbolsDir();
            this.logger.debug(Intrinsics.stringPlus((String)"Attempting to use symbols from symbols.zip in ", (Object)(file == null ? null : file.getPath())));
            listOfArch = this.extractSoFilesFromZipFile(unitySymbolsDir.getUnitySymbolsDir(), buildDir, variantData);
        } else {
            File file = unitySymbolsDir.getUnitySymbolsDir();
            this.logger.debug(Intrinsics.stringPlus((String)"Attempting to use symbols from ", (Object)(file == null ? null : file.getPath())));
            file = unitySymbolsDir.getUnitySymbolsDir();
            listOfArch = file == null ? null : file.listFiles();
        }
        return listOfArch;
    }

    private final File getUnitySymbolsArchive(Directory projectDirectory, AndroidCompactedVariantData variantData, UnityConfig unityConfig) {
        File file;
        File projectDir = projectDirectory.getAsFile().getParentFile();
        this.logger.debug("Attempting to find Unity symbols archive {projectPath=" + projectDir.getPath() + ", variant=" + variantData.getName() + '}');
        if (projectDir != null) {
            this.logger.debug(Intrinsics.stringPlus((String)"Project dir=", (Object)projectDir.getPath()));
            File exportDir = projectDir.getParentFile();
            file = this.getUnitySymbolsArchiveFromExportDir(variantData, unityConfig, projectDir, exportDir);
        } else {
            this.logger.debug("Project dir is null");
            file = null;
        }
        return file;
    }

    private final File getUnitySymbolsArchiveFromExportDir(AndroidCompactedVariantData variantData, UnityConfig unityConfig, File projectDir, File exportDir) {
        File file;
        if (exportDir == null) {
            this.logger.debug("Export dir is null");
            return null;
        }
        this.logger.debug(Intrinsics.stringPlus((String)"Export dir=", (Object)exportDir.getPath()));
        String customArchiveName = this.getCustomSymbolsArchiveName(variantData, unityConfig);
        File symbolsArchive = this.searchSymbolsArchive(projectDir, exportDir, customArchiveName);
        File exportDirParent = exportDir.getParentFile();
        if (symbolsArchive == null && exportDirParent != null) {
            symbolsArchive = this.searchSymbolsArchive(projectDir, exportDirParent, customArchiveName);
        }
        if (symbolsArchive == null) {
            String string;
            File file2;
            this.logger.debug("No Unity symbols archive found {path=" + exportDir.getPath() + " or path=" + ((file2 = exportDirParent) == null ? "" : ((string = file2.getPath()) == null ? "" : string)) + '}');
            file = null;
        } else {
            this.logger.info(Intrinsics.stringPlus((String)"Unity symbols archive found {path=", (Object)symbolsArchive.getPath()));
            file = symbolsArchive;
        }
        return file;
    }

    private final File searchSymbolsArchive(File projectDir, File exportDir, String customArchiveName) {
        File[] fileArray;
        String defaultArchiveName = projectDir.getName();
        this.logger.debug("Searching for Unity symbols archive {customName=" + customArchiveName + ", defaultName=" + defaultArchiveName + ", path=" + exportDir + '}');
        File foundFile = null;
        try {
            fileArray = exportDir.listFiles();
            if (fileArray != null) {
                File[] $this$forEach$iv = fileArray;
                boolean $i$f$forEach = false;
                File[] fileArray2 = $this$forEach$iv;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    String string;
                    File element$iv;
                    File file = element$iv = fileArray2[i];
                    boolean bl = false;
                    if (customArchiveName != null) {
                        string = file.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                        if (StringsKt.startsWith$default((String)string, (String)customArchiveName, (boolean)false, (int)2, null)) {
                            string = file.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                            if (StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) {
                                foundFile = file;
                                continue;
                            }
                        }
                    }
                    string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"symbols", (boolean)false, (int)2, null)) continue;
                    string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".zip", (boolean)false, (int)2, null)) continue;
                    string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    Intrinsics.checkNotNullExpressionValue((Object)defaultArchiveName, (String)"defaultArchiveName");
                    if (!StringsKt.startsWith$default((String)string, (String)defaultArchiveName, (boolean)false, (int)2, null)) continue;
                    foundFile = file;
                }
            }
        }
        catch (Exception ex) {
            this.logger.debug("Error searching for Unity symbols archive.", ex);
        }
        if (foundFile != null) {
            fileArray = foundFile;
            this.logger.debug(Intrinsics.stringPlus((String)"Found symbols archive, with path=", (Object)fileArray.getPath()));
        } else {
            this.logger.info("Didn't found symbols archive {path=" + exportDir + '}');
        }
        return foundFile;
    }

    private final File getUnityTempSymbolsDir(Directory projectDirectory) {
        File file;
        try {
            File file2;
            File realProjectDir = projectDirectory.getAsFile().getParentFile();
            String[] stringArray = new String[]{"StagingArea", "symbols"};
            File symbolsDir = Paths.get(realProjectDir.getPath(), stringArray).toFile();
            this.logger.debug("Attempting to find symbols in Unity temp build directory {at projectPath=" + realProjectDir.getPath() + ", path=" + symbolsDir.getName() + '}');
            if (symbolsDir.exists()) {
                this.logger.info("Unity symbols found in build directory {at projectPath=" + realProjectDir.getPath() + ", path=" + symbolsDir.getAbsoluteFile() + '}');
                file2 = symbolsDir;
            } else {
                this.logger.debug("symbolsDir does not exist");
                file2 = null;
            }
            file = file2;
        }
        catch (UnsupportedOperationException e) {
            file = null;
        }
        return file;
    }

    private final File getUnitySymbolsDir(Directory projectDirectory) {
        try {
            File launcherParentDir = projectDirectory.getAsFile().getParentFile();
            this.logger.debug(Intrinsics.stringPlus((String)"Real project dir=", (Object)launcherParentDir.getPath()));
            String[] stringArray = new String[]{"unityLibrary", "symbols"};
            File symbolsDir = Paths.get(launcherParentDir.getPath(), stringArray).toFile();
            this.logger.debug("Attempting to find symbols in unityLibrary/symbols directory {at projectPath=" + launcherParentDir.getPath() + ", path=" + symbolsDir.getName() + '}');
            if (symbolsDir.exists()) {
                this.logger.info("Unity symbols found in build directory {at projectPath=" + launcherParentDir.getPath() + ", path=" + symbolsDir.getAbsoluteFile() + '}');
                return symbolsDir;
            }
            this.logger.debug("symbolsDir does not exist");
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
        this.logger.debug("Unity symbols dir not found");
        return null;
    }

    private final String getCustomSymbolsArchiveName(AndroidCompactedVariantData variantData, UnityConfig unityConfig) {
        String customArchiveName = null;
        if (unityConfig != null) {
            if (unityConfig.getSymbolsArchiveName() != null) {
                CharSequence charSequence = unityConfig.getSymbolsArchiveName();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"unityConfig.symbolsArchiveName");
                charSequence = charSequence;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    customArchiveName = unityConfig.getSymbolsArchiveName();
                    this.logger.info("Using configured Unity symbols archive name {archiveName=" + customArchiveName + ", variant=" + variantData.getName() + '}');
                } else {
                    this.logger.debug("Unity symbols archive name is empty");
                }
            } else {
                this.logger.debug("Unity symbols archive name is null");
            }
        } else {
            this.logger.debug("Unity config is null");
        }
        if (customArchiveName != null) {
            this.logger.debug(Intrinsics.stringPlus((String)"Custom symbols archive name=", customArchiveName));
        } else {
            this.logger.debug("Custom symbols archive name is null");
        }
        return customArchiveName;
    }

    /*
     * Exception decompiling
     */
    private final File[] extractSoFilesFromZipFile(File objFolder, Directory buildDir, AndroidCompactedVariantData variantData) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final String getUncompressedUnityFilesPath(Directory buildDir, AndroidCompactedVariantData variantData) {
        return buildDir.getAsFile().getAbsoluteFile() + "/intermediates/embrace/unity/" + this.getMappingFileFolder(variantData);
    }

    private final String getMappingFileFolder(AndroidCompactedVariantData variantData) {
        return StringsKt.isBlank((CharSequence)variantData.getFlavorName()) ? variantData.getBuildTypeName() : variantData.getFlavorName() + '/' + variantData.getBuildTypeName();
    }

    public /* synthetic */ UnitySymbolFilesManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/embrace/android/gradle/swazzler/util/UnitySymbolFilesManager$Factory;", "", "()V", "INSTANCE", "Lio/embrace/android/gradle/swazzler/util/UnitySymbolFilesManager;", "of", "embrace-swazzler"})
    public static final class Factory {
        private Factory() {
        }

        @NotNull
        public final UnitySymbolFilesManager of() {
            UnitySymbolFilesManager unitySymbolFilesManager;
            if (INSTANCE == null) {
                INSTANCE = new UnitySymbolFilesManager(null);
            }
            if ((unitySymbolFilesManager = INSTANCE) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"INSTANCE");
                throw null;
            }
            return unitySymbolFilesManager;
        }

        public /* synthetic */ Factory(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

